/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.api.J2SEBuildPropertiesProvider;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.ui.JFXApplicationClassChooser;
import org.netbeans.modules.javafx2.project.ui.JFXRunPanel;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JFXActionProvider
implements ActionProvider {
    private static final Logger LOG = Logger.getLogger(JFXActionProvider.class.getName());
    private final Project prj;
    private boolean isJSAvailable = true;
    private boolean isJSAvailableChecked = false;
    private static final Map<String, String> ACTIONS = new HashMap<String, String>(){
        {
            this.put("build", "jfx-build");
            this.put("rebuild", "jfx-rebuild");
            this.put("run", "run");
            this.put("debug", "debug");
            this.put("profile", "profile");
        }
    };
    private static final Map<String, String> RUN_ACTIONS = new HashMap<String, String>(){
        {
            this.put("run", "run");
            this.put("debug", "debug");
            this.put("profile", "profile");
        }
    };

    public JFXActionProvider(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.prj = project;
    }

    @NonNull
    public String[] getSupportedActions() {
        return ACTIONS.keySet().toArray(new String[ACTIONS.size()]);
    }

    public void invokeAction(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        if (command != null) {
            Properties props;
            if (RUN_ACTIONS.containsKey(command) && JFXProjectUtils.isFXPreloaderProject(this.prj)) {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFXActionProvider.class, (String)"WARN_PreloaderExecutionUnsupported", (Object)ProjectUtils.getInformation((Project)this.prj).getDisplayName()), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                return;
            }
            FileObject buildFo = this.findBuildXml();
            assert (buildFo != null && buildFo.isValid());
            String noScript = this.isJavaScriptAvailable() ? "" : "-noscript";
            String runAs = JFXProjectUtils.getFXProjectRunAs(this.prj);
            if (runAs == null) {
                runAs = JFXProjectProperties.RunAsType.STANDALONE.getString();
            }
            if ((props = this.verifyApplicationClass()) != null) {
                final ActionProgress listener = ActionProgress.start((Lookup)context);
                try {
                    HashMap<String, List<String>> targetReplacements = JFXActionProvider.loadTargetsFromConfig(this.prj);
                    List<String> targets = (List<String>)targetReplacements.get(command);
                    if (targets == null) {
                        targets = command.equalsIgnoreCase("build") || command.equalsIgnoreCase("rebuild") ? Collections.singletonList(ACTIONS.get(command).concat(noScript)) : (runAs.equalsIgnoreCase(JFXProjectProperties.RunAsType.STANDALONE.getString()) ? Collections.singletonList("jfxsa-".concat(ACTIONS.get(command)).concat(noScript)) : (runAs.equalsIgnoreCase(JFXProjectProperties.RunAsType.ASWEBSTART.getString()) ? Collections.singletonList("jfxws-".concat(ACTIONS.get(command)).concat(noScript)) : Collections.singletonList("jfxbe-".concat(ACTIONS.get(command)).concat(noScript))));
                    }
                    this.collectStartupExtenderArgs(props, command, context);
                    Set<String> concealedProperties = this.collectAdditionalBuildProperties(props, command, context);
                    ActionUtils.runTarget((FileObject)buildFo, (String[])targets.toArray(new String[targets.size()]), (Properties)props, concealedProperties).addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            listener.finished(((ExecutorTask)task).result() == 0);
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    listener.finished(false);
                }
            }
        } else {
            throw new IllegalArgumentException(command);
        }
    }

    public boolean isActionEnabled(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        if (JFXActionProvider.isFXProject(this.prj)) {
            if (this.findBuildXml() == null) {
                return false;
            }
            return JFXActionProvider.findTarget(command) != null;
        }
        return false;
    }

    @NonNull
    private static String getBuildXmlName(@NonNull PropertyEvaluator evaluator) {
        String buildScriptPath = evaluator.getProperty("buildfile");
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    @NonNull
    private static HashMap<String, List<String>> loadTargetsFromConfig(@NonNull Project project) {
        HashMap<String, List<String>> targets = new HashMap<String, List<String>>(6);
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)project.getLookup().lookup(J2SEPropertyEvaluator.class);
        PropertyEvaluator evaluator = ep.evaluator();
        String config = evaluator.getProperty("config");
        FileObject propFO = project.getProjectDirectory().getFileObject("nbproject/configs/" + config + ".properties");
        if (propFO == null) {
            return targets;
        }
        Properties props = new Properties();
        try (InputStream is = propFO.getInputStream();){
            props.load(is);
        }
        catch (IOException ex) {
            LOG.warning(ex.getMessage());
            return targets;
        }
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String tNameVal;
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith("$target.") || (tNameVal = props.getProperty(propName)) == null || tNameVal.equals("")) continue;
            String cmdNameKey = propName.substring("$target.".length());
            StringTokenizer stok = new StringTokenizer(tNameVal.trim(), " ");
            ArrayList<String> targetNames = new ArrayList<String>(3);
            while (stok.hasMoreTokens()) {
                targetNames.add(stok.nextToken());
            }
            targets.put(cmdNameKey, targetNames.isEmpty() ? null : targetNames);
        }
        return targets;
    }

    @CheckForNull
    private FileObject findBuildXml() {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)this.prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        assert (ep != null);
        return this.prj.getProjectDirectory().getFileObject(JFXActionProvider.getBuildXmlName(ep.evaluator()));
    }

    @CheckForNull
    private static String findTarget(@NonNull String command) {
        return ACTIONS.get(command);
    }

    private void collectStartupExtenderArgs(Map<? super String, ? super String> p, String command, Lookup context) {
        StringBuilder b = new StringBuilder();
        for (String arg : this.runJvmargsIde(command, context)) {
            b.append(' ').append(arg);
        }
        if (b.length() > 0) {
            p.put("run.jvmargs.ide", b.toString());
        }
    }

    @NonNull
    private Set<String> collectAdditionalBuildProperties(@NonNull Map<? super String, ? super String> p, @NonNull String command, @NonNull Lookup context) {
        HashSet concealedProperties = new HashSet();
        for (J2SEBuildPropertiesProvider pp : this.prj.getLookup().lookupAll(J2SEBuildPropertiesProvider.class)) {
            Map contrib = pp.createAdditionalProperties(command, context);
            assert (contrib != null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "J2SEBuildPropertiesProvider: {0} added following build properties: {1}", new Object[]{pp.getClass(), contrib});
            }
            p.putAll(contrib);
            Set concealedContrib = pp.createConcealedProperties(command, context);
            assert (concealedContrib != null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "J2SEBuildPropertiesProvider: {0} added following concealed properties: {1}", new Object[]{pp.getClass(), concealedContrib});
            }
            concealedProperties.addAll(concealedContrib);
        }
        return Collections.unmodifiableSet(concealedProperties);
    }

    private List<String> runJvmargsIde(String command, Lookup context) {
        StartupExtender.StartMode mode;
        if (command.equals("run") || command.equals("run.single")) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if (command.equals("debug") || command.equals("debug.single") || command.equals("debug.stepinto")) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if (command.equals("profile") || command.equals("profile.single")) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if (command.equals("test") || command.equals("test.single")) {
            mode = StartupExtender.StartMode.TEST_NORMAL;
        } else if (command.equals("debug.test.single")) {
            mode = StartupExtender.StartMode.TEST_DEBUG;
        } else if (command.equals("profile.test.single")) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        for (StartupExtender group : StartupExtender.getExtenders((Lookup)context, (StartupExtender.StartMode)mode)) {
            args.addAll(group.getArguments());
        }
        return args;
    }

    private boolean isJavaScriptAvailable() {
        if (this.isJSAvailableChecked) {
            return this.isJSAvailable;
        }
        ScriptEngineManager mgr = new ScriptEngineManager();
        List<ScriptEngineFactory> factories = mgr.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            List<String> engNames = factory.getNames();
            for (String name : engNames) {
                if (!name.equalsIgnoreCase("js") && !name.equalsIgnoreCase("javascript")) continue;
                this.isJSAvailableChecked = true;
                this.isJSAvailable = true;
                return this.isJSAvailable;
            }
        }
        this.isJSAvailableChecked = true;
        this.isJSAvailable = false;
        return this.isJSAvailable;
    }

    private Properties verifyApplicationClass() {
        Set<String> appClassNames;
        final JButton okButton = new JButton(NbBundle.getMessage(JFXRunPanel.class, (String)"LBL_ChooseMainClass_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXRunPanel.class, (String)"AD_ChooseMainClass_OK"));
        boolean FXinSwing = JFXProjectUtils.isFXinSwingProject(this.prj);
        final Map<FileObject, List<ClassPath>> classpathMap = JFXProjectUtils.getClassPathMap(this.prj);
        if (FXinSwing) {
            appClassNames = JFXProjectUtils.getMainClassNames(this.prj);
        } else {
            final AtomicBoolean cancel = new AtomicBoolean();
            final AtomicReference result = new AtomicReference(Collections.emptySet());
            try {
                BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!cancel.get()) {
                            Set<String> appClasses = JFXProjectUtils.getAppClassNames(classpathMap, "javafx.application.Application");
                            result.set(appClasses);
                        }
                    }
                }, (String)NbBundle.getMessage(JFXActionProvider.class, (String)"TXT_ActionInProgress"), (AtomicBoolean)cancel, (boolean)true);
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.INFO, "Canceled operation did not finish in time.", ex);
            }
            appClassNames = result.get();
        }
        PropertyEvaluator eval = ((J2SEPropertyEvaluator)this.prj.getLookup().lookup(J2SEPropertyEvaluator.class)).evaluator();
        String appClassName = eval.getProperty(FXinSwing ? "main.class" : "javafx.main.class");
        Properties props = new Properties();
        if (!(JFXProjectUtils.isFXPreloaderProject(this.prj) || appClassName != null && appClassNames.contains(appClassName))) {
            final JFXApplicationClassChooser panel = new JFXApplicationClassChooser(this.prj, eval);
            Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        okButton.doClick();
                    } else {
                        okButton.setEnabled(panel.getSelectedClass() != null);
                    }
                }
            });
            okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(JFXRunPanel.class, (String)(FXinSwing ? "LBL_ChooseMainClass_Title_Swing" : "LBL_ChooseMainClass_Title")), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                try {
                    JFXProjectUtils.updatePropertyInActiveConfig(this.prj, FXinSwing ? "main.class" : "javafx.main.class", panel.getSelectedClass());
                    props.setProperty(FXinSwing ? "main.class" : "javafx.main.class", panel.getSelectedClass());
                }
                catch (IOException e) {
                    props = null;
                }
            } else {
                props = null;
            }
            dlg.dispose();
        }
        return props;
    }

    private static boolean isFXProject(@NonNull Project prj) {
        J2SEPropertyEvaluator eval = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (eval == null) {
            return false;
        }
        return JFXActionProvider.isTrue(eval.evaluator().getProperty("javafx.enabled"));
    }

    private static boolean isTrue(@NullAllowed String value) {
        return value != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value));
    }
}

