/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.browser.Browser;
import org.netbeans.modules.subversion.remote.ui.history.SearchExecutor;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SearchCriteriaPanel
extends JPanel {
    private final VCSFileProxy[] roots;
    private final SVNUrl url;
    final JTextField tfFrom = new JTextField();
    final JTextField tfTo = new JTextField();

    public SearchCriteriaPanel(VCSFileProxy[] roots) {
        this.roots = roots;
        this.url = null;
        this.initComponents();
    }

    public SearchCriteriaPanel(SVNUrl url) {
        this.url = url;
        this.roots = null;
        this.initComponents();
    }

    public SVNRevision getFrom() {
        String s = this.tfFrom.getText().trim();
        if (s.length() == 0) {
            return new SVNRevision.Number(1L);
        }
        return this.toRevision(s);
    }

    public SVNRevision getTo() {
        String s = this.tfTo.getText().trim();
        if (s.length() == 0) {
            return SVNRevision.HEAD;
        }
        return this.toRevision(s);
    }

    private Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < SearchExecutor.dateFormats.length; ++i) {
            DateFormat dateformat = SearchExecutor.dateFormats[i];
            try {
                Date date = dateformat.parse(s);
                if (!s.equals(dateformat.format(date))) continue;
                return date;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private SVNRevision toRevision(String s) {
        Date date = this.parseDate(s);
        if (date != null) {
            return new SVNRevision.DateSpec(date);
        }
        if ("BASE".equals(s)) {
            return SVNRevision.BASE;
        }
        if ("HEAD".equals(s)) {
            return SVNRevision.HEAD;
        }
        try {
            return new SVNRevision.Number(Long.parseLong(s));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void setFrom(String from) {
        if (from == null) {
            from = "";
        }
        this.tfFrom.setText(from);
    }

    public void setTo(String to) {
        if (to == null) {
            to = "";
        }
        this.tfTo.setText(to);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchCriteriaPanel.this.tfFrom.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JButton bBrowseFrom = new JButton();
        JButton bBrowseTo = new JButton();
        jLabel3.setLabelFor(this.tfFrom);
        jLabel4.setLabelFor(this.tfTo);
        this.tfFrom.setColumns(20);
        this.tfTo.setColumns(20);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/subversion/remote/ui/history/Bundle");
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)bundle.getString("CTL_UseFrom"));
        jLabel3.setToolTipText(bundle.getString("TT_From"));
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)bundle.getString("CTL_UseTo"));
        jLabel4.setToolTipText(bundle.getString("TT_To"));
        Mnemonics.setLocalizedText((JLabel)jLabel5, (String)bundle.getString("CTL_FromToHint"));
        Mnemonics.setLocalizedText((JLabel)jLabel6, (String)bundle.getString("CTL_FromToHint"));
        Mnemonics.setLocalizedText((AbstractButton)bBrowseFrom, (String)bundle.getString("CTL_BrowseFrom"));
        bBrowseFrom.setToolTipText(bundle.getString("TT_BrowseFrom"));
        Mnemonics.setLocalizedText((AbstractButton)bBrowseTo, (String)bundle.getString("CTL_BrowseTo"));
        bBrowseTo.setToolTipText(bundle.getString("TT_BrowseTo"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3).addComponent(jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tfFrom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.tfTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel6))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(bBrowseFrom).addComponent(bBrowseTo)).addGap(11));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.tfFrom).addComponent(jLabel5).addComponent(bBrowseFrom)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.tfTo).addComponent(jLabel6).addComponent(bBrowseTo)));
        bBrowseFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchCriteriaPanel.this.onFromBrowse(evt);
            }
        });
        bBrowseTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchCriteriaPanel.this.onToBrowse(evt);
            }
        });
    }

    private void onToBrowse(ActionEvent evt) {
        this.onBrowse(this.tfTo);
    }

    private void onFromBrowse(ActionEvent evt) {
        this.onBrowse(this.tfFrom);
    }

    private void onBrowse(final JTextField destination) {
        SVNUrl repositoryUrl;
        try {
            SVNUrl sVNUrl = repositoryUrl = this.url != null ? this.url : ContextAction.getSvnUrl(new Context(this.roots[0]));
            if (repositoryUrl == null) {
                SvnClientExceptionHandler.notifyNullUrl(new Context(this.roots[0]));
                return;
            }
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(new Context(this.roots), ex, true, true);
            return;
        }
        String title = destination == this.tfFrom ? NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_BrowseTag_StartTag") : NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_BrowseTag_EndTag");
        RepositoryFile repoFile = new RepositoryFile(VCSFileProxySupport.getFileSystem((VCSFileProxy)this.roots[0]), repositoryUrl, SVNRevision.HEAD);
        int browserMode = this.roots[0].isFile() ? 11 : 1;
        Browser browser = new Browser(VCSFileProxySupport.getFileSystem((VCSFileProxy)this.roots[0]), title, browserMode, repoFile, null, null, "org.netbeans.modules.subversion.ui.browser.searchhistory");
        final RepositoryFile[] repositoryFiles = browser.getRepositoryFiles();
        if (repositoryFiles == null || repositoryFiles.length == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                destination.setText(repositoryFiles[0].getRevision().toString());
            }
        });
    }
}

