/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.codegenoptions.DebugInfoKind;
import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.Clang;
import org.clang.driver.tools.impl.MipsStatics;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.Reloc;
import org.llvm.support.llvm;
import org.llvm.target.target.DebuggerKind;

public class ClangAs
extends Tool
implements Destructors.ClassWithDestructor {
    public ClangAs(ToolChain TC) {
        super(NativePointer.$((String)"clang::as"), NativePointer.$((String)"clang integrated assembler"), TC, Tool.ResponseFileSupport.RF_Full);
    }

    public void AddMIPSTargetArgs(ArgList Args, ArgStringList CmdArgs) {
        StringRef CPUName = new StringRef();
        StringRef ABIName = new StringRef();
        Triple Triple2 = this.getToolChain().getTriple();
        MipsStatics.getMipsCPUAndABI(Args, Triple2, CPUName, ABIName);
        CmdArgs.push_back((Object)NativePointer.$((String)"-target-abi"));
        CmdArgs.push_back((Object)ABIName.data());
    }

    @Override
    public boolean hasGoodDiagnostics() {
        return true;
    }

    @Override
    public boolean hasIntegratedAssembler() {
        return false;
    }

    @Override
    public boolean hasIntegratedCPP() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ArgStringList CmdArgs = new ArgStringList();
            assert (Inputs.size() == 1) : "Unexpected number of inputs.";
            InputInfo Input = (InputInfo)Inputs.$at(0);
            std.string TripleStr = this.getToolChain().ComputeEffectiveClangTriple(Args, Input.getType());
            Triple _Triple = new Triple(new Twine(TripleStr));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
            ToolsStatics.claimNoWarnArgs(Args);
            CmdArgs.push_back((Object)NativePointer.$((String)"-cc1as"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-triple"));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TripleStr)));
            CmdArgs.push_back((Object)NativePointer.$((String)"-filetype"));
            CmdArgs.push_back((Object)NativePointer.$((String)"obj"));
            CmdArgs.push_back((Object)NativePointer.$((String)"-main-file-name"));
            CmdArgs.push_back((Object)Clang.getBaseInputName(Args, Input));
            std.string CPU = ToolsStatics.getCPUName(Args, _Triple, true);
            if (!CPU.empty()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-target-cpu"));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(CPU)));
            }
            ToolsStatics.getTargetFeatures(this.getToolChain(), _Triple, Args, CmdArgs, true);
            Args.hasArg(new OptSpecifier(options.ID.OPT_force__cpusubtype__ALL.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_I_Group.getValue()));
            Action SourceAction = JA;
            while (SourceAction.getKind() != Action.ActionClass.InputClass) {
                assert (!SourceAction.getInputs().empty()) : "unexpected root action!";
                SourceAction = (Action)SourceAction.getInputs().$at(0);
            }
            boolean WantDebug = false;
            int DwarfVersion = 0;
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
            Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
            if (A != null) {
                boolean bl = WantDebug = !A.getOption().matches(new OptSpecifier(options.ID.OPT_g0.getValue())) && !A.getOption().matches(new OptSpecifier(options.ID.OPT_ggdb0.getValue()));
                if (WantDebug) {
                    DwarfVersion = ToolsStatics.DwarfVersionNum(A.getSpelling());
                }
            }
            if (DwarfVersion == 0) {
                DwarfVersion = this.getToolChain().GetDefaultDwarfVersion();
            }
            DebugInfoKind _DebugInfoKind = DebugInfoKind.NoDebugInfo;
            if (SourceAction.getType() == types.ID.TY_Asm || SourceAction.getType() == types.ID.TY_PP_Asm) {
                _DebugInfoKind = WantDebug ? DebugInfoKind.LimitedDebugInfo : DebugInfoKind.NoDebugInfo;
                ToolsStatics.addDebugCompDirArg(Args, CmdArgs);
                CmdArgs.push_back((Object)NativePointer.$((String)"-dwarf-debug-producer"));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(BasicClangGlobals.getClangFullVersion())));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_I.getValue()));
            }
            ToolsStatics.RenderDebugEnablingArgs(Args, CmdArgs, _DebugInfoKind, DwarfVersion, DebuggerKind.Default);
            std.tuple $ParsePICArgs = ToolsStatics.ParsePICArgs(this.getToolChain(), _Triple, Args);
            Reloc.Model RelocationModel = (Reloc.Model)$ParsePICArgs.$getAt(0);
            int PICLevel = (Integer)$ParsePICArgs.$getAt(1);
            boolean IsPIE = (Boolean)$ParsePICArgs.$getAt(2);
            char.ptr RMName = Native.$tryClone((char.ptr)ToolsStatics.RelocationModelName(RelocationModel));
            if (RMName != null) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-mrelocation-model"));
                CmdArgs.push_back((Object)RMName);
            }
            if (this.getToolChain().UseDwarfDebugFlags()) {
                ArgStringList OriginalArgs = new ArgStringList();
                for (Arg Arg2 : Args) {
                    Arg2.render(Args, OriginalArgs);
                }
                SmallString Flags = new SmallString(256);
                char.ptr Exec = Native.$tryClone((char.ptr)this.getToolChain().getDriver().getClangProgramPath());
                Flags.$addassign(Exec);
                for (char.ptr OriginalArg : OriginalArgs) {
                    SmallString EscapedArg = new SmallString(128);
                    ToolsStatics.EscapeSpacesAndBackslashes(OriginalArg, EscapedArg);
                    Flags.$addassign(" ");
                    Flags.$addassign(EscapedArg.$StringRef());
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-dwarf-debug-flags"));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Flags)));
            }
            switch (this.getToolChain().getArch()) {
                default: {
                    break;
                }
                case mips: 
                case mipsel: 
                case mips64: 
                case mips64el: {
                    this.AddMIPSTargetArgs(Args, CmdArgs);
                }
            }
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_W_Group.getValue()));
            ToolsStatics.CollectArgsForIntegratedAssembler(C, Args, CmdArgs, this.getToolChain().getDriver());
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_mllvm.getValue()));
            assert (Output.isFilename()) : "Unexpected lipo output.";
            CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
            CmdArgs.push_back((Object)Output.getFilename());
            assert (Input.isFilename()) : "Invalid input.";
            CmdArgs.push_back((Object)Input.getFilename());
            char.ptr Exec = Native.$tryClone((char.ptr)this.getToolChain().getDriver().getClangProgramPath());
            C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
            $c$.clean();
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_gsplit_dwarf.getValue())) && this.getToolChain().getTriple().isOSLinux()) {
                ToolsStatics.SplitDebugInfo(this.getToolChain(), C, this, JA, Args, Output, ToolsStatics.SplitDebugName(Args, Input));
            }
        }
        finally {
            $c$.$destroy();
        }
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

