/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Annotator;
import org.netbeans.modules.git.remote.FileStatusCache;
import org.netbeans.modules.git.remote.FilesystemInterceptor;
import org.netbeans.modules.git.remote.GitVCS;
import org.netbeans.modules.git.remote.HistoryProvider;
import org.netbeans.modules.git.remote.ModuleLifecycleManager;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRepository;
import org.netbeans.modules.git.remote.client.CredentialsCallback;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.RootsToFile;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class Git {
    private static Git instance;
    private Annotator annotator;
    private FilesystemInterceptor interceptor;
    public static final Logger LOG;
    public static final Logger STATUS_LOG;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private FileStatusCache fileStatusCache;
    private HashMap<VCSFileProxy, RequestProcessor> processorsToUrl;
    public static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    private RootsToFile rootsToFile;
    private GitVCS gitVCS;
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private HistoryProvider historyProvider;
    private static final List<String> allowableFolders;
    private final Set<VCSFileProxy> knownRoots = Collections.synchronizedSet(new HashSet());
    private final Set<VCSFileProxy> unversionedParents = Collections.synchronizedSet(new HashSet(20));

    private Git() {
    }

    public static synchronized Git getInstance() {
        if (instance == null) {
            instance = new Git();
            instance.init();
        }
        return instance;
    }

    static synchronized void shutDown() {
        if (instance != null) {
            Git.instance.interceptor.shutdownMonitor.cancel();
            instance = null;
        }
    }

    static void waitEmptyRefreshQueue() {
        Git.instance.interceptor.waitEmptyRefreshQueue();
    }

    private void init() {
        int statisticsFrequency;
        this.fileStatusCache = new FileStatusCache();
        this.annotator = new Annotator();
        this.interceptor = new FilesystemInterceptor();
        String s = System.getProperty("git.root.stat.frequency", "0");
        try {
            statisticsFrequency = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            statisticsFrequency = 0;
        }
        this.rootsToFile = new RootsToFile(new RootsToFile.Callback(){

            public boolean repositoryExistsFor(VCSFileProxy file) {
                return GitUtils.repositoryExistsFor(file);
            }

            public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
                return Git.this.getTopmostManagedAncestor(file);
            }
        }, Logger.getLogger("org.netbeans.modules.git.remote.RootsToFile"), statisticsFrequency);
        ModuleLifecycleManager.getInstance().disableOtherModules();
    }

    void registerGitVCS(GitVCS gitVCS) {
        this.gitVCS = gitVCS;
        this.fileStatusCache.addPropertyChangeListener(gitVCS);
        this.addPropertyChangeListener(gitVCS);
    }

    public Annotator getVCSAnnotator() {
        return this.annotator;
    }

    FilesystemInterceptor getVCSInterceptor() {
        return this.interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        VCSFileProxy repository = this.getRepositoryRoot(workingCopy);
        if (repository != null) {
            GitClient client = null;
            try {
                boolean ok;
                client = this.getClient(repository);
                try (OutputStream fos = VCSFileProxySupport.getOutputStream((VCSFileProxy)originalFile);){
                    ok = client.catFile(workingCopy, "HEAD", fos, GitUtils.NULL_PROGRESS_MONITOR);
                }
                if (!ok) {
                    VCSFileProxySupport.delete((VCSFileProxy)originalFile);
                }
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.SEVERE, "Parent folder [{0}] does not exist", originalFile.getParentFile());
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (GitException.MissingObjectException ex) {
                LOG.log(Level.FINE, null, ex);
                VCSFileProxySupport.delete((VCSFileProxy)originalFile);
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, "Error retrieving file", ex);
                VCSFileProxySupport.delete((VCSFileProxy)originalFile);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "IO exception", ex);
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public boolean isManaged(VCSFileProxy file) {
        return VersioningSupport.getOwner((VCSFileProxy)file) instanceof GitVCS && !GitUtils.isPartOfGitMetadata(file);
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public VCSFileProxy getRepositoryRoot(VCSFileProxy file) {
        return this.rootsToFile.getRepositoryRoot(file);
    }

    public GitClient getClient(VCSFileProxy repository) throws GitException {
        return this.getClient(repository, null);
    }

    public GitClient getClient(VCSFileProxy repository, GitProgressSupport progressSupport) throws GitException {
        return this.getClient(repository, progressSupport, true);
    }

    public GitClient getClient(VCSFileProxy repository, GitProgressSupport progressSupport, boolean handleAuthenticationIssues) throws GitException {
        GitClient client = new GitClient(this.singleInstanceRepositoryRoot(repository), progressSupport, handleAuthenticationIssues);
        client.setCallback(new CredentialsCallback());
        return client;
    }

    public GitRepository getRepository(VCSFileProxy repository) throws GitException {
        return GitRepository.getInstance((VCSFileProxy)this.singleInstanceRepositoryRoot(repository));
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor(null);
    }

    public RequestProcessor getRequestProcessor(VCSFileProxy repositoryRoot) {
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(repositoryRoot)) == null) {
            if (repositoryRoot == null) {
                String rpName = "GitRemote - ANY_KEY";
                rp = new RequestProcessor(rpName, 50, true);
            } else {
                String rpName = "GitRemote - " + repositoryRoot.toString();
                rp = new RequestProcessor(rpName, 1, true);
            }
            this.processorsToUrl.put(repositoryRoot, rp);
        }
        return rp;
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void headChanged(Set<VCSFileProxy> files) {
        assert (this.gitVCS != null);
        this.gitVCS.refreshStatus(files);
    }

    public void versionedFilesChanged() {
        this.rootsToFile.clear();
        this.clearAncestorCaches();
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public <T> T runWithoutExternalEvents(VCSFileProxy repository, String commandName, Callable<T> callable) throws Exception {
        return this.getVCSInterceptor().runWithoutExternalEvents(repository, commandName, callable);
    }

    public Set<VCSFileProxy> getSeenRoots(VCSFileProxy repositoryRoot) {
        return this.getVCSInterceptor().getSeenRoots(repositoryRoot);
    }

    public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
        String homeDir;
        VCSFileProxy parent;
        if (file.toFile() != null && !"true".equals(System.getProperty("org.netbeans.modules.git.remote.localfilesystem.enable", "false"))) {
            return null;
        }
        if (!this.isAllowable(file)) {
            return null;
        }
        long t = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        }
        if (!VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)file))) {
            return null;
        }
        if (this.unversionedParents.contains(file)) {
            LOG.fine(" cached as unversioned");
            return null;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getTopmostManagedParent {0}", new Object[]{file});
        }
        if ((parent = this.getKnownParent(file)) != null) {
            LOG.log(Level.FINE, "  getTopmostManagedParent returning known parent {0}", parent);
            return parent;
        }
        if (GitUtils.isPartOfGitMetadata(file)) {
            while (file != null) {
                if (GitUtils.isAdministrative(file)) {
                    file = file.getParentFile();
                    this.unversionedParents.remove(file);
                    break;
                }
                file = file.getParentFile();
            }
        }
        HashSet<VCSFileProxy> done = new HashSet<VCSFileProxy>();
        VCSFileProxy topmost = null;
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (VersioningSupport.isExcluded((VCSFileProxy)file)) break;
            boolean forbiddenFolder = Utils.isForbiddenFolder((String)file.getPath());
            if (!forbiddenFolder && GitUtils.repositoryExistsFor(file)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                }
                done.clear();
                topmost = file;
                if (topmost.getParentFile() == null) {
                    LOG.log(Level.WARNING, "found managed root folder {0}", file);
                }
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                }
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(done);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getTopmostManagedParent returns {0} after {1} millis", new Object[]{topmost, System.currentTimeMillis() - t});
        }
        if (topmost != null && this.knownRoots.add(topmost) && (homeDir = System.getProperty("user.home")) != null && homeDir.startsWith(topmost.getPath())) {
            LOG.log(Level.WARNING, "Home folder {0} lies under a git versioned root {1}. Expecting lots of performance issues.", new Object[]{homeDir, topmost});
        }
        return topmost;
    }

    private VCSFileProxy singleInstanceRepositoryRoot(VCSFileProxy repository) {
        VCSFileProxy repositoryFolder = this.getRepositoryRoot(repository);
        if (repositoryFolder != null && repository.equals((Object)repositoryFolder)) {
            repository = repositoryFolder;
        }
        return repository;
    }

    private VCSFileProxy getKnownParent(VCSFileProxy file) {
        VCSFileProxy[] roots = this.knownRoots.toArray(new VCSFileProxy[this.knownRoots.size()]);
        VCSFileProxy knownParent = null;
        for (VCSFileProxy r : roots) {
            if (VersioningSupport.isExcluded((VCSFileProxy)file) || !VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)r, (VCSFileProxy)file) || knownParent != null && !VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)knownParent, (VCSFileProxy)r)) continue;
            knownParent = r;
        }
        return knownParent;
    }

    public void clearAncestorCaches() {
        this.unversionedParents.clear();
        this.knownRoots.clear();
        this.rootsToFile.clear();
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.emptyList();
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    public Collection<VCSFileProxy> getCreatedFolders() {
        return this.getVCSInterceptor().getCreatedFolders();
    }

    public HistoryProvider getHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new HistoryProvider();
        }
        return this.historyProvider;
    }

    private boolean isAllowable(VCSFileProxy file) {
        String path = file.getPath() + "/";
        for (String s : allowableFolders) {
            if (!(s.endsWith("/") ? path.startsWith(s) : path.startsWith(s + "/"))) continue;
            return true;
        }
        return false;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.git.remote");
        STATUS_LOG = Logger.getLogger("org.netbeans.modules.git.remote.status");
        ArrayList<String> files = new ArrayList<String>();
        try {
            String allowable = System.getProperty("versioning.git.allowableFolders", "/");
            files.addAll(Arrays.asList(allowable.split("\\;")));
            files.remove("");
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
        allowableFolders = files;
    }
}

