/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.git.remote.Bundle;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.HistoryRegistry;
import org.netbeans.modules.git.remote.VersionsCache;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitUser;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.remote.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.history.HistoryActionVCSProxyBased;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class HistoryProvider
implements VCSHistoryProvider {
    private final List<VCSHistoryProvider.HistoryChangeListener> listeners = new LinkedList<VCSHistoryProvider.HistoryChangeListener>();
    private static final Logger LOG = Logger.getLogger(HistoryProvider.class.getName());
    private Action[] actions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public synchronized VCSHistoryProvider.HistoryEntry[] getHistory(VCSFileProxy[] files, Date fromDate) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Set<VCSFileProxy> repositories = HistoryProvider.getRepositoryRoots(files);
        if (repositories == null) {
            return null;
        }
        LinkedList<VCSHistoryProvider.HistoryEntry> ret = new LinkedList<VCSHistoryProvider.HistoryEntry>();
        HashMap<String, HashSet<VCSFileProxy>> rev2FileMap = new HashMap<String, HashSet<VCSFileProxy>>();
        LinkedHashMap<String, GitRevisionInfo> rev2LMMap = new LinkedHashMap<String, GitRevisionInfo>();
        VCSFileProxy repositoryRoot = repositories.iterator().next();
        for (VCSFileProxy file : files) {
            FileInformation info = Git.getInstance().getFileStatusCache().getStatus(file);
            if (!info.containsStatus(FileInformation.STATUS_MANAGED)) continue;
            try {
                GitRevisionInfo[] history;
                for (GitRevisionInfo h : history = HistoryRegistry.getInstance().getLogs(repositoryRoot, files, fromDate, null, GitUtils.NULL_PROGRESS_MONITOR)) {
                    String r = h.getRevision();
                    rev2LMMap.put(r, h);
                    HashSet<VCSFileProxy> s = (HashSet<VCSFileProxy>)rev2FileMap.get(r);
                    if (s == null) {
                        s = new HashSet<VCSFileProxy>();
                        rev2FileMap.put(r, s);
                    }
                    s.add(file);
                }
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        for (GitRevisionInfo h : rev2LMMap.values()) {
            Set s = (Set)rev2FileMap.get(h.getRevision());
            VCSFileProxy[] involvedFiles = s.toArray(new VCSFileProxy[s.size()]);
            VCSHistoryProvider.HistoryEntry e = this.createHistoryEntry(h, involvedFiles, repositoryRoot);
            ret.add(e);
        }
        return ret.toArray(new VCSHistoryProvider.HistoryEntry[ret.size()]);
    }

    @SuppressWarnings(value={"RCN"})
    private VCSHistoryProvider.HistoryEntry createHistoryEntry(GitRevisionInfo h, VCSFileProxy[] involvedFiles, VCSFileProxy repositoryRoot) {
        GitUser user = h.getAuthor();
        if (user == null) {
            user = h.getCommitter();
        }
        String username = user.getName();
        String author = user.toString();
        String message = h.getFullMessage();
        assert (message != null);
        VCSHistoryProvider.HistoryEntry e = new VCSHistoryProvider.HistoryEntry(involvedFiles, new Date(h.getCommitTime()), message == null ? "" : message, author, username, h.getRevision(), h.getRevision().length() > 7 ? h.getRevision().substring(0, 7) : h.getRevision(), this.getActions(), (VCSHistoryProvider.RevisionProvider)new RevisionProviderImpl(h.getRevision()), null, (VCSHistoryProvider.ParentProvider)new ParentProviderImpl(h, involvedFiles, repositoryRoot));
        return e;
    }

    public Action createShowHistoryAction(VCSFileProxy[] files) {
        return new OpenHistoryAction(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHistoryChange(final VCSFileProxy[] files) {
        VCSHistoryProvider.HistoryChangeListener[] la;
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            la = this.listeners.toArray(new VCSHistoryProvider.HistoryChangeListener[this.listeners.size()]);
        }
        Git.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (VCSHistoryProvider.HistoryChangeListener l : la) {
                    l.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)HistoryProvider.this, files));
                }
            }
        });
    }

    private synchronized Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new HistoryActionVCSProxyBased(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_View")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
                    HistoryProvider.this.view(entry.getRevision(), false, files);
                }

                public HelpCtx getHelpCtx() {
                    return null;
                }
            }, new HistoryActionVCSProxyBased(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_ShowAnnotations")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
                    HistoryProvider.this.view(entry.getRevision(), true, files);
                }

                public HelpCtx getHelpCtx() {
                    return null;
                }
            }, new HistoryActionVCSProxyBased(){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<VCSFileProxy> files) {
                    VCSFileProxy root = Git.getInstance().getRepositoryRoot(files.iterator().next());
                    ((RevertChangesAction)SystemAction.get(RevertChangesAction.class)).revertFiles(root, files.toArray(new VCSFileProxy[files.size()]), this.getRevisionShort(), Bundle.HistoryProvider_action_RevertTo_progress());
                }

                protected boolean isMultipleHistory() {
                    return false;
                }

                public String getName() {
                    String rev = this.getRevisionShort();
                    if (rev == null) {
                        rev = "";
                    }
                    return Bundle.HistoryProvider_action_RevertTo(rev);
                }

                public boolean isEnabled() {
                    return null != this.getRevisionShort();
                }

                public HelpCtx getHelpCtx() {
                    return null;
                }
            }};
        }
        return this.actions;
    }

    private void view(final String revision, final boolean showAnnotations, final Set<VCSFileProxy> files) {
        final VCSFileProxy root = Git.getInstance().getRepositoryRoot(files.iterator().next());
        new GitProgressSupport(){

            @Override
            protected void perform() {
                for (VCSFileProxy f : files) {
                    VCSFileProxy original = HistoryRegistry.getInstance().getHistoryFile(root, f, revision, true);
                    if (original != null) {
                        f = original;
                    }
                    try {
                        GitUtils.openInRevision(f, -1, revision, showAnnotations, this.getProgressMonitor());
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        }.start(Git.getInstance().getRequestProcessor(), root, NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
    }

    private static Set<VCSFileProxy> getRepositoryRoots(VCSFileProxy ... files) {
        Set<VCSFileProxy> repositories = GitUtils.getRepositoryRoots(new HashSet<VCSFileProxy>(Arrays.asList(files)));
        if (repositories.size() != 1) {
            LOG.log(Level.WARNING, "History requested for {0} repositories", repositories.size());
            return null;
        }
        return repositories;
    }

    private class ParentProviderImpl
    implements VCSHistoryProvider.ParentProvider {
        private final GitRevisionInfo info;
        private final VCSFileProxy[] files;
        private final VCSFileProxy repository;
        private final Map<VCSFileProxy, VCSHistoryProvider.HistoryEntry> commonAncestors;

        public ParentProviderImpl(GitRevisionInfo info, VCSFileProxy[] files, VCSFileProxy repository) {
            this.info = info;
            this.files = files;
            this.repository = repository;
            this.commonAncestors = new HashMap<VCSFileProxy, VCSHistoryProvider.HistoryEntry>(files.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VCSHistoryProvider.HistoryEntry getParentEntry(VCSFileProxy file) {
            VCSHistoryProvider.HistoryEntry ancestorEntry = this.commonAncestors.get(file);
            if (ancestorEntry == null && !this.commonAncestors.containsKey(file)) {
                GitRevisionInfo parent = null;
                GitClient client = null;
                try {
                    client = Git.getInstance().getClient(this.repository);
                    if (this.info.getParents().length == 1) {
                        VCSFileProxy historyFile;
                        VCSFileProxy vCSFileProxy = historyFile = this.info.getModifiedFiles().containsKey(file) ? file : HistoryRegistry.getInstance().getHistoryFile(this.repository, file, this.info.getRevision(), false);
                        if (historyFile != null) {
                            parent = client.getPreviousRevision(historyFile, this.info.getRevision(), GitUtils.NULL_PROGRESS_MONITOR);
                        }
                    } else if (this.info.getParents().length > 1) {
                        parent = client.getCommonAncestor(this.info.getParents(), GitUtils.NULL_PROGRESS_MONITOR);
                    }
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                ancestorEntry = parent == null ? null : HistoryProvider.this.createHistoryEntry(parent, this.files, this.repository);
                this.commonAncestors.put(file, ancestorEntry);
            }
            return ancestorEntry;
        }
    }

    private static class OpenHistoryAction
    extends AbstractAction {
        private final VCSFileProxy[] files;

        public OpenHistoryAction(VCSFileProxy[] files) {
            this.files = files;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openHistory(this.files);
        }

        private void openHistory(VCSFileProxy[] files) {
            if (files == null || files.length == 0) {
                return;
            }
            Set repositories = HistoryProvider.getRepositoryRoots(files);
            if (repositories == null || repositories.isEmpty()) {
                return;
            }
            ArrayList<1> nodes = new ArrayList<1>(files.length);
            for (VCSFileProxy f : files) {
                nodes.add(new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{f})){

                    public String getDisplayName() {
                        return ((VCSFileProxy)this.getLookup().lookup(VCSFileProxy.class)).getName();
                    }
                });
            }
            SearchHistoryAction.openSearch((VCSFileProxy)repositories.iterator().next(), files, VCSFileProxySupport.getContextDisplayName((VCSContext)VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()]))));
        }
    }

    private static class RevisionProviderImpl
    implements VCSHistoryProvider.RevisionProvider {
        private final String revision;

        public RevisionProviderImpl(String revision) {
            this.revision = revision;
        }

        public void getRevisionFile(VCSFileProxy originalFile, VCSFileProxy revisionFile) {
            assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
            try {
                VCSFileProxy file;
                Set repositories;
                FileInformation info = Git.getInstance().getFileStatusCache().getStatus(originalFile);
                if (info.containsStatus(FileInformation.Status.NEW_HEAD_INDEX) && info.getOldFile() != null) {
                    originalFile = info.getOldFile();
                }
                if ((repositories = HistoryProvider.getRepositoryRoots(new VCSFileProxy[]{originalFile})) == null || repositories.isEmpty()) {
                    LOG.log(Level.WARNING, "Repository root not found for file {0}", originalFile);
                    return;
                }
                VCSFileProxy repository = (VCSFileProxy)repositories.iterator().next();
                VCSFileProxy historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.revision, true);
                if (historyFile != null) {
                    originalFile = historyFile;
                }
                if ((file = VersionsCache.getInstance().getFileRevision(originalFile, this.revision, GitUtils.NULL_PROGRESS_MONITOR)) != null) {
                    VCSFileProxySupport.copyFile((VCSFileProxy)file, (VCSFileProxy)revisionFile);
                } else if (historyFile == null) {
                    LOG.log(Level.WARNING, "File {0} not found in revision {1}. Will make a guess ...", new Object[]{originalFile, this.revision});
                    historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.revision, false);
                    if (historyFile != null && (file = VersionsCache.getInstance().getFileRevision(historyFile, this.revision, GitUtils.NULL_PROGRESS_MONITOR)) != null) {
                        VCSFileProxySupport.copyFile((VCSFileProxy)file, (VCSFileProxy)revisionFile);
                    }
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
    }
}

