/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.actions;

import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.NbBundle;

public class AddAction
extends SingleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/add.png";

    public AddAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(VCSFileProxy repository, final VCSFileProxy[] roots, VCSContext context) {
        GitProgressSupport supp = new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                VCSFileProxy[] actionRoots = GitUtils.listFiles(roots, FileInformation.STATUS_LOCAL_CHANGES);
                if (actionRoots.length == 0) {
                    return;
                }
                try {
                    GitClient client = this.getClient();
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(actionRoots));
                    client.add(actionRoots, this.getProgressMonitor());
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(actionRoots);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(AddAction.class, (String)"LBL_AddProgress"));
    }
}

