/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.conflicts;

import java.util.EnumSet;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.remote.ui.conflicts.ResolveConflictsExecutor;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ResolveConflictsAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/conflict-resolve.png";

    public ResolveConflictsAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        VCSContext context = this.getCurrentContext(activatedNodes);
        return Git.getInstance().getFileStatusCache().containsFiles(context, EnumSet.of(FileInformation.Status.IN_CONFLICT), false);
    }

    @Override
    protected RequestProcessor.Task performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        VCSFileProxy[] files = Git.getInstance().getFileStatusCache().listFiles(roots, EnumSet.of(FileInformation.Status.IN_CONFLICT));
        if (files.length > 0) {
            ResolveConflictsExecutor supp = new ResolveConflictsExecutor(files);
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_PreparingMerge"));
            return supp.getTask();
        }
        return null;
    }
}

