/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.status;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.GitStatusNode;
import org.netbeans.modules.git.remote.ui.commit.DeleteLocalAction;
import org.netbeans.modules.git.remote.ui.diff.DiffAction;
import org.netbeans.modules.git.remote.ui.status.VersioningPanelController;
import org.netbeans.modules.remotefs.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.remotefs.versioning.util.status.VCSStatusTable;
import org.netbeans.modules.remotefs.versioning.util.status.VCSStatusTableModel;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

class GitStatusTable
extends VCSStatusTable<VersioningPanelController.GitStatusNodeImpl> {
    private final VersioningPanelController.ModeKeeper modeKeeper;
    private final VersioningPanelController master;

    public GitStatusTable(VersioningPanelController master, VCSStatusTableModel<VersioningPanelController.GitStatusNodeImpl> model, VersioningPanelController.ModeKeeper modeKeeper) {
        super(model);
        this.master = master;
        this.modeKeeper = modeKeeper;
        this.setDefaultRenderer(new SyncTableCellRenderer());
    }

    protected void setModelProperties() {
        Node.Property[] properties = new Node.Property[]{new VCSStatusTable.ColumnDescriptor("name", String.class, VCSStatusNode.NameProperty.DISPLAY_NAME, VCSStatusNode.NameProperty.DESCRIPTION), new VCSStatusTable.ColumnDescriptor("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new VCSStatusTable.ColumnDescriptor("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.tableModel.setProperties(properties);
        this.getTable().getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "DeleteAction");
        this.getTable().getActionMap().put("DeleteAction", (Action)SystemAction.get(DeleteLocalAction.class));
    }

    protected JPopupMenu getPopup() {
        return this.master.getPopupFor((Node[])this.getSelectedNodes());
    }

    protected void mouseClicked(VCSStatusNode node) {
        Action action = node.getNodeAction();
        if (action != null && action.isEnabled()) {
            if (action instanceof DiffAction) {
                this.modeKeeper.storeMode();
            }
            action.actionPerformed(new ActionEvent((Object)this, 1001, node.getFile().getPath()));
        }
    }

    public Object prepareModel(VersioningPanelController.GitStatusNodeImpl[] nodes) {
        return null;
    }

    public void setModel(VersioningPanelController.GitStatusNodeImpl[] nodes, EditorCookie[] editorCookies, Object modelData) {
        super.setNodes((VCSStatusNode[])nodes);
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private final FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            GitStatusNode node = null;
            if (modelColumnIndex == 0) {
                node = (GitStatusNode)GitStatusTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                if (!isSelected) {
                    value = node.getHtmlDisplayName();
                }
                if (GitModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getPath())) {
                    value = "<s>" + value + "</s>";
                }
                value = "<html>" + value;
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                if (node == null) {
                    node = (GitStatusNode)GitStatusTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                }
                String path = node.getFile().getPath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }
}

