/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.streaming.PrefixFactory;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterBase;
import com.sun.xml.rpc.streaming.XmlTreeWriterException;
import com.sun.xml.rpc.util.xml.CDATA;
import java.util.Stack;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlTreeWriter
extends XMLWriterBase
implements XMLWriter {
    protected Document document;
    protected SOAPElement currentNode;
    protected SOAPElement parentNode;
    protected PrefixFactory pfactory;
    protected NamespaceSupport ns = new NamespaceSupport();
    protected Stack elementStack = new Stack();
    private static SOAPFactory soapFactory;

    public XmlTreeWriter(Document document) {
        this.document = document;
    }

    protected static SOAPFactory getSoapFactory() throws SOAPException {
        if (soapFactory == null) {
            soapFactory = SOAPFactory.newInstance();
        }
        return soapFactory;
    }

    public void startElement(String localName, String uri) {
        try {
            this.ns.pushContext();
            boolean mustDeclarePrefix = false;
            String aPrefix = null;
            if (!uri.equals("") && (aPrefix = this.getKnownPrefix(uri)) == null) {
                mustDeclarePrefix = true;
                aPrefix = this.createPrefix(uri);
            }
            this.addNewNode(localName, aPrefix, uri);
            if (mustDeclarePrefix) {
                this.writeNamespaceDeclaration(aPrefix, uri);
            }
            this.elementStack.push(this.currentNode.getElementName().getLocalName());
        }
        catch (Exception e) {
            throw new XmlTreeWriterException(e.getMessage());
        }
    }

    protected String createPrefix(String uri) {
        String aPrefix = null;
        if (this.pfactory != null) {
            aPrefix = this.pfactory.getPrefix(uri);
        }
        if (aPrefix == null) {
            throw new XmlTreeWriterException("xmlwriter.noPrefixForURI " + uri);
        }
        return aPrefix;
    }

    protected String getKnownPrefix(String uri) {
        String defaultNamespaceURI = this.ns.getPrefix("");
        String aPrefix = defaultNamespaceURI != null && uri.equals(defaultNamespaceURI) ? "" : this.ns.getPrefix(uri);
        return aPrefix;
    }

    protected SOAPElement addNewNode(String localName, String prefix, String uri) throws SOAPException {
        if (this.currentNode != null) {
            this.parentNode = this.currentNode;
            this.currentNode = this.parentNode.addChildElement(localName, prefix, uri);
        } else {
            this.currentNode = XmlTreeWriter.getSoapFactory().createElement(localName, prefix, uri);
            this.currentNode = (SOAPElement)this.document.importNode((Node)this.currentNode, true);
            this.document.insertBefore((Node)this.currentNode, null);
        }
        return this.currentNode;
    }

    public void startElement(String localName, String uri, String prefix) {
        try {
            this.ns.pushContext();
            if (!uri.equals("")) {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                String defaultNamespaceURI = this.ns.getPrefix("");
                if (defaultNamespaceURI != null && uri.equals(defaultNamespaceURI)) {
                    aPrefix = "";
                }
                if ((aPrefix = this.ns.getPrefix(uri)) == null) {
                    mustDeclarePrefix = true;
                    aPrefix = prefix;
                    if (aPrefix == null) {
                        throw new XmlTreeWriterException("xmlwriter.noPrefixForURI");
                    }
                }
                this.addNewNode(localName, aPrefix, uri);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            } else {
                this.addNewNode(localName, prefix, uri);
            }
            this.elementStack.push(this.currentNode.getElementName().getLocalName());
        }
        catch (SOAPException se) {
            throw new XmlTreeWriterException(se.getMessage());
        }
    }

    public void writeAttribute(String localName, String uri, String value) {
        this.writeAttributeUnquoted(localName, uri, value);
    }

    protected String quote(String value) {
        int i;
        boolean didReplacement = false;
        StringBuffer replacementString = null;
        block12: for (i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\"': {
                    replacementString = new StringBuffer(value.length() + 20);
                    replacementString.append(value.substring(0, i));
                    replacementString.append("&quot;");
                    didReplacement = true;
                    break block12;
                }
                case '&': {
                    replacementString = new StringBuffer(value.length() + 20);
                    replacementString.append(value.substring(0, i));
                    replacementString.append("&amp;");
                    didReplacement = true;
                    break block12;
                }
                case '<': {
                    replacementString = new StringBuffer(value.length() + 20);
                    replacementString.append(value.substring(0, i));
                    replacementString.append("&lt;");
                    didReplacement = true;
                    break block12;
                }
                case '>': {
                    replacementString = new StringBuffer(value.length() + 20);
                    replacementString.append(value.substring(0, i));
                    replacementString.append("&gt;");
                    didReplacement = true;
                    break block12;
                }
                default: {
                    continue block12;
                }
            }
        }
        if (!didReplacement) {
            return value;
        }
        ++i;
        while (i < value.length()) {
            char nextCharacter = value.charAt(i);
            switch (nextCharacter) {
                case '\"': {
                    replacementString.append("&quot;");
                    break;
                }
                case '&': {
                    replacementString.append("&amp;");
                    break;
                }
                case '<': {
                    replacementString.append("&lt;");
                    break;
                }
                case '>': {
                    replacementString.append("&gt;");
                    break;
                }
                default: {
                    replacementString.append(nextCharacter);
                }
            }
            ++i;
        }
        return replacementString.toString();
    }

    public void writeAttributeUnquoted(String localName, String uri, String value) {
        try {
            if (!uri.equals("")) {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                String defaultNamespaceURI = this.ns.getPrefix("");
                if (defaultNamespaceURI != null && uri.equals(defaultNamespaceURI)) {
                    aPrefix = "";
                }
                if ((aPrefix = this.ns.getPrefix(uri)) == null) {
                    mustDeclarePrefix = true;
                    if (this.pfactory != null) {
                        aPrefix = this.pfactory.getPrefix(uri);
                    }
                    if (aPrefix == null) {
                        throw new XmlTreeWriterException("No Prefix For URI " + uri);
                    }
                }
                this.currentNode.addAttribute(XmlTreeWriter.getSoapFactory().createName(localName, aPrefix, uri), value);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            } else {
                this.currentNode.addAttribute(XmlTreeWriter.getSoapFactory().createName(localName), value);
            }
        }
        catch (SOAPException se) {
            throw new XmlTreeWriterException(se.getMessage());
        }
    }

    public void writeNamespaceDeclaration(String prefix, String uri) {
        this.ns.declarePrefix(prefix, uri);
        try {
            this.currentNode.addNamespaceDeclaration(prefix, uri);
        }
        catch (SOAPException se) {
            throw new XmlTreeWriterException(se.getMessage());
        }
    }

    public void writeNamespaceDeclaration(String uri) {
        if (this.pfactory == null) {
            throw new XmlTreeWriterException("No Prefix set for the XmlTreeWriter");
        }
        this.writeNamespaceDeclaration(this.pfactory.getPrefix(uri), uri);
    }

    public void writeChars(String chars) {
        this.writeCharsUnquoted(chars);
    }

    public void writeCharsUnquoted(String chars) {
        try {
            this.currentNode.addTextNode(chars);
        }
        catch (SOAPException se) {
            throw new XmlTreeWriterException(se.getMessage());
        }
    }

    public void writeCharsUnquoted(char[] buf, int offset, int len) {
        this.writeCharsUnquoted(new String(buf, offset, len));
    }

    public void endElement() {
        try {
            if (this.elementStack.size() < 1) {
                throw new XmlTreeWriterException("All Elements have already closed");
            }
            this.elementStack.pop();
            this.currentNode = this.currentNode.getParentElement();
            this.ns.popContext();
        }
        catch (Exception e) {
            throw new XmlTreeWriterException(e.getMessage());
        }
    }

    public PrefixFactory getPrefixFactory() {
        return this.pfactory;
    }

    public void setPrefixFactory(PrefixFactory factory) {
        this.pfactory = factory;
    }

    public String getURI(String prefix) {
        return this.ns.getURI(prefix);
    }

    public String getPrefix(String uri) {
        return this.ns.getPrefix(uri);
    }

    public void flush() {
    }

    public void close() {
    }

    public void writeChars(CDATA chars) {
        try {
            this.currentNode.addTextNode(chars.getText());
        }
        catch (SOAPException se) {
            throw new XmlTreeWriterException(se.getMessage());
        }
    }
}

