/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.callback.ValidatorExtension;
import com.sun.xml.wss.impl.callback.XWSSCallback;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;

public class CertificateValidationCallback
extends XWSSCallback
implements Callback {
    private boolean result = false;
    private CertificateValidator validator;
    private X509Certificate certificate;
    private boolean revocationEnabled = false;

    public CertificateValidationCallback(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public CertificateValidationCallback(X509Certificate certificate, Map context) {
        this.certificate = certificate;
        this.runtimeProperties = (HashMap)context;
    }

    public boolean getResult() {
        try {
            if (this.validator != null) {
                if (this.validator instanceof ValidatorExtension) {
                    ((ValidatorExtension)((Object)this.validator)).setRuntimeProperties(this.runtimeProperties);
                }
                this.result = this.validator.validate(this.certificate);
            }
        }
        catch (CertificateValidationException ex) {
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, ex.getMessage(), ex);
        }
        catch (Exception e) {
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
        }
        return this.result;
    }

    public void setValidator(CertificateValidator validator) {
        this.validator = validator;
        if (this.validator instanceof ValidatorExtension) {
            ((ValidatorExtension)((Object)this.validator)).setRuntimeProperties(this.getRuntimeProperties());
        }
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setRevocationEnabled(boolean revocationEnabled) {
        this.revocationEnabled = revocationEnabled;
    }

    public static class CertificateValidationException
    extends Exception {
        public CertificateValidationException(String message) {
            super(message);
        }

        public CertificateValidationException(String message, Throwable cause) {
            super(message, cause);
        }

        public CertificateValidationException(Throwable cause) {
            super(cause);
        }
    }

    public static interface CertificateValidator {
        public boolean validate(X509Certificate var1) throws CertificateValidationException;
    }
}

