/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.impl.policy.mls.Target;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;

public class SignatureTarget
extends Target
implements Cloneable {
    String _digestAlgorithm = "";
    ArrayList _transforms = new ArrayList();
    private boolean isOptimized = false;
    private String xpathVersion = "";

    public SignatureTarget() {
    }

    public SignatureTarget(Target target) {
        this.setEnforce(target.getEnforce());
        this.setType(target.getType());
        this.setValue(target.getValue());
        this.setContentOnly(target.getContentOnly());
        this._digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    public SignatureTarget(String digest, String transform) {
        this._digestAlgorithm = digest;
        this._transforms.add(new Transform(transform));
    }

    public String getDigestAlgorithm() {
        return this._digestAlgorithm;
    }

    public ArrayList getTransforms() {
        return this._transforms;
    }

    public void setDigestAlgorithm(String digest) {
        if (this.isBSP() && digest.intern() != "http://www.w3.org/2000/09/xmldsig#sha1") {
            throw new RuntimeException("Does not meet BSP requirement 5420 for Digest Algorithm");
        }
        this._digestAlgorithm = digest;
    }

    public void addTransform(Transform transform) {
        String transformStr = transform.getTransform();
        if (this.isBSP() && transformStr != "http://www.w3.org/2001/10/xml-exc-c14n#" && transformStr != "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete-Transform" && transformStr != "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform" && transformStr != "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform" && transformStr != "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform" && transformStr != "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform" && transformStr != "http://www.w3.org/2002/06/xmldsig-filter2") {
            throw new RuntimeException("Does not meet BSP requirement 5423 for signature transforms");
        }
        this._transforms.add(transform);
    }

    public Transform newSignatureTransform() {
        return new Transform();
    }

    public boolean equals(SignatureTarget target) {
        boolean b1 = this._digestAlgorithm.equals("") ? true : this._digestAlgorithm.equals(target.getDigestAlgorithm());
        boolean b2 = this._transforms.equals(target.getTransforms());
        return b1 && b2;
    }

    public Object clone() {
        SignatureTarget target = new SignatureTarget();
        try {
            ArrayList list = target.getTransforms();
            target.setDigestAlgorithm(this._digestAlgorithm);
            target.setValue(this.getValue());
            target.setType(this.getType());
            target.setContentOnly(this.getContentOnly());
            target.setEnforce(this.getEnforce());
            for (Transform transform : this._transforms) {
                list.add(transform.clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return target;
    }

    public boolean isIsOptimized() {
        return this.isOptimized;
    }

    public void setIsOptimized(boolean isOptimized) {
        this.isOptimized = isOptimized;
    }

    public void setXPathVersion(String version) {
        this.xpathVersion = version;
    }

    public String getXPathVersion() {
        return this.xpathVersion;
    }

    public static class Transform {
        String _transform = "";
        AlgorithmParameterSpec _algorithmParameters = null;
        private boolean disableInclusivePrefix = false;

        public Transform() {
        }

        public Transform(String algorithm) {
            this._transform = algorithm;
        }

        public AlgorithmParameterSpec getAlgorithmParameters() {
            return this._algorithmParameters;
        }

        public void setAlgorithmParameters(AlgorithmParameterSpec param) {
            this._algorithmParameters = param;
        }

        public void setTransform(String algorithm) {
            this._transform = algorithm;
        }

        public String getTransform() {
            return this._transform;
        }

        public boolean getDisableInclusivePrefix() {
            return this.disableInclusivePrefix;
        }

        public void setDisbaleInclusivePrefix(boolean disableInclusivePrefix) {
            this.disableInclusivePrefix = disableInclusivePrefix;
        }

        public boolean equals(Transform transform) {
            boolean b1;
            boolean bl = b1 = this._transform.equals("") ? true : this._transform.equals(transform.getTransform());
            if (!b1) {
                return false;
            }
            boolean b2 = this._algorithmParameters.equals(transform.getAlgorithmParameters());
            return b2;
        }

        public Object clone() {
            Transform transform = new Transform(this._transform);
            transform.setAlgorithmParameters(this._algorithmParameters);
            return transform;
        }
    }
}

