/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.docview;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.navigation.docview.DocViewTopComponent;
import org.netbeans.modules.cnd.spi.model.services.CsmDocProvider;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.parsing.spi.support.CancelSupport;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class DocViewCaretAwareFactory
extends IndexingAwareParserResultTask<Parser.Result> {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private static final RequestProcessor RP = new RequestProcessor("DocViewCaretAwareFactory runner", 1);
    private static final int TASK_DELAY = DocViewCaretAwareFactory.getInt("cnd.docview.delay", 500);
    private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
    private AtomicBoolean canceled = new AtomicBoolean(false);

    public DocViewCaretAwareFactory(String mimeType) {
        super(TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        DocViewCaretAwareFactory docViewCaretAwareFactory = this;
        synchronized (docViewCaretAwareFactory) {
            this.canceled.set(true);
            this.canceled = new AtomicBoolean(false);
        }
        if (this.cancel.isCancelled()) {
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        if (!this.isDocViewActive()) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (!(doc instanceof StyledDocument)) {
            return;
        }
        CsmFile csmFile = CsmFileInfoQuery.getDefault().getCsmFile(result);
        if (csmFile == null) {
            csmFile = (CsmFile)doc.getProperty(CsmFile.class);
        }
        if (csmFile == null) {
            return;
        }
        if (this.canceled.get()) {
            return;
        }
        long time = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "DocViewCaretAwareFactory started");
            time = System.currentTimeMillis();
        }
        RP.post((Runnable)new RunnerImpl(csmFile, (StyledDocument)doc, (CursorMovedSchedulerEvent)event, this.canceled, time + (long)TASK_DELAY), TASK_DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        DocViewCaretAwareFactory docViewCaretAwareFactory = this;
        synchronized (docViewCaretAwareFactory) {
            this.canceled.set(true);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "DocViewCaretAwareFactory canceled");
        }
    }

    public int getPriority() {
        return 1000;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    private static int getInt(String name, int result) {
        String text = System.getProperty(name);
        if (text != null) {
            try {
                result = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean isDocViewActive() {
        DocViewTopComponent instance = DocViewTopComponent.getInstance();
        return instance != null && instance.isActivated();
    }

    public static final class DocViewCaretAwareFactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new DocViewCaretAwareFactory(snapshot.getMimeType()));
        }
    }

    private static final class RunnerImpl
    implements Runnable {
        private final CsmFile file;
        private final StyledDocument doc;
        private final AtomicBoolean canceled;
        private final CursorMovedSchedulerEvent event;
        private final long time;

        private RunnerImpl(CsmFile file, StyledDocument doc, CursorMovedSchedulerEvent event, AtomicBoolean canceled, long time) {
            this.file = file;
            this.doc = doc;
            this.event = event;
            this.canceled = canceled;
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CsmCacheManager.enter();
                CsmReference ref = CsmReferenceResolver.getDefault().findReference((Document)this.doc, this.event.getCaretOffset());
                if (ref == null) {
                    return;
                }
                if (this.canceled.get()) {
                    return;
                }
                CsmObject csmObject = ref.getReferencedObject();
                if (csmObject == null) {
                    return;
                }
                if (this.canceled.get()) {
                    return;
                }
                CsmDocProvider p = (CsmDocProvider)Lookup.getDefault().lookup(CsmDocProvider.class);
                if (p == null) {
                    return;
                }
                CharSequence documentation = p.getDocumentation(csmObject, this.file);
                if (documentation == null) {
                    return;
                }
                if (this.canceled.get()) {
                    return;
                }
                CharSequence selfDoc = CsmDisplayUtilities.getTooltipText((CsmObject)csmObject);
                if (selfDoc != null) {
                    documentation = selfDoc.toString() + documentation.toString();
                }
                if (this.canceled.get()) {
                    return;
                }
                final CharSequence toShow = documentation;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DocViewTopComponent topComponent = DocViewTopComponent.findInstance();
                        if (topComponent != null && topComponent.isOpened()) {
                            topComponent.setDoc(toShow);
                        }
                    }
                });
            }
            finally {
                CsmCacheManager.leave();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "DocViewCaretAwareFactory finished for {0}ms", System.currentTimeMillis() - this.time);
                }
            }
        }

        public String toString() {
            if (this.file == null) {
                return "DocViewCaretAwareFactory runner";
            }
            return "DocViewCaretAwareFactory runner for " + this.file.getAbsolutePath();
        }
    }
}

