/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter.standard;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.Session;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.adapter.AbstractWebSocketSession;
import org.springframework.web.socket.adapter.standard.StandardToWebSocketExtensionAdapter;

public class StandardWebSocketSession
extends AbstractWebSocketSession<Session> {
    private final HttpHeaders handshakeHeaders;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private final Principal user;
    private List<WebSocketExtension> extensions;

    public StandardWebSocketSession(HttpHeaders headers, Map<String, Object> handshakeAttributes, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        this(headers, handshakeAttributes, localAddress, remoteAddress, null);
    }

    public StandardWebSocketSession(HttpHeaders headers, Map<String, Object> handshakeAttributes, InetSocketAddress localAddress, InetSocketAddress remoteAddress, Principal user) {
        super(handshakeAttributes);
        headers = headers != null ? headers : new HttpHeaders();
        this.handshakeHeaders = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.user = user;
    }

    @Override
    public String getId() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getId();
    }

    @Override
    public URI getUri() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getRequestURI();
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        return this.handshakeHeaders;
    }

    @Override
    public Principal getPrincipal() {
        if (this.user != null) {
            return this.user;
        }
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getUserPrincipal();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getAcceptedProtocol() {
        this.checkNativeSessionInitialized();
        String protocol = ((Session)this.getNativeSession()).getNegotiatedSubprotocol();
        return StringUtils.isEmpty((Object)protocol) ? null : protocol;
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        this.checkNativeSessionInitialized();
        if (this.extensions == null) {
            List source = ((Session)this.getNativeSession()).getNegotiatedExtensions();
            this.extensions = new ArrayList<WebSocketExtension>(source.size());
            for (Extension e : source) {
                this.extensions.add(new StandardToWebSocketExtensionAdapter(e));
            }
        }
        return this.extensions;
    }

    @Override
    public boolean isOpen() {
        return this.getNativeSession() != null && ((Session)this.getNativeSession()).isOpen();
    }

    @Override
    protected void sendTextMessage(TextMessage message) throws IOException {
        ((Session)this.getNativeSession()).getBasicRemote().sendText((String)message.getPayload(), message.isLast());
    }

    @Override
    protected void sendBinaryMessage(BinaryMessage message) throws IOException {
        ((Session)this.getNativeSession()).getBasicRemote().sendBinary((ByteBuffer)message.getPayload(), message.isLast());
    }

    @Override
    protected void sendPingMessage(PingMessage message) throws IOException {
        ((Session)this.getNativeSession()).getBasicRemote().sendPing((ByteBuffer)message.getPayload());
    }

    @Override
    protected void sendPongMessage(PongMessage message) throws IOException {
        ((Session)this.getNativeSession()).getBasicRemote().sendPong((ByteBuffer)message.getPayload());
    }

    @Override
    protected void closeInternal(CloseStatus status) throws IOException {
        ((Session)this.getNativeSession()).close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)status.getCode()), status.getReason()));
    }
}

