/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.classview.actions.GoToDeclarationAction;
import org.netbeans.modules.cnd.classview.resources.I18n;
import org.openide.util.CharSequences;
import org.openide.util.actions.Presenter;

public class MoreDeclarations
extends AbstractAction
implements Presenter.Popup {
    private static final String PROP_DECLARATION = "prop_declaration";
    private Collection<? extends CsmOffsetableDeclaration> arr;

    public MoreDeclarations(Collection<? extends CsmOffsetableDeclaration> arr) {
        this.arr = arr;
    }

    public JMenuItem getPopupPresenter() {
        JMenu result = new JMenu();
        ArrayList<ItemWrapper> list = new ArrayList<ItemWrapper>();
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : this.arr) {
            list.add(new ItemWrapper(csmOffsetableDeclaration));
        }
        Collections.sort(list);
        result.setText(I18n.getMessage("LBL_MoreDeclarations"));
        if (list.size() < 36) {
            for (ItemWrapper itemWrapper : list) {
                result.add(this.createItem(itemWrapper.decl));
            }
        } else {
            int n = (int)Math.ceil(Math.sqrt(list.size()));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JMenu current = new JMenu();
                CsmOffsetableDeclaration first = null;
                CsmOffsetableDeclaration last = null;
                for (int j = 0; j < n && iterator.hasNext(); ++j) {
                    CsmOffsetableDeclaration decl = ((ItemWrapper)iterator.next()).decl;
                    if (j == 0) {
                        first = decl;
                    } else {
                        last = decl;
                    }
                    current.add(this.createItem(decl));
                }
                if (first != null && last != null) {
                    current.setText(first.getContainingFile().getName() + " ... " + last.getContainingFile().getName());
                    result.add(current);
                    continue;
                }
                if (first == null) continue;
                result.add(this.createItem(first));
            }
        }
        return result;
    }

    private JMenuItem createItem(CsmOffsetableDeclaration decl) {
        JMenuItem item = new JMenuItem();
        CsmFile file = decl.getContainingFile();
        item.setText(file.getName().toString());
        item.putClientProperty(PROP_DECLARATION, decl);
        item.addActionListener(this);
        return item;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JMenuItem item = (JMenuItem)ae.getSource();
        CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)item.getClientProperty(PROP_DECLARATION);
        GoToDeclarationAction action = new GoToDeclarationAction((CsmOffsetable)decl, true);
        action.actionPerformed(null);
    }

    private static class ItemWrapper
    implements Comparable<ItemWrapper> {
        private CharSequence name;
        private CsmOffsetableDeclaration decl;

        private ItemWrapper(CsmOffsetableDeclaration decl) {
            this.decl = decl;
            this.name = decl.getContainingFile().getName();
        }

        @Override
        public int compareTo(ItemWrapper o) {
            return CharSequences.comparator().compare(this.name, o.name);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemWrapper other = (ItemWrapper)obj;
            return this.name == other.name || this.name != null && this.name.equals(other.name);
        }

        public int hashCode() {
            int hash = 5;
            hash = 61 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }
}

