/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.completion.implmethod;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmDocProvider;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CsmImplementsMethodCompletionItem
implements CompletionItem {
    private final int substitutionOffset;
    private final int priority;
    private final String sortItemText;
    private final boolean supportInstantSubst;
    private static final int PRIORITY = 15;
    private final String appendItemText;
    private final String htmlItemText;
    private final CsmFunction item;
    private final ImageIcon icon;
    private final String right;
    private final boolean isExtractBody;
    private final int startReplacement;
    private final int lengthReplacement;

    private CsmImplementsMethodCompletionItem(CsmFunction item, int substitutionOffset, int priority, String sortItemText, String appendItemText, String htmlItemText, boolean supportInstantSubst, String right, boolean isExtractBody, int startReplacement, int lengthReplacement) {
        this.substitutionOffset = substitutionOffset;
        this.priority = priority;
        this.supportInstantSubst = supportInstantSubst;
        this.sortItemText = sortItemText;
        this.appendItemText = appendItemText;
        this.htmlItemText = htmlItemText;
        this.item = item;
        this.icon = (ImageIcon)ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.icon2Image((Icon)CsmImageLoader.getIcon((CsmObject)item)), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/refactoring/resources/generate.png"), (int)0, (int)7));
        this.right = right;
        this.isExtractBody = isExtractBody;
        this.startReplacement = startReplacement;
        this.lengthReplacement = lengthReplacement;
    }

    public static CsmImplementsMethodCompletionItem createImplementItem(int substitutionOffset, int caretOffset, CsmClass cls, CsmFunction item, CsmScope insertScope) {
        String sortItemText = item.getName().toString();
        String appendItemText = CsmImplementsMethodCompletionItem.createAppendText(item, cls, "{\n\n}", insertScope);
        String rightText = CsmImplementsMethodCompletionItem.createRightName(item);
        String coloredItemText = CsmImplementsMethodCompletionItem.createDisplayName(item, cls, NbBundle.getMessage(CsmImplementsMethodCompletionItem.class, (String)"implement.txt"));
        return new CsmImplementsMethodCompletionItem(item, substitutionOffset, 15, sortItemText, appendItemText, coloredItemText, true, rightText, false, 0, 0);
    }

    public static CsmImplementsMethodCompletionItem createExtractBodyItem(int substitutionOffset, int caretOffset, CsmClass cls, CsmFunction item, CsmScope insertScope) {
        CsmConstructor con;
        Collection initializerList;
        String sortItemText = item.getName().toString();
        String rightText = CsmImplementsMethodCompletionItem.createRightName(item);
        String coloredItemText = CsmImplementsMethodCompletionItem.createDisplayName(item, cls, NbBundle.getMessage(CsmImplementsMethodCompletionItem.class, (String)"extract.txt"));
        CsmFile containingFile = item.getContainingFile();
        final CsmCompoundStatement body = ((CsmFunctionDefinition)item).getBody();
        if (item.getStartOffset() == body.getStartOffset()) {
            return null;
        }
        Document document = CsmUtilities.getDocument((CsmFile)containingFile);
        if (document == null) {
            CloneableEditorSupport support = CsmUtilities.findCloneableEditorSupport((CsmFile)containingFile);
            try {
                document = support.openDocument();
            }
            catch (IOException ex) {
                return null;
            }
        }
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        final BaseDocument classDoc = (BaseDocument)document;
        final int methodStartOffset = item.getStartOffset();
        if (CsmKindUtilities.isConstructor((CsmObject)item) && (initializerList = (con = (CsmConstructor)item).getInitializerList()) != null && initializerList.size() > 0) {
            final int startOffset = ((CsmExpression)initializerList.iterator().next()).getStartOffset();
            final AtomicInteger trueBodyStratOffset = new AtomicInteger(0);
            final String[] res = new String[1];
            classDoc.render(new Runnable(){

                @Override
                public void run() {
                    TokenHierarchy hi = TokenHierarchy.get((Document)classDoc);
                    TokenSequence ts = hi.tokenSequence();
                    ts.move(startOffset);
                    boolean columnFound = false;
                    while (ts.movePrevious()) {
                        Token token = ts.token();
                        if (ts.offset() < methodStartOffset) break;
                        if (columnFound) {
                            if (!"whitespace".equals(token.id().primaryCategory()) && !"comment".equals(token.id().primaryCategory())) break;
                            trueBodyStratOffset.set(ts.offset());
                            continue;
                        }
                        if (!CppTokenId.COLON.equals((Object)token.id())) continue;
                        trueBodyStratOffset.set(ts.offset());
                        columnFound = true;
                    }
                    if (trueBodyStratOffset.get() > 0) {
                        try {
                            res[0] = classDoc.getText(trueBodyStratOffset.get(), body.getEndOffset() - trueBodyStratOffset.get());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
            if (trueBodyStratOffset.get() > 0) {
                String bodyText = res[0];
                String appendItemText = CsmImplementsMethodCompletionItem.createAppendText(item, cls, bodyText, insertScope);
                return new CsmImplementsMethodCompletionItem(item, substitutionOffset, 15, sortItemText, appendItemText, coloredItemText, true, rightText, true, trueBodyStratOffset.get(), bodyText.length());
            }
            return null;
        }
        final int startOffset = body.getStartOffset();
        final AtomicInteger trueBodyStratOffset = new AtomicInteger(startOffset);
        final String[] res = new String[1];
        classDoc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy hi = TokenHierarchy.get((Document)classDoc);
                TokenSequence ts = hi.tokenSequence();
                ts.move(startOffset);
                while (ts.movePrevious()) {
                    Token token = ts.token();
                    if (ts.offset() < methodStartOffset || !"whitespace".equals(token.id().primaryCategory()) && !"comment".equals(token.id().primaryCategory())) break;
                    trueBodyStratOffset.set(ts.offset());
                }
                try {
                    res[0] = classDoc.getText(trueBodyStratOffset.get(), body.getEndOffset() - trueBodyStratOffset.get());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        String bodyText = res[0];
        if (bodyText == null) {
            return null;
        }
        String appendItemText = CsmImplementsMethodCompletionItem.createAppendText(item, cls, bodyText, insertScope);
        return new CsmImplementsMethodCompletionItem(item, substitutionOffset, 15, sortItemText, appendItemText, coloredItemText, true, rightText, true, trueBodyStratOffset.get(), bodyText.length());
    }

    private static String createDisplayName(CsmFunction item, CsmClass parent, String operation) {
        StringBuilder displayName = new StringBuilder();
        displayName.append(CsmDisplayUtilities.htmlize((CharSequence)parent.getName()));
        displayName.append("::");
        displayName.append("<b>");
        displayName.append(CsmDisplayUtilities.htmlize((CharSequence)item.getSignature()));
        displayName.append("</b>");
        if (operation != null) {
            displayName.append(" - ");
            displayName.append(CsmDisplayUtilities.htmlize((CharSequence)operation));
        }
        return displayName.toString();
    }

    private static String createRightName(CsmFunction item) {
        if (CsmKindUtilities.isConstructor((CsmObject)item)) {
            return "";
        }
        if (CsmKindUtilities.isDestructor((CsmObject)item)) {
            return "";
        }
        return item.getReturnType().getText().toString();
    }

    private static String createAppendText(CsmFunction item, CsmClass parent, String bodyText, CsmScope insertScope) {
        StringBuilder appendItemText = new StringBuilder("\n");
        CsmImplementsMethodCompletionItem.addTemplate(item, parent, appendItemText);
        String type = "";
        if (!CsmKindUtilities.isConstructor((CsmObject)item) && !CsmKindUtilities.isDestructor((CsmObject)item)) {
            CsmClassifier classifier;
            CsmType returnType = item.getReturnType();
            type = returnType.getText().toString() + " ";
            if (!returnType.isTemplateBased() && type.indexOf("::") < 0 && (classifier = returnType.getClassifier()) != null) {
                CsmScope scope;
                String toReplace = classifier.getName().toString();
                if (type.indexOf(toReplace) == 0) {
                    scope = classifier.getScope();
                    if (CsmKindUtilities.isClass((CsmObject)scope)) {
                        type = ((CsmClass)scope).getName() + "::" + type;
                    }
                } else if (type.startsWith("const " + toReplace) && CsmKindUtilities.isClass((CsmObject)(scope = classifier.getScope()))) {
                    type = "const " + ((CsmClass)scope).getName() + "::" + type.substring(6);
                }
            }
        }
        appendItemText.append(type);
        if (!CsmKindUtilities.isFriendMethod((CsmObject)item)) {
            CsmTemplate template;
            List templateParameters;
            String scope = CsmImplementsMethodCompletionItem.getQualifiedName(insertScope, (CsmScope)parent);
            if (scope.isEmpty()) {
                appendItemText.append(parent.getName());
            } else {
                appendItemText.append(scope);
            }
            if (CsmKindUtilities.isTemplate((CsmObject)parent) && (templateParameters = (template = (CsmTemplate)parent).getTemplateParameters()).size() > 0) {
                appendItemText.append("<");
                boolean first = true;
                for (CsmTemplateParameter param : templateParameters) {
                    if (!first) {
                        appendItemText.append(", ");
                    }
                    first = false;
                    appendItemText.append(param.getName());
                }
                appendItemText.append(">");
            }
            appendItemText.append("::");
        }
        CsmImplementsMethodCompletionItem.addSignature(item, appendItemText);
        appendItemText.append(bodyText);
        appendItemText.append("\n");
        return appendItemText.toString();
    }

    private static String getQualifiedName(CsmScope from, CsmScope to) {
        ArrayList<CsmScope> scopes = new ArrayList<CsmScope>();
        while (!Objects.equals(from, to) && CsmKindUtilities.isScopeElement((CsmObject)to)) {
            scopes.add(0, to);
            to = ((CsmScopeElement)to).getScope();
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (CsmScope scope : scopes) {
            CsmNamedElement named;
            if (!CsmKindUtilities.isNamedElement((CsmObject)scope) || CharSequenceUtils.isNullOrEmpty((CharSequence)(named = (CsmNamedElement)scope).getName())) continue;
            if (!first) {
                sb.append("::");
            } else {
                first = false;
            }
            sb.append(named.getName());
        }
        return sb.toString();
    }

    private static void addTemplate(CsmFunction item, CsmClass parent, StringBuilder sb) {
        boolean first;
        CsmTemplate template;
        List templateParameters;
        if (CsmKindUtilities.isTemplate((CsmObject)parent) && (templateParameters = (template = (CsmTemplate)parent).getTemplateParameters()).size() > 0) {
            sb.append("template<");
            first = true;
            for (CsmTemplateParameter param : templateParameters) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(param.getText());
            }
            sb.append(">\n");
        }
        if (!CsmKindUtilities.isFriendMethod((CsmObject)item) && CsmKindUtilities.isTemplate((CsmObject)item) && (templateParameters = (template = (CsmTemplate)item).getTemplateParameters()).size() > 0) {
            sb.append("template<");
            first = true;
            for (CsmTemplateParameter param : templateParameters) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(param.getText());
            }
            sb.append(">\n");
        }
    }

    private static void addSignature(CsmFunction item, StringBuilder sb) {
        sb.append(item.getName());
        sb.append('(');
        boolean first = true;
        for (CsmParameter param : item.getParameterList().getParameters()) {
            if (!first) {
                sb.append(',');
                sb.append(' ');
            }
            first = false;
            sb.append(param.getDisplayText());
        }
        sb.append(')');
        if (CsmKindUtilities.isMethod((CsmObject)item) && ((CsmMethod)item).isConst()) {
            sb.append(" const");
        }
    }

    public String getItemText() {
        return this.appendItemText;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        JTextComponent component;
        int caretOffset;
        int len;
        if (evt.getID() == 400 && (len = (caretOffset = (component = (JTextComponent)evt.getSource()).getSelectionEnd()) - this.substitutionOffset) < 0) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (this.supportInstantSubst) {
            this.defaultAction(component);
            return true;
        }
        return false;
    }

    public CompletionTask createDocumentationTask() {
        CsmDocProvider p = (CsmDocProvider)Lookup.getDefault().lookup(CsmDocProvider.class);
        if (p != null) {
            return p.createDocumentationTask((CsmObject)this.item);
        }
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getLeftHtmlText(false));
        out.append(this.getRightHtmlText(false));
        return out.toString();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.sortItemText;
    }

    public CharSequence getInsertPrefix() {
        return this.sortItemText;
    }

    protected ImageIcon getIcon() {
        return this.icon;
    }

    protected String getLeftHtmlText(boolean html) {
        return html ? this.htmlItemText : this.getItemText();
    }

    protected String getRightHtmlText(boolean html) {
        return this.right;
    }

    protected void substituteText(final JTextComponent c, final int offset, final int origLen) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        doc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        int setDot;
                        if (origLen > 0) {
                            doc.remove(offset, origLen);
                        }
                        String itemText = CsmImplementsMethodCompletionItem.this.getItemText();
                        doc.insertString(offset, itemText, null);
                        if (c == null) break block8;
                        if (CsmImplementsMethodCompletionItem.this.isExtractBody) {
                            setDot = offset;
                            c.setCaretPosition(setDot);
                        } else {
                            setDot = offset + itemText.length() - 3;
                            c.setCaretPosition(setDot);
                        }
                        Reformat reformat = Reformat.get((Document)doc);
                        reformat.lock();
                        try {
                            reformat.reformat(offset + 1, offset + itemText.length() - 1);
                        }
                        finally {
                            reformat.unlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        if (this.isExtractBody) {
            CsmFile containingFile = this.item.getContainingFile();
            Document document = CsmUtilities.getDocument((CsmFile)containingFile);
            if (document == null) {
                CloneableEditorSupport support = CsmUtilities.findCloneableEditorSupport((CsmFile)containingFile);
                try {
                    document = support.openDocument();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (document instanceof BaseDocument) {
                final BaseDocument classDoc = (BaseDocument)document;
                classDoc.runAtomicAsUser(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            classDoc.remove(CsmImplementsMethodCompletionItem.this.startReplacement, CsmImplementsMethodCompletionItem.this.lengthReplacement);
                            classDoc.insertString(CsmImplementsMethodCompletionItem.this.startReplacement, ";", null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }
}

