/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.refactoring.hints.IntroduceVariableBaseFix;
import org.netbeans.modules.cnd.refactoring.hints.SuggestionFactoryTask;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class AssignmentVariableFix
extends IntroduceVariableBaseFix {
    final FileObject fo;
    private String type;

    public AssignmentVariableFix(CsmExpression expression, Document doc, FileObject fo) {
        super((CsmOffsetable)expression, doc);
        this.fo = fo;
    }

    public String getText() {
        return NbBundle.getMessage(SuggestionFactoryTask.class, (String)"FIX_AssignResultToVariable");
    }

    @Override
    protected boolean isC() {
        return "text/x-c".equals(this.fo.getMIMEType());
    }

    @Override
    protected boolean isInstanceRename() {
        return true;
    }

    @Override
    protected List<Pair<Integer, Integer>> replaceOccurrences() {
        return Collections.emptyList();
    }

    @Override
    protected String getType() {
        return this.type;
    }

    public ChangeInfo implement() throws Exception {
        this.type = this.suggestType();
        if (this.type == null) {
            return null;
        }
        String aName = this.suggestName();
        if (aName == null) {
            return null;
        }
        final String text = this.getType() + " " + aName + " = ";
        this.doc.insertString(this.expression.getStartOffset(), text, null);
        Position startPosition = new Position(){

            @Override
            public int getOffset() {
                return AssignmentVariableFix.this.expression.getStartOffset() + AssignmentVariableFix.this.getType().length() + 1;
            }
        };
        Position endPosition = new Position(){

            @Override
            public int getOffset() {
                return AssignmentVariableFix.this.expression.getStartOffset() + text.length() - 3;
            }
        };
        ChangeInfo changeInfo = new ChangeInfo(this.fo, startPosition, endPosition);
        return changeInfo;
    }
}

