/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui.tree;

import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;

public class ParentTreeElement
implements TreeElement {
    private final CsmUID<CsmObject> element;
    private final Icon icon;
    private final String text;

    public ParentTreeElement(CsmObject element) {
        this.element = CsmRefactoringUtils.getHandler(element);
        this.icon = CsmImageLoader.getIcon((CsmObject)element);
        this.text = CsmRefactoringUtils.getHtml(element);
    }

    public TreeElement getParent(boolean isLogical) {
        CsmObject enclosing = this.getParent();
        if (enclosing != null) {
            return TreeElementFactory.getTreeElement((Object)enclosing);
        }
        System.err.println("element without parent " + this.getUserObject());
        return null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean isLogical) {
        return this.text;
    }

    public Object getUserObject() {
        return this.element.getObject();
    }

    private CsmObject getParent() {
        CsmObject obj = (CsmObject)this.getUserObject();
        CsmObject enclosing = null;
        if (obj != null) {
            enclosing = CsmRefactoringUtils.getEnclosingElement(obj);
        }
        return enclosing;
    }
}

