/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.debugging;

import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public abstract class DebuggingViewModel
implements TreeModel,
ModelListener {
    private final NativeDebugger debugger;
    private final Collection<ModelListener> listeners = new HashSet<ModelListener>();

    protected DebuggingViewModel(ContextProvider lookupProvider) {
        this.debugger = (NativeDebugger)lookupProvider.lookupFirst(null, NativeDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent.equals("Root")) {
            return this.debugger.getThreadsWithStacks();
        }
        if (parent instanceof Thread) {
            return ((Thread)parent).getStack();
        }
        return new Object[0];
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        return this.getChildrenCount(node) == 0;
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        Object[] ch = this.getChildren(node, 0, 0);
        return ch == null ? 0 : ch.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
        }
        this.debugger.registerDebuggingViewModel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
        this.debugger.registerDebuggingViewModel(null);
    }

    public void modelChanged(ModelEvent event) {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged(event);
        }
    }
}

