/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public abstract class IOProxy {
    private static final String FILENAME_PREFIX = "debuggerFifo";
    private static final String FILENAME_EXTENSION = ".fifo";
    private InputWriterThread irt = null;
    private final Reader ioReader;
    private OutputReaderThread ort = null;
    private final Writer ioWriter;

    public static IOProxy create(ExecutionEnvironment execEnv, InputOutput io) {
        IOProxy res = execEnv == null || execEnv.isLocal() ? new LocalIOProxy(io.getIn(), (Writer)io.getOut()) : new RemoteIOProxy(execEnv, io.getIn(), (Writer)io.getOut());
        super.start();
        return res;
    }

    private IOProxy(Reader ioReader, Writer ioWriter) {
        this.ioReader = ioReader;
        this.ioWriter = ioWriter;
    }

    private void start() {
        this.irt = new InputWriterThread();
        this.irt.start();
        this.ort = new OutputReaderThread();
        this.ort.start();
    }

    public void stop() {
        if (this.irt != null) {
            this.irt.cancel();
            try {
                this.ioReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.ort != null) {
            this.ort.cancel();
            try {
                this.ioWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    abstract String[] getIOFiles();

    protected abstract OutputStream createInStream() throws IOException;

    protected abstract InputStream createOutStream() throws IOException;

    private static class RemoteIOProxy
    extends IOProxy {
        private final Future<String> inFilename;
        private final Future<String> outFilename;
        private final ExecutionEnvironment execEnv;
        private final RequestProcessor RP = new RequestProcessor("Remote fifo creator", 2);

        public RemoteIOProxy(ExecutionEnvironment execEnv, Reader ioReader, Writer ioWriter) {
            super(ioReader, ioWriter);
            this.execEnv = execEnv;
            this.inFilename = this.createNewFifo();
            this.outFilename = this.createNewFifo();
        }

        @Override
        String[] getIOFiles() {
            try {
                return new String[]{this.inFilename.get(), this.outFilename.get()};
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        protected OutputStream createInStream() throws IOException {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
            try {
                npb.setCommandLine("cat > " + this.inFilename.get());
                return ((NativeProcess)ProcessUtils.ignoreProcessError((Process)npb.call())).getOutputStream();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        protected InputStream createOutStream() throws IOException {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
            try {
                npb.setCommandLine("cat " + this.outFilename.get());
                return ((NativeProcess)ProcessUtils.ignoreProcessError((Process)npb.call())).getInputStream();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        private Future<String> createNewFifo() {
            return this.RP.submit((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String tmpDir;
                    try {
                        tmpDir = HostInfoUtils.getHostInfo((ExecutionEnvironment)RemoteIOProxy.this.execEnv).getTempDir();
                    }
                    catch (Exception iOException) {
                        tmpDir = "/tmp";
                    }
                    String name = tmpDir + '/' + IOProxy.FILENAME_PREFIX + "$$" + IOProxy.FILENAME_EXTENSION;
                    ProcessUtils.ExitStatus status = ProcessUtils.execute((ExecutionEnvironment)RemoteIOProxy.this.execEnv, (String)"sh", (String[])new String[]{"-c", "mkfifo " + name + ";echo " + name});
                    if (status.isOK()) {
                        return status.getOutputString();
                    }
                    return null;
                }
            });
        }

        @Override
        public void stop() {
            super.stop();
            try {
                CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)this.inFilename.get(), null);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)this.outFilename.get(), null);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class LocalIOProxy
    extends IOProxy {
        private final File inFile = LocalIOProxy.createNewFifo();
        private final File outFile;

        public LocalIOProxy(Reader ioReader, Writer ioWriter) {
            super(ioReader, ioWriter);
            this.inFile.deleteOnExit();
            this.outFile = LocalIOProxy.createNewFifo();
            this.outFile.deleteOnExit();
        }

        private static File createNewFifo() {
            try {
                File file = File.createTempFile(IOProxy.FILENAME_PREFIX, IOProxy.FILENAME_EXTENSION);
                file.delete();
                String tool = "mkfifo";
                if (Utilities.isWindows()) {
                    tool = tool + ".exe";
                    File toolFile = new File(CompilerSetUtils.getCygwinBase() + "/bin", tool);
                    if (toolFile.exists()) {
                        tool = toolFile.getAbsolutePath();
                    } else {
                        toolFile = new File(CompilerSetUtils.getCommandFolder(null), tool);
                        if (toolFile.exists()) {
                            tool = toolFile.getAbsolutePath();
                        }
                    }
                }
                ProcessBuilder pb = new ProcessBuilder(tool, file.getAbsolutePath());
                ProcessUtils.execute((ProcessBuilder)pb);
                return file;
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                return null;
            }
        }

        @Override
        protected OutputStream createInStream() throws IOException {
            return new FileOutputStream(this.inFile);
        }

        @Override
        String[] getIOFiles() {
            return new String[]{this.inFile.getAbsolutePath(), this.outFile.getAbsolutePath()};
        }

        @Override
        protected InputStream createOutStream() throws IOException {
            return new FileInputStream(this.outFile);
        }

        @Override
        public void stop() {
            super.stop();
            this.inFile.delete();
            this.outFile.delete();
        }
    }

    private class OutputReaderThread
    extends Thread {
        private volatile boolean cancel = false;

        public OutputReaderThread() {
            this.setName("TTY OutputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            InputStream in = null;
            try {
                in = IOProxy.this.createOutStream();
                while (true) {
                    int read;
                    if ((read = in.read()) == -1) {
                        if (!this.cancel) continue;
                        return;
                    }
                    IOProxy.this.ioWriter.write((char)(read == 10 ? 10 : (char)read));
                    continue;
                    break;
                }
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                try {
                    IOProxy.this.ioWriter.flush();
                }
                catch (IOException iOException) {}
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }

    private class InputWriterThread
    extends Thread {
        private volatile boolean cancel = false;

        public InputWriterThread() {
            this.setName("TTY InputWriterThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream pout = null;
            try {
                pout = IOProxy.this.createInStream();
                while (true) {
                    int ch;
                    if ((ch = IOProxy.this.ioReader.read()) != -1) {
                        if (this.cancel) {
                            return;
                        }
                        pout.write((char)ch);
                        pout.flush();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    pout.flush();
                    pout.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }
}

