/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.turbo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public abstract class CacheIndex {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.turbo.CacheIndex");
    private Map<VCSFileProxy, Set<VCSFileProxy>> index = new ConcurrentHashMap<VCSFileProxy, Set<VCSFileProxy>>();

    protected abstract boolean isManaged(VCSFileProxy var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSFileProxy[] get(VCSFileProxy key) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "get({0})", new Object[]{key});
        }
        if (key == null) {
            return new VCSFileProxy[0];
        }
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Set<VCSFileProxy> ret = this.index.get(key);
            if (ret == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " get({0}) returns no files", new Object[]{key});
                }
                return new VCSFileProxy[0];
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " get({0}) returns {1}", new Object[]{key, ret.size()});
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("   " + ret);
            }
            return ret.toArray(new VCSFileProxy[ret.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSFileProxy[] getAllValues() {
        ArrayList<Set<VCSFileProxy>> values;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getAllValues()");
        }
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Collection<Set<VCSFileProxy>> c = this.index.values();
            values = new ArrayList<Set<VCSFileProxy>>(c.size());
            values.addAll(c);
        }
        HashSet ret = new HashSet();
        for (Set set : values) {
            CacheIndex cacheIndex2 = this;
            synchronized (cacheIndex2) {
                ret.addAll(set);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, " getAllValues() returns {0}", new Object[]{ret.size()});
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("   " + ret);
        }
        return ret.toArray(new VCSFileProxy[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RCN"})
    public void add(VCSFileProxy file) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "add({0})", new Object[]{file});
        }
        assert (file != null);
        if (file == null) {
            return;
        }
        VCSFileProxy parent = file.getParentFile();
        if (parent == null) {
            LOG.log(Level.INFO, "add: trying to add a FS root {0})", new Object[]{file});
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "add: trying to add a FS root", new Exception());
            }
            return;
        }
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Set<Object> set = this.index.get(parent);
            if (set == null) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "  add({0}) - creating new file entry", new Object[]{file});
                }
                set = Collections.synchronizedSet(new HashSet());
                set.add(file);
                this.index.put(parent, set);
            } else {
                set.add(file);
            }
            this.ensureParents(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(VCSFileProxy file, Set<VCSFileProxy> files) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "add({0}, Set<File>)", new Object[]{file});
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("   " + files);
        }
        if (files == null) {
            files = new HashSet<VCSFileProxy>(0);
        }
        HashSet<VCSFileProxy> newSet = new HashSet<VCSFileProxy>(files.size());
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Set<VCSFileProxy> oldSet = this.index.get(file);
            if (oldSet != null) {
                for (VCSFileProxy f : oldSet) {
                    if (files.contains(f) || this.index.get(f) == null) continue;
                    newSet.add(f);
                }
            }
            newSet.addAll(files);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  add({0}, Set<File>) - add entries", new Object[]{file});
            }
            this.index.put(file, Collections.synchronizedSet(newSet));
            if (newSet.size() > 0) {
                this.ensureParents(file);
            } else {
                this.cleanUpParents(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParents(VCSFileProxy file) {
        VCSFileProxy pFile = file;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "  ensureParents({0})", new Object[]{pFile});
        }
        while (true) {
            VCSFileProxy parent = file.getParentFile();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  ensureParents({0}) - parent {1}", new Object[]{pFile, parent});
            }
            if (parent == null) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "  ensureParents({0}) - done", new Object[]{pFile});
                break;
            }
            CacheIndex cacheIndex = this;
            synchronized (cacheIndex) {
                Set<VCSFileProxy> set = this.index.get(parent);
                if (set == null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - no entry", new Object[]{pFile, parent});
                    }
                    if (!this.isManaged(parent)) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - not managed - done!", new Object[]{pFile, parent});
                        }
                        break;
                    }
                    set = new HashSet<VCSFileProxy>();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - creating parent node", new Object[]{pFile, parent});
                    }
                    this.index.put(parent, set);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - adding file {2}", new Object[]{pFile, parent, file});
                }
                set.add(file);
            }
            file = parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanUpParents(VCSFileProxy file) {
        VCSFileProxy parent;
        Set<VCSFileProxy> set;
        VCSFileProxy pFile = file;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "  cleanUpParents({0})", new Object[]{pFile});
        }
        if ((set = this.index.get(file)) != null && set.size() > 0) {
            if (!LOG.isLoggable(Level.FINE)) return;
            LOG.log(Level.FINE, "  cleanUpParents({0}) - children underneath. stop.", new Object[]{pFile});
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "  cleanUpParents({0}) - removing node", new Object[]{pFile});
        }
        this.index.remove(file);
        while (true) {
            parent = file.getParentFile();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1}", new Object[]{pFile, parent});
            }
            if (parent == null) {
                if (!LOG.isLoggable(Level.FINE)) return;
                LOG.log(Level.FINE, "  cleanUpParents({0}) - done", new Object[]{pFile});
                return;
            }
            CacheIndex cacheIndex = this;
            synchronized (cacheIndex) {
                set = this.index.get(parent);
                if (set == null) {
                    if (!LOG.isLoggable(Level.FINE)) return;
                    LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} empty - stop", new Object[]{pFile, parent});
                    return;
                }
                if (set.size() != 1) break;
                VCSFileProxy lastLonelyFile = set.iterator().next();
                if (!file.equals((Object)lastLonelyFile)) return;
                if (this.index.get(lastLonelyFile) != null) return;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} size 1 - remove", new Object[]{pFile, parent});
                }
                this.index.remove(parent);
            }
            file = parent;
        }
        {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} - remove file {2}", new Object[]{pFile, parent, file});
            }
            if (this.index.get(file) != null) return;
            set.remove(file);
            return;
        }
    }
}

