/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class GenericTypeSerializer
implements JavonSerializer {
    @Override
    public String getName() {
        return "Generic type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (type.getKind() == TypeKind.DECLARED) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String classFQN = clazz.getQualifiedName().toString();
            if ("java.util.List".equals(classFQN) || "java.util.Vector".equals(classFQN) || "java.util.Stack".equals(classFQN)) {
                List<? extends TypeMirror> typeParams = ((DeclaredType)type).getTypeArguments();
                if (typeParams.size() == 0) {
                    return false;
                }
                if (typeParams.size() != 1) {
                    return false;
                }
                for (TypeMirror typeMirror : typeParams) {
                    TypeElement paramElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                    if (paramElement.getQualifiedName().toString().startsWith("java.util")) {
                        return false;
                    }
                    if (traversable.isTypeSupported(typeMirror, typeCache)) continue;
                    return false;
                }
                return true;
            }
            if ("java.util.Hashtable".equals(classFQN)) {
                List<? extends TypeMirror> typeParams = ((DeclaredType)type).getTypeArguments();
                if (typeParams.size() == 0) {
                    return false;
                }
                if (typeParams.size() != 2) {
                    return false;
                }
                for (TypeMirror typeMirror : typeParams) {
                    TypeElement paramElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                    if (paramElement.getQualifiedName().toString().startsWith("java.util")) {
                        return false;
                    }
                    if (traversable.isTypeSupported(typeMirror, typeCache)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (this.isTypeSupported(traversable, type, typeCache)) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String classFQN = clazz.getQualifiedName().toString();
            if ("java.util.List".equals(classFQN)) {
                ClassData cd = new ClassData("java.util", "List", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> typeParams = ((DeclaredType)type).getTypeArguments();
                ArrayList<ClassData> typeParameters = new ArrayList<ClassData>();
                for (TypeMirror typeMirror : typeParams) {
                    ClassData cdp = traversable.traverseType(typeMirror, typeCache);
                    if (cdp == null) {
                        return null;
                    }
                    typeParameters.add(cdp);
                }
                cd.setParameterTypes(typeParameters);
                for (ClassData classData : typeParameters) {
                    traversable.registerType(classData);
                }
                return cd;
            }
            if ("java.util.Vector".equals(classFQN)) {
                ClassData cd = new ClassData("java.util", "Vector", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> typeParams = ((DeclaredType)type).getTypeArguments();
                ArrayList<ClassData> typeParameters = new ArrayList<ClassData>();
                for (TypeMirror typeMirror : typeParams) {
                    ClassData cdp = traversable.traverseType(typeMirror, typeCache);
                    if (cdp == null) {
                        return null;
                    }
                    typeParameters.add(cdp);
                }
                cd.setParameterTypes(typeParameters);
                for (ClassData classData : typeParameters) {
                    traversable.registerType(classData);
                }
                return cd;
            }
            if ("java.util.Stack".equals(classFQN)) {
                ClassData cd = new ClassData("java.util", "Stack", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> typeParams = ((DeclaredType)type).getTypeArguments();
                ArrayList<ClassData> typeParameters = new ArrayList<ClassData>();
                for (TypeMirror typeMirror : typeParams) {
                    ClassData cdp = traversable.traverseType(typeMirror, typeCache);
                    if (cdp == null) {
                        return null;
                    }
                    typeParameters.add(cdp);
                }
                cd.setParameterTypes(typeParameters);
                for (ClassData classData : typeParameters) {
                    traversable.registerType(classData);
                }
                return cd;
            }
            if ("java.util.Hashtable".equals(classFQN)) {
                ClassData cd = new ClassData("java.util", "Hashtable", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> typeParams = ((DeclaredType)type).getTypeArguments();
                ArrayList<ClassData> typeParameters = new ArrayList<ClassData>();
                for (TypeMirror typeMirror : typeParams) {
                    ClassData cdp = traversable.traverseType(typeMirror, typeCache);
                    if (cdp == null) {
                        return null;
                    }
                    typeParameters.add(cdp);
                }
                cd.setParameterTypes(typeParameters);
                for (ClassData classData : typeParameters) {
                    traversable.registerType(classData);
                }
                return cd;
            }
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping mapping, ClassData type) {
        ClassData parameterType = type.getParameterTypes().get(0);
        String typeFQN = type.getFullyQualifiedName();
        if ("java.util.List".equals(typeFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                return parameterType.getSerializer().instanceOf(mapping, parameterType) + "[]";
            }
            return type.getName() + "<" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ">";
        }
        if ("java.util.Vector".equals(typeFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                return type.getName();
            }
            return type.getName() + "<" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ">";
        }
        if ("java.util.Stack".equals(typeFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                return type.getName();
            }
            return type.getName() + "<" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ">";
        }
        if ("java.util.Hashtable".equals(typeFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                return type.getName();
            }
            return type.getName() + "<" + parameterType.getSerializer().instanceOf(mapping, parameterType) + "," + type.getParameterTypes().get(1).getSerializer().instanceOf(mapping, type.getParameterTypes().get(1)) + ">";
        }
        throw new IllegalArgumentException("Invalid type: " + typeFQN);
    }

    @Override
    public String toObject(JavonMapping mapping, ClassData type, String variable) {
        return variable;
    }

    @Override
    public String fromObject(JavonMapping mapping, ClassData type, String object) {
        return "(" + type.getSerializer().instanceOf(mapping, type) + ")" + object;
    }

    @Override
    public String toStream(JavonMapping mapping, ClassData type, String stream, String object) {
        ClassData parameterType = type.getParameterTypes().get(0);
        int id = mapping.getRegistry().getRegisteredTypeId(type);
        String genericsType = type.getSerializer().instanceOf(mapping, type);
        String classFQN = type.getFullyQualifiedName();
        if ("java.util.List".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String serializationCode = "";
                serializationCode = serializationCode + genericsType + " g_" + id + " = (" + genericsType + ") o;\n";
                serializationCode = serializationCode + "out.writeInt( g_" + id + ".length );\n";
                serializationCode = serializationCode + "for( int i = 0; i < g_" + id + ".length; i++ ) {\n";
                serializationCode = serializationCode + "writeObject( out, g_" + id + "[i], " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
                serializationCode = serializationCode + "}";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "@SuppressWarnings( \"unchecked\" )\n";
            serializationCode = serializationCode + genericsType + " g_" + id + " = (" + genericsType + ") o;\n";
            serializationCode = serializationCode + "output.writeInt( g_" + id + ".size());\n";
            serializationCode = serializationCode + "for( " + parameterType.getSerializer().instanceOf(mapping, parameterType) + " g : g_" + id + " ) {\n";
            serializationCode = serializationCode + "writeObject( output, g, " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
            serializationCode = serializationCode + "}";
            return serializationCode;
        }
        if ("java.util.Vector".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String serializationCode = "";
                serializationCode = serializationCode + "java.util.Vector g_" + id + " = (java.util.Vector) o;\n";
                serializationCode = serializationCode + "out.writeInt( g_" + id + ".size());\n";
                serializationCode = serializationCode + "for( int i = 0; i < g_" + id + ".size(); i++ ) {\n";
                serializationCode = serializationCode + "writeObject( out, g_" + id + ".elementAt( i ), " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
                serializationCode = serializationCode + "}";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "@SuppressWarnings( \"unchecked\" )\n";
            serializationCode = serializationCode + genericsType + " g_" + id + " = (" + genericsType + ") o;\n";
            serializationCode = serializationCode + "output.writeInt( g_" + id + ".size());\n";
            serializationCode = serializationCode + "for( " + parameterType.getSerializer().instanceOf(mapping, parameterType) + " g : g_" + id + " ) {\n";
            serializationCode = serializationCode + "writeObject( output, g, " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
            serializationCode = serializationCode + "}";
            return serializationCode;
        }
        if ("java.util.Stack".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String serializationCode = "";
                serializationCode = serializationCode + "java.util.Stack g_" + id + " = (java.util.Stack) o;\n";
                serializationCode = serializationCode + "out.writeInt( g_" + id + ".size());\n";
                serializationCode = serializationCode + "for( int i = 0; i < g_" + id + ".size(); i++ ) {\n";
                serializationCode = serializationCode + "writeObject( out, g_" + id + ".elementAt( i ), " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
                serializationCode = serializationCode + "}";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "@SuppressWarnings( \"unchecked\" )\n";
            serializationCode = serializationCode + genericsType + " g_" + id + " = (" + genericsType + ") o;\n";
            serializationCode = serializationCode + "output.writeInt( g_" + id + ".size());\n";
            serializationCode = serializationCode + "for( " + parameterType.getSerializer().instanceOf(mapping, parameterType) + " g : g_" + id + " ) {\n";
            serializationCode = serializationCode + "writeObject( output, g, " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
            serializationCode = serializationCode + "}";
            return serializationCode;
        }
        if ("java.util.Hashtable".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String keyType = parameterType.getSerializer().instanceOf(mapping, parameterType);
                String serializationCode = "";
                serializationCode = serializationCode + "java.util.Hashtable g_" + id + " = (java.util.Hashtable) o;\n";
                serializationCode = serializationCode + "out.writeInt( g_" + id + ".size());\n";
                serializationCode = serializationCode + "for( Enumeration en = g_" + id + ".keys(); en.hasMoreElements(); ) {\n";
                serializationCode = serializationCode + keyType + " key = (" + keyType + ") en.nextElement();\n";
                serializationCode = serializationCode + "writeObject( out, key, " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
                serializationCode = serializationCode + "writeObject( out, g_" + id + ".get( key ), " + mapping.getRegistry().getRegisteredTypeId(type.getParameterTypes().get(1)) + " );\n";
                serializationCode = serializationCode + "}";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "@SuppressWarnings( \"unchecked\" )\n";
            serializationCode = serializationCode + genericsType + " g_" + id + " = (" + genericsType + ") o;\n";
            serializationCode = serializationCode + "output.writeInt( g_" + id + ".size());\n";
            serializationCode = serializationCode + "for( " + parameterType.getSerializer().instanceOf(mapping, parameterType) + " key : g_" + id + ".keySet()) {\n";
            serializationCode = serializationCode + "writeObject( output, key, " + mapping.getRegistry().getRegisteredTypeId(parameterType) + " );\n";
            serializationCode = serializationCode + "writeObject( output, g_" + id + ".get( key ), " + mapping.getRegistry().getRegisteredTypeId(type.getParameterTypes().get(1)) + " );\n";
            serializationCode = serializationCode + "}";
            return serializationCode;
        }
        return "";
    }

    @Override
    public String fromStream(JavonMapping mapping, ClassData type, String stream, String object) {
        ClassData parameterType = type.getParameterTypes().get(0);
        int id = mapping.getRegistry().getRegisteredTypeId(type);
        String genericsType = type.getSerializer().instanceOf(mapping, type);
        String classFQN = type.getFullyQualifiedName();
        if ("java.util.List".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String serializationCode = "";
                serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
                serializationCode = serializationCode + genericsType + " g_" + id + "_result = new " + parameterType.getSerializer().instanceOf(mapping, parameterType) + "[g_" + id + "_length];\n";
                serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
                serializationCode = serializationCode + "g_" + id + "_result[i] = (" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in );\n";
                serializationCode = serializationCode + "}\n";
                serializationCode = serializationCode + "result = g_" + id + "_result;";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
            serializationCode = serializationCode + genericsType + " g_" + id + "_result = new ArrayList<" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ">();\n";
            serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
            serializationCode = serializationCode + "g_" + id + "_result.add((" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in ));\n";
            serializationCode = serializationCode + "}\n";
            serializationCode = serializationCode + "result = g_" + id + "_result;";
            return serializationCode;
        }
        if ("java.util.Vector".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String serializationCode = "";
                serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
                serializationCode = serializationCode + genericsType + " g_" + id + "_result = new " + genericsType + "();\n";
                serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
                serializationCode = serializationCode + "g_" + id + "_result.addElement((" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in ));\n";
                serializationCode = serializationCode + "}\n";
                serializationCode = serializationCode + "result = g_" + id + "_result;";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
            serializationCode = serializationCode + genericsType + " g_" + id + "_result = new " + genericsType + "();\n";
            serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
            serializationCode = serializationCode + "g_" + id + "_result.addElement((" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in ));\n";
            serializationCode = serializationCode + "}\n";
            serializationCode = serializationCode + "result = g_" + id + "_result;";
            return serializationCode;
        }
        if ("java.util.Stack".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String serializationCode = "";
                serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
                serializationCode = serializationCode + genericsType + " g_" + id + "_result = new " + genericsType + "();\n";
                serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
                serializationCode = serializationCode + "g_" + id + "_result.addElement((" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in ));\n";
                serializationCode = serializationCode + "}\n";
                serializationCode = serializationCode + "result = g_" + id + "_result;";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
            serializationCode = serializationCode + genericsType + " g_" + id + "_result = new " + genericsType + "();\n";
            serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
            serializationCode = serializationCode + "g_" + id + "_result.addElement((" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in ));\n";
            serializationCode = serializationCode + "}\n";
            serializationCode = serializationCode + "result = g_" + id + "_result;";
            return serializationCode;
        }
        if ("java.util.Hashtable".equals(classFQN)) {
            if ("client".equals(mapping.getProperty("target"))) {
                String serializationCode = "";
                serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
                serializationCode = serializationCode + genericsType + " g_" + id + "_result = new " + genericsType + "();\n";
                serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
                serializationCode = serializationCode + "g_" + id + "_result.put((" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in ), (" + type.getParameterTypes().get(1).getSerializer().instanceOf(mapping, type.getParameterTypes().get(1)) + ") readObject( in ));\n";
                serializationCode = serializationCode + "}\n";
                serializationCode = serializationCode + "result = g_" + id + "_result;";
                return serializationCode;
            }
            String serializationCode = "";
            serializationCode = serializationCode + "int g_" + id + "_length = in.readInt();\n";
            serializationCode = serializationCode + genericsType + " g_" + id + "_result = new " + genericsType + "();\n";
            serializationCode = serializationCode + "for( int i = 0; i < g_" + id + "_length; i++ ) {\n";
            serializationCode = serializationCode + "g_" + id + "_result.put((" + parameterType.getSerializer().instanceOf(mapping, parameterType) + ") readObject( in ), (" + type.getParameterTypes().get(1).getSerializer().instanceOf(mapping, type.getParameterTypes().get(1)) + ") readObject( in ));\n";
            serializationCode = serializationCode + "}\n";
            serializationCode = serializationCode + "result = g_" + id + "_result;";
            return serializationCode;
        }
        throw new IllegalArgumentException("Invalid type: " + genericsType);
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData rootClassData, Set<ClassData> usedTypes) {
        HashSet<ClassData> result = new HashSet<ClassData>();
        result.add(rootClassData);
        usedTypes.add(rootClassData);
        for (ClassData cd : rootClassData.getParameterTypes()) {
            result.addAll(cd.getSerializer().getReferencedTypes(cd, usedTypes));
            usedTypes.add(cd);
        }
        return result;
    }
}

