/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.codegenerator;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mobility.e2e.mapping.Javon;
import org.netbeans.modules.mobility.e2e.mapping.JavonMappingImpl;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.codegenerator.ProxyGenerator;
import org.netbeans.modules.mobility.end2end.output.OutputLogger;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.spi.mobility.end2end.ServiceGeneratorResult;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ConnectionGenerator {
    private ConnectionGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ServiceGeneratorResult generate(E2EDataObject dataObject) {
        FileObject fo;
        Configuration config;
        SaveCookie saveCookie;
        if (dataObject.getServerProject() == null) {
            NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(E2EDataObject.class, (String)"ERR_ServerProjectNotOpened", (Object)dataObject.getConfiguration().getServerConfigutation().getProjectName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (Util.openProject(dataObject.getConfiguration().getServerConfigutation().getProjectPath()) == null) {
                return null;
            }
        }
        if ((saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        if ((config = dataObject.getConfiguration()) == null) {
            NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(E2EDataObject.class, (String)"ERR_ConfigurationFileCorrupted"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            return null;
        }
        if ("wsdlClass".equals(config.getServiceType()) && (fo = dataObject.getServerProject().getProjectDirectory().getFileObject("build/generated/wsimport/")) == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_WebProjectNotBuilt")));
            return null;
        }
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_GeneratingJavonBridge"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputLogger.getInstance().open();
            }
        });
        ph.start();
        ph.switchToIndeterminate();
        String message = NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_GeneratingProxyStubs");
        ph.progress(message);
        OutputLogger.getInstance().log(message);
        if ("wsdlClass".equals(config.getServiceType())) {
            ph.progress(NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_GeneratingProxyStubs"));
            ProxyGenerator pg = new ProxyGenerator(dataObject);
            String className = pg.generate();
            if (className == null) {
                ph.finish();
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_Failure"));
                return null;
            }
            config.getServices().get(0).getData().get(0).setProxyClassType(className);
        }
        try {
            String scanning = NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_ScanningDataStructures");
            ph.progress(scanning);
            OutputLogger.getInstance().log(scanning);
            JavonMappingImpl mapping = dataObject.getMapping();
            if ("wsdlClass".equals(config.getServiceType())) {
                mapping.setProperty("serviceType", "WSDL");
            } else {
                mapping.setProperty("serviceType", "CLASS");
            }
            String creating = NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_CreatingJavaFiles");
            ph.progress(creating);
            OutputLogger.getInstance().log(creating);
            Javon javon = new Javon(mapping);
            if (javon.generate(ph)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_SuccessGenerated"));
                OutputLogger.getInstance().log(NbBundle.getMessage(ConnectionGenerator.class, (String)"TXT_GenerationSuccess"));
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ConnectionGenerator.class, (String)"MSG_Failure"));
                OutputLogger.getInstance().log(NbBundle.getMessage(ConnectionGenerator.class, (String)"TXT_GenerationUnsuccess"));
            }
        }
        finally {
            ph.finish();
            OutputLogger.getInstance().close();
        }
        return null;
    }
}

