/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;

final class FileTokenStreamCache {
    private final List<TSData> cacheData = new CopyOnWriteArrayList<TSData>();

    public final TokenStream getTokenStreamInActiveBlock(boolean filtered, int start, int end, int firstTokenIDIfExpandMacros) {
        for (TSData pair : this.cacheData) {
            if (pair.pcState == null || !pair.pcState.isInActiveBlock(start, end)) continue;
            return pair.getTS(filtered, start, end, firstTokenIDIfExpandMacros);
        }
        return null;
    }

    public final void cacheTokens(FilePreprocessorConditionState pcState, List<APTToken> tokens, APTLanguageFilter lang) {
        TSData newData = new TSData(pcState, tokens, lang);
        this.cacheData.add(newData);
    }

    public final TokenStream cacheTokensAndReturnFiltered(FilePreprocessorConditionState pcState, List<APTToken> tokens, APTLanguageFilter lang) {
        TSData newData = new TSData(pcState, tokens, lang);
        this.cacheData.add(newData);
        return newData.getTS(true, 0, Integer.MAX_VALUE, 0);
    }

    private static final class IteratorBasedTS
    implements TokenStream,
    APTTokenStream {
        private final ListIterator<APTToken> position;
        private final List<APTToken> debugTokens;
        private final int debugStartIndex;
        private final int endOffset;
        private final TSData callback;

        public IteratorBasedTS(List<APTToken> tokens, int startIndex, int endOffset, TSData callback) {
            this.position = tokens.listIterator(startIndex);
            this.debugTokens = tokens;
            this.debugStartIndex = startIndex;
            this.endOffset = endOffset;
            this.callback = callback;
        }

        public APTToken nextToken() {
            if (this.position.hasNext()) {
                APTToken out = this.position.next();
                assert (out != null);
                assert (!APTUtils.isEOF((Token)out));
                int offset = out.getOffset();
                if (offset > this.endOffset) {
                    out = APTUtils.EOF_TOKEN;
                    if (this.callback != null) {
                        this.callback.rememberIndex(offset, this.position.previousIndex());
                    }
                }
                return out;
            }
            return APTUtils.EOF_TOKEN;
        }

        public String toString() {
            return APTUtils.debugString((TokenStream)new IteratorBasedTS(this.debugTokens, this.debugStartIndex, this.endOffset, null)).toString();
        }
    }

    private static final class TSData {
        private final FilePreprocessorConditionState pcState;
        private final List<APTToken> tokens;
        private final APTLanguageFilter lang;
        private final TreeMap<Integer, Integer> knownIndices = new TreeMap();

        private TSData(FilePreprocessorConditionState pcState, List<APTToken> tokens, APTLanguageFilter lang) {
            this.pcState = pcState;
            this.tokens = tokens;
            this.lang = lang;
            this.rememberIndex(0, 0);
        }

        private TokenStream getTS(boolean filtered, int start, int endOffset, int firstTokenIDIfExpandMacros) {
            int iteratorIndex = this.checkKnownIndex(start);
            ListIterator<APTToken> iterator = this.tokens.listIterator(iteratorIndex);
            while (iterator.hasNext()) {
                APTToken next = iterator.next();
                int currOffset = next.getOffset();
                if (currOffset < start || firstTokenIDIfExpandMacros != 0 && next.getType() != firstTokenIDIfExpandMacros && APTUtils.isMacroExpandedToken((Token)next)) continue;
                iterator.previous();
                break;
            }
            IteratorBasedTS ts = new IteratorBasedTS(this.tokens, iterator.nextIndex(), endOffset, this);
            this.rememberIndex(start, iterator.nextIndex());
            return filtered ? this.lang.getFilteredStream((TokenStream)new APTCommentsFilter((TokenStream)ts)) : ts;
        }

        private synchronized void rememberIndex(int startOffset, int listIndex) {
            this.knownIndices.put(startOffset, listIndex);
        }

        private synchronized int checkKnownIndex(int startOffset) {
            SortedMap<Integer, Integer> tailMap = this.knownIndices.tailMap(startOffset);
            Integer knownOffset = tailMap.isEmpty() || tailMap.firstKey() > startOffset ? this.knownIndices.headMap(startOffset).lastKey() : tailMap.firstKey();
            return this.knownIndices.get(knownOffset);
        }
    }
}

