/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmModelStateListener;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.util.WeakList;
import org.openide.util.Lookup;

public class ListenersImpl
extends CsmListeners {
    private final WeakList<CsmModelListener> modelListeners = new WeakList();
    private final WeakList<CsmModelStateListener> modelStateListeners = new WeakList();

    public void addModelListener(CsmModelListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeModelListener(CsmModelListener listener) {
        this.modelListeners.remove(listener);
    }

    public void addProgressListener(CsmProgressListener listener) {
        ProgressSupport.instance().addProgressListener(listener);
    }

    public void removeProgressListener(CsmProgressListener listener) {
        ProgressSupport.instance().removeProgressListener(listener);
    }

    public void addModelStateListener(CsmModelStateListener listener) {
        this.modelStateListeners.add(listener);
    }

    public void removeModelStateListener(CsmModelStateListener listener) {
        this.modelStateListeners.remove(listener);
    }

    static ListenersImpl getImpl() {
        return (ListenersImpl)CsmListeners.getDefault();
    }

    private Iterable<? extends CsmModelListener> getModelListeners() {
        Collection services = Lookup.getDefault().lookupAll(CsmModelListener.class);
        return services.isEmpty() ? this.modelListeners : this.modelListeners.join(services);
    }

    private Iterable<? extends CsmModelStateListener> getModelStateListeners() {
        Collection services = Lookup.getDefault().lookupAll(CsmModelStateListener.class);
        return services.isEmpty() ? this.modelStateListeners : this.modelStateListeners.join(services);
    }

    void fireProjectOpened(ProjectBase csmProject) {
        csmProject.onAddedToModel();
        for (CsmModelListener csmModelListener : this.getModelListeners()) {
            try {
                csmModelListener.projectOpened((CsmProject)csmProject);
            }
            catch (AssertionError ex) {
                DiagnosticExceptoins.register((Throwable)((Object)ex));
            }
            catch (Exception ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
    }

    void fireProjectClosed(CsmProject csmProject) {
        for (CsmModelListener csmModelListener : this.getModelListeners()) {
            try {
                csmModelListener.projectClosed(csmProject);
            }
            catch (AssertionError ex) {
                DiagnosticExceptoins.register((Throwable)((Object)ex));
            }
            catch (Exception ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
    }

    void fireModelChanged(CsmChangeEvent e) {
        for (CsmModelListener csmModelListener : this.getModelListeners()) {
            try {
                csmModelListener.modelChanged(e);
            }
            catch (AssertionError ex) {
                DiagnosticExceptoins.register((Throwable)((Object)ex));
            }
            catch (Exception ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
    }

    void fireModelStateChanged(CsmModelState newState, CsmModelState oldState) {
        for (CsmModelStateListener csmModelStateListener : this.getModelStateListeners()) {
            try {
                csmModelStateListener.modelStateChanged(newState, oldState);
            }
            catch (AssertionError ex) {
                DiagnosticExceptoins.register((Throwable)((Object)ex));
            }
            catch (Exception ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
    }
}

