/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.FileBufferSnapshot2;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public abstract class ProjectBaseWithEditing
extends ProjectBase {
    private final Map<CsmFile, EditingTask> editedFiles = new HashMap<CsmFile, EditingTask>();
    private final ConcurrentHashMap<CsmFile, Boolean> modifiedFiles = new ConcurrentHashMap();
    private static final RequestProcessor RP = new RequestProcessor("ProjectImpl RP", 50);

    protected ProjectBaseWithEditing(ModelImpl model, FileSystem fs, Object platformProject, CharSequence name, Key key) {
        super(model, fs, platformProject, name, key);
    }

    public ProjectBaseWithEditing(RepositoryDataInput input) throws IOException {
        super(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onFileEditStart(FileBuffer buf, NativeFileItem nativeFile) {
        FileImpl impl;
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditSTART " + buf.getUrl());
        }
        if ((impl = this.getFile(buf.getAbsolutePath(), false)) != null) {
            APTDriver.invalidateAPT((APTFileBuffer)buf);
            ClankDriver.invalidate((APTFileBuffer)buf);
            APTFileCacheManager.getInstance((FileSystem)buf.getFileSystem()).invalidate(buf.getAbsolutePath());
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ProjectBaseWithEditing.this.scheduleParseOnEditing(impl);
                }
            };
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("onFileEditStart: edited file " + csmFile);
                    }
                    System.err.println("onFileEditStart: current file " + impl);
                }
                impl.setBuffer(buf);
                if (!this.editedFiles.containsKey(impl)) {
                    this.editedFiles.put(impl, new EditingTask(buf, changeListener));
                }
                this.scheduleParseOnEditing(impl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onFileEditEnd(FileBuffer buf, NativeFileItem nativeFile, boolean undo) {
        FileImpl file;
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditEND " + buf.getUrl());
        }
        if ((file = this.getFile(buf.getAbsolutePath(), false)) != null) {
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                EditingTask task;
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("onFileEditEnd: edited file " + csmFile);
                    }
                    System.err.println("onFileEditEnd: " + (undo ? "undo" : "save") + " current file " + file);
                }
                if ((task = this.editedFiles.remove(file)) == null) {
                    return;
                }
                task.cancelTask();
                file.setBuffer(buf);
            }
            if (undo) {
                DeepReparsingUtils.reparseOnUndoEditedFile(this, file);
            }
        }
    }

    @Override
    protected final void addModifiedFile(FileImpl file) {
        if (!this.isDisposing()) {
            this.modifiedFiles.put(file, Boolean.TRUE);
        }
    }

    @Override
    protected final void removeModifiedFile(FileImpl file) {
        this.modifiedFiles.remove(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onFileImplRemoved(Collection<FileImpl> physicallyRemoved, Collection<FileImpl> excluded) {
        try {
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                if (!this.editedFiles.isEmpty()) {
                    HashSet<FileImpl> files = new HashSet<FileImpl>(physicallyRemoved);
                    files.addAll(excluded);
                    for (FileImpl impl : files) {
                        EditingTask task = this.editedFiles.remove(impl);
                        if (task == null) continue;
                        task.cancelTask();
                    }
                }
            }
        }
        finally {
            super.onFileImplRemoved(physicallyRemoved, excluded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void ensureChangedFilesEnqueued() {
        HashSet<FileImpl> addToParse = new HashSet<FileImpl>();
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            super.ensureChangedFilesEnqueued();
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (fileImpl.isParsingOrParsed()) continue;
                addToParse.add(fileImpl);
            }
            for (FileImpl fileImpl : this.modifiedFiles.keySet()) {
                if (fileImpl.isParsingOrParsed()) continue;
                if (WAIT_PARSE_LOGGER.isLoggable(Level.FINE)) {
                    WAIT_PARSE_LOGGER.fine("### Added modified file " + fileImpl);
                }
                addToParse.add(fileImpl);
            }
        }
        for (FileImpl file : addToParse) {
            ParserQueue.instance().add(file, this.getPreprocHandlersForParse(file, Interrupter.DUMMY), ParserQueue.Position.TAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean hasChangedFiles(CsmFile skipFile) {
        if (skipFile == null) {
            return false;
        }
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (skipFile == fileImpl || fileImpl.isParsingOrParsed()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean hasEditedFiles() {
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            return !this.editedFiles.isEmpty();
        }
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.editedFiles.clear();
        this.modifiedFiles.clear();
    }

    @Override
    public final void onSnapshotChanged(FileImpl file, Snapshot snapshot) {
        FileBufferSnapshot2 fb = new FileBufferSnapshot2(snapshot, System.currentTimeMillis());
        file.setBuffer(fb);
        DeepReparsingUtils.reparseOnEditingFile(this, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisposed() {
        super.setDisposed();
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (EditingTask task : this.editedFiles.values()) {
                task.cancelTask();
            }
            this.editedFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleParseOnEditing(final FileImpl file) {
        int delay;
        RequestProcessor.Task task;
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            EditingTask pair;
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                new Exception("scheduleParseOnEditing " + file).printStackTrace(System.err);
            }
            if ((pair = this.editedFiles.get(file)) == null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.println("scheduleParseOnEditing: file was removed " + file);
                }
                return;
            }
            if (!pair.updateLastModified()) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.println("scheduleParseOnEditing: no updates " + file + " : " + pair.lastModified);
                }
                return;
            }
            file.markReparseNeeded(false);
            task = pair.getTask();
            if (task == null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("scheduleParseOnEditing: edited file " + csmFile);
                    }
                    System.err.println("scheduleParseOnEditing: current file " + file);
                }
                task = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                                System.err.printf("scheduleParseOnEditing: RUN scheduleParseOnEditing task for %s%n", file);
                            }
                            if (ProjectBaseWithEditing.this.isDisposing()) {
                                return;
                            }
                            DeepReparsingUtils.reparseOnEditingFile(ProjectBaseWithEditing.this, file);
                        }
                        catch (AssertionError ex) {
                            DiagnosticExceptoins.register((Throwable)((Object)ex));
                        }
                        catch (Exception ex) {
                            DiagnosticExceptoins.register(ex);
                        }
                    }
                }, true);
                task.setPriority(1);
                pair.setTask(task);
            } else if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                for (CsmFile csmFile : this.editedFiles.keySet()) {
                    System.err.println("reschedule in scheduleParseOnEditing: edited file " + csmFile);
                }
                System.err.println("reschedule in scheduleParseOnEditing: current file " + file);
            }
            delay = TraceFlags.REPARSE_DELAY;
            if (TraceFlags.REPARSE_ON_DOCUMENT_CHANGED) {
                if (file.getLastParseTime() / (delay + 1) > 2) {
                    delay = Math.max(delay, file.getLastParseTime() + 2000);
                }
            } else {
                delay = Integer.MAX_VALUE;
            }
        }
        if (task.getDelay() < Math.max(100, delay - 100)) {
            task.schedule(delay);
        }
    }

    private static final class EditingTask {
        private RequestProcessor.Task task;
        private final ChangeListener bufListener;
        private final FileBuffer buf;
        private long lastModified = -1L;

        public EditingTask(FileBuffer buf, ChangeListener bufListener) {
            assert (bufListener != null);
            this.bufListener = bufListener;
            assert (buf != null);
            this.buf = buf;
            this.buf.addChangeListener(bufListener);
        }

        public boolean updateLastModified() {
            long lm = this.buf.lastModified();
            if (this.lastModified == lm) {
                return false;
            }
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("EditingTask.updateLastModified: set lastModified from %d to %d%n", this.lastModified, lm);
            }
            this.lastModified = lm;
            return true;
        }

        public void setTask(RequestProcessor.Task task) {
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("EditingTask.setTask: set new EditingTask %d for %s%n", task.hashCode(), this.buf.getUrl());
            }
            this.task = task;
        }

        public void cancelTask() {
            if (this.task != null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    if (!this.task.isFinished()) {
                        new Exception("EditingTask.cancelTask: cancelling previous EditingTask " + this.task.hashCode()).printStackTrace(System.err);
                    } else {
                        new Exception("EditingTask.cancelTask: cancelTask where EditingTask was finished " + this.task.hashCode()).printStackTrace(System.err);
                    }
                }
                try {
                    this.task.cancel();
                }
                catch (Throwable ex) {
                    System.err.println("EditingTask.cancelTask: cancelled with exception:");
                    ex.printStackTrace(System.err);
                }
            }
            this.buf.removeChangeListener(this.bufListener);
        }

        private RequestProcessor.Task getTask() {
            return this.task;
        }
    }
}

