/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.CndIndexer;
import org.netbeans.modules.cnd.modelimpl.platform.CsmEvent;
import org.netbeans.modules.cnd.modelimpl.platform.CsmEventListener;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public final class CsmEventDispatcher {
    private static final CsmEventDispatcher instance = new CsmEventDispatcher();
    private final FileListener fileListener;
    private final ItemListener itemListener;
    private final CndIndexer.Delegate indexListener;
    private final Object listenersLock = new Object();
    private final HashMap<NativeProject, CsmEventListener> listeners = new HashMap();
    private final RequestProcessor RP = new RequestProcessor(this.getClass().getSimpleName(), 1);
    private final RequestProcessor.Task task = this.RP.create((Runnable)new Worker());
    private final Object eventsLock = new Object();
    private LinkedList<CsmEvent> eventsQueue = new LinkedList();

    public static CsmEventDispatcher getInstance() {
        return instance;
    }

    private CsmEventDispatcher() {
        this.itemListener = new ItemListener();
        boolean listenOnlyRemoteFiles = CndTraceFlags.USE_INDEXING_API;
        this.fileListener = new FileListener(listenOnlyRemoteFiles);
        this.indexListener = new IndexListener();
    }

    void startup() {
        if (CndTraceFlags.USE_INDEXING_API) {
            CndIndexer.setDelegate(this.indexListener);
        }
        CndFileSystemProvider.addFileChangeListener((FileChangeListener)this.fileListener);
    }

    void shutdown() {
        if (CndTraceFlags.USE_INDEXING_API) {
            CndFileSystemProvider.removeFileChangeListener((FileChangeListener)this.fileListener);
        } else {
            CndIndexer.setDelegate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProject(ProjectBase project) {
        Object pp = project.getPlatformProject();
        if (pp instanceof NativeProject) {
            NativeProject nativeProject = (NativeProject)pp;
            Object object = this.listenersLock;
            synchronized (object) {
                CndUtils.assertNull((Object)this.listeners.get(nativeProject), (String)("Listener already exist for " + nativeProject));
                CsmEventListener listener = new CsmEventListener(project);
                this.listeners.put(nativeProject, listener);
                nativeProject.addProjectItemsListener((NativeProjectItemsListener)this.itemListener);
            }
        } else {
            CndUtils.assertTrue((boolean)false, (String)("platform ptoject should be NativeProject, but is " + pp + " for " + project));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProject(ProjectBase project) {
        Object pp = project.getPlatformProject();
        if (pp instanceof NativeProject) {
            NativeProject nativeProject = (NativeProject)pp;
            Object object = this.listenersLock;
            synchronized (object) {
                nativeProject.removeProjectItemsListener((NativeProjectItemsListener)this.itemListener);
                this.listeners.remove(nativeProject);
            }
        } else {
            CndUtils.assertTrue((boolean)false, (String)("platform ptoject should be NativeProject, but is " + pp + " for " + project));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableListening(ProjectBase project, boolean enable) {
        Object pp = project.getPlatformProject();
        if (pp instanceof NativeProject) {
            Object object = this.listenersLock;
            synchronized (object) {
                CsmEventListener listener = this.listeners.get((NativeProject)pp);
                if (listener != null) {
                    listener.enableListening(enable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEvent(CsmEvent.Kind kind, FileObject fileObject) {
        Object object = this.eventsLock;
        synchronized (object) {
            this.eventsQueue.addLast(CsmEvent.createFileEvent(kind, fileObject));
        }
        this.task.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEvents(CsmEvent ... events) {
        Object object = this.eventsLock;
        synchronized (object) {
            for (CsmEvent e : events) {
                this.eventsQueue.addLast(e);
            }
        }
        this.task.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEvents(CsmEvent.Kind kind, List<NativeFileItem> items) {
        Object object = this.eventsLock;
        synchronized (object) {
            for (NativeFileItem item : items) {
                this.eventsQueue.addLast(CsmEvent.createItemEvent(kind, item));
            }
        }
        this.task.schedule(0);
    }

    private void processEvent(CsmEvent event) {
        ModelImpl model = ModelSupport.instance().getModel();
        if (model == null) {
            return;
        }
        CsmEvent.trace("dispatching %s", event);
        switch (event.getKind()) {
            case ITEM_ADDED: 
            case ITEM_REMOVED: 
            case ITEM_PROPERTY_CHANGED: 
            case ITEM_RENAMED_DELETED: 
            case ITEM_RENAMED_CREATED: {
                NativeFileItem item = event.getNativeFileItem();
                CndUtils.assertNotNullInConsole((Object)item, (String)("NativeFileItem should not be null: " + event));
                if (item == null) break;
                this.dispatch(event, item.getNativeProject());
                break;
            }
            case FILE_DELETED: 
            case FILE_CREATED: 
            case FILE_RENAMED_CREATED: 
            case FILE_RENAMED_DELETED: 
            case FILE_CHANGED: 
            case FILE_INDEXED: {
                FileObject fo = event.getFileObject();
                CndUtils.assertNotNullInConsole((Object)fo, (String)("FileObject should not be null: " + event));
                if (fo == null) break;
                CsmFile[] files = model.findFiles(FSPath.toFSPath((FileObject)fo), false, false);
                HashSet<ProjectBase> handledProjects = new HashSet<ProjectBase>();
                for (int i = 0; i < files.length; ++i) {
                    FileImpl file = (FileImpl)files[i];
                    ProjectBase project = file.getProjectImpl(true);
                    if (project == null) continue;
                    handledProjects.add(project);
                    CsmEvent.Kind kind = event.getKind() == CsmEvent.Kind.FILE_INDEXED ? CsmEvent.Kind.FILE_CHANGED : event.getKind();
                    this.dispatch(CsmEvent.createFileEvent(kind, fo), project);
                }
                if (event.getKind() != CsmEvent.Kind.FILE_CREATED && event.getKind() != CsmEvent.Kind.FILE_INDEXED) break;
                Collection ownerCsmProjects = CsmUtilities.getOwnerCsmProjects((FileObject)fo);
                for (CsmProject prj : ownerCsmProjects) {
                    ProjectBase project;
                    if (!(prj instanceof ProjectBase) || handledProjects.contains(project = (ProjectBase)prj)) continue;
                    this.dispatch(event.getKind() == CsmEvent.Kind.FILE_INDEXED ? CsmEvent.createFileEvent(CsmEvent.Kind.FILE_CREATED, fo) : event, project);
                }
                break;
            }
            case ITEMS_ALL_PROPERTY_CHANGED: {
                CndUtils.assertNotNullInConsole((Object)event.getNativeProject(), (String)("NativeProject should not be null: " + event));
                this.dispatch(event, event.getNativeProject());
                break;
            }
            case PROJECT_DELETED: {
                NativeProject nativeProject = event.getNativeProject();
                CndUtils.assertNotNullInConsole((Object)nativeProject, (String)("NativeProject should not be null: " + event));
                if (nativeProject == null) break;
                this.dispatch(event, nativeProject);
                break;
            }
            case FILES_IN_SOURCE_ROOT_DELETED: {
                FileObject fo = event.getFileObject();
                CndUtils.assertNotNullInConsole((Object)fo, (String)("FileObject should not be null: " + event));
                if (fo == null) break;
                Collection projects = CsmUtilities.getOwnerCsmProjects((FileObject)fo);
                for (CsmProject project : projects) {
                    this.dispatch(event, project);
                }
                break;
            }
            case FOLDER_CREATED: 
            case FILE_ATTRIBUTE_CHANGED: 
            case NULL: {
                break;
            }
            default: {
                throw new AssertionError((Object)event.getKind().name());
            }
        }
    }

    private void dispatch(CsmEvent event, CsmProject project) {
        CsmEventListener listener = this.getListener(project);
        if (listener != null) {
            listener.fireEvent(event);
        } else {
            CsmEvent.LOG.log(Level.FINEST, "Skipping event {0}", event);
        }
    }

    private void dispatch(CsmEvent event, NativeProject project) {
        CsmEventListener listener = this.getListener(project);
        if (listener != null) {
            listener.fireEvent(event);
        } else {
            CsmEvent.LOG.log(Level.FINEST, "Skipping event {0}", event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmEventListener getListener(CsmProject project) {
        Object pp = project.getPlatformProject();
        if (pp instanceof NativeProject) {
            Object object = this.listenersLock;
            synchronized (object) {
                return this.listeners.get((NativeProject)pp);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmEventListener getListener(NativeProject project) {
        if (project != null) {
            Object object = this.listenersLock;
            synchronized (object) {
                return this.listeners.get(project);
            }
        }
        return null;
    }

    private boolean isCOrCpp(FileObject fo) {
        String mime = fo.getMIMEType();
        if (mime == null) {
            mime = FileUtil.getMIMEType((FileObject)fo);
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                CsmEvent.LOG.log(Level.INFO, "External updates: MIME resolved: {0}", mime);
            }
        }
        return MIMENames.isFortranOrHeaderOrCppOrC((String)mime);
    }

    private boolean isCOrCppOrInvalid(FileObject fo) {
        return !fo.isValid() || this.isCOrCpp(fo);
    }

    private class IndexListener
    implements CndIndexer.Delegate {
        private IndexListener() {
        }

        @Override
        public void index(FileObject file) {
            CsmEventDispatcher.this.registerEvent(CsmEvent.Kind.FILE_INDEXED, file);
        }

        @Override
        public void removed(FileObject root) {
            CsmEventDispatcher.this.registerEvent(CsmEvent.Kind.FILES_IN_SOURCE_ROOT_DELETED, root);
        }
    }

    private class FileListener
    implements FileChangeListener {
        private final boolean remoteOnly;

        public FileListener(boolean remoteOnly) {
            this.remoteOnly = remoteOnly;
        }

        private boolean accept(FileEvent fe) {
            FileObject fo;
            if (this.remoteOnly && (fo = fe.getFile()) != null) {
                return CndFileUtils.isRemoteFileSystem((FileObject)fo);
            }
            return true;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            if (this.accept(fe) && CsmEventDispatcher.this.isCOrCppOrInvalid(fe.getFile())) {
                CsmEventDispatcher.this.registerEvent(CsmEvent.Kind.FILE_CREATED, fe.getFile());
            }
        }

        public void fileChanged(FileEvent fe) {
            if (this.accept(fe) && CsmEventDispatcher.this.isCOrCppOrInvalid(fe.getFile())) {
                CsmEventDispatcher.this.registerEvent(CsmEvent.Kind.FILE_CHANGED, fe.getFile());
            }
        }

        public void fileDeleted(FileEvent fe) {
            if (this.accept(fe) && CsmEventDispatcher.this.isCOrCppOrInvalid(fe.getFile())) {
                CsmEventDispatcher.this.registerEvent(CsmEvent.Kind.FILE_DELETED, fe.getFile());
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            FileObject fo;
            if (this.accept((FileEvent)fe) && CsmEventDispatcher.this.isCOrCppOrInvalid(fo = fe.getFile())) {
                FSPath newPath = FSPath.toFSPath((FileObject)fo);
                String strPrevExt = fe.getExt() == null || fe.getExt().isEmpty() ? "" : "." + fe.getExt();
                String strPrevPath = CndPathUtilities.getDirName((String)newPath.getPath()) + '/' + fe.getName() + strPrevExt;
                FSPath prevPath = new FSPath(newPath.getFileSystem(), strPrevPath);
                FileObject removedFO = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)prevPath.getFileSystem(), (CharSequence)prevPath.getPath());
                CsmEventDispatcher.this.registerEvents(new CsmEvent[]{CsmEvent.createFileEvent(CsmEvent.Kind.FILE_RENAMED_DELETED, removedFO), CsmEvent.createFileEvent(CsmEvent.Kind.FILE_RENAMED_CREATED, fo)});
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private class ItemListener
    implements NativeProjectItemsListener {
        private ItemListener() {
        }

        public void filesAdded(List<NativeFileItem> items) {
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : items) {
                if (item.isExcluded()) continue;
                list.add(item);
            }
            if (!list.isEmpty()) {
                CsmEventDispatcher.this.registerEvents(CsmEvent.Kind.ITEM_ADDED, list);
            }
        }

        public void filesRemoved(List<NativeFileItem> items) {
            CsmEventDispatcher.this.registerEvents(CsmEvent.Kind.ITEM_REMOVED, items);
        }

        public void filesPropertiesChanged(List<NativeFileItem> items) {
            CsmEventDispatcher.this.registerEvents(CsmEvent.Kind.ITEM_PROPERTY_CHANGED, items);
        }

        public void filesPropertiesChanged(NativeProject nativeProject) {
            CsmEventDispatcher.this.registerEvents(new CsmEvent[]{CsmEvent.createProjectEvent(CsmEvent.Kind.ITEMS_ALL_PROPERTY_CHANGED, nativeProject)});
        }

        public void fileRenamed(String oldPath, NativeFileItem newFileIetm) {
            CsmEventDispatcher.this.registerEvents(new CsmEvent[]{CsmEvent.createItemEvent(CsmEvent.Kind.ITEM_RENAMED_DELETED, newFileIetm, oldPath), CsmEvent.createItemEvent(CsmEvent.Kind.ITEM_RENAMED_CREATED, newFileIetm, oldPath)});
        }

        public void projectDeleted(NativeProject nativeProject) {
            CsmEventDispatcher.this.registerEvents(new CsmEvent[]{CsmEvent.createProjectEvent(CsmEvent.Kind.PROJECT_DELETED, nativeProject)});
        }

        public void fileOperationsStarted(NativeProject nativeProject) {
            CsmEventListener listener = CsmEventDispatcher.this.getListener(nativeProject);
            if (listener != null) {
                listener.suspend();
            }
        }

        public void fileOperationsFinished(NativeProject nativeProject) {
            CsmEventListener listener = CsmEventDispatcher.this.getListener(nativeProject);
            if (listener != null) {
                listener.resume();
            }
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block3: while (true) {
                LinkedList curEvents;
                Iterator iterator = CsmEventDispatcher.this.eventsLock;
                synchronized (iterator) {
                    if (CsmEventDispatcher.this.eventsQueue.isEmpty()) {
                        return;
                    }
                    curEvents = CsmEventDispatcher.this.eventsQueue;
                    CsmEventDispatcher.this.eventsQueue = new LinkedList();
                }
                iterator = curEvents.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    CsmEvent event = (CsmEvent)iterator.next();
                    CsmEventDispatcher.this.processEvent(event);
                }
                break;
            }
        }
    }
}

