/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;

public class OffsetToPositionFrame
extends JFrame {
    private final FileImpl file;
    private final JTextField inputField = new JTextField(10);
    private final JLabel outputField = new JLabel();

    public OffsetToPositionFrame(FileImpl file) {
        this.file = file;
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JSplitPane splitter = new JSplitPane(0);
        splitter.setDividerSize(2);
        splitter.setResizeWeight(0.4);
        splitter.setTopComponent(this.inputField);
        splitter.setBottomComponent(this.outputField);
        content.add((Component)splitter, "Center");
        this.inputField.setMaximumSize(this.inputField.getPreferredSize());
        this.inputField.setHorizontalAlignment(0);
        this.outputField.setHorizontalAlignment(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame f = (Frame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        this.setListeners();
        this.setSize(200, 100);
    }

    private void setListeners() {
        this.inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OffsetToPositionFrame.this.convertOffset();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OffsetToPositionFrame.this.convertOffset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OffsetToPositionFrame.this.convertOffset();
            }
        });
    }

    private void convertOffset() {
        String text = this.inputField.getText();
        if (text != null && !text.isEmpty()) {
            try {
                int offset = Integer.parseInt(text);
                int[] lineColumn = this.file.getLineColumn(offset);
                this.outputField.setText("" + lineColumn[0] + ":" + lineColumn[1]);
            }
            catch (NumberFormatException ex) {
                this.outputField.setText("Not a number!");
            }
        } else {
            this.outputField.setText("");
        }
    }
}

