/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

public final class SourceGroups {
    private static final Logger LOGGER = Logger.getLogger(SourceGroups.class.getName());

    private SourceGroups() {
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> testGroups = SourceGroups.getTestSourceGroups(sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroups) {
            if (testGroups.contains(sourceGroup)) continue;
            result.add(sourceGroup);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    public static boolean isFolderWritable(SourceGroup sourceGroup, String packageName) {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"packageName", (Object)packageName);
        try {
            FileObject fo = SourceGroups.getFolderForPackage(sourceGroup, packageName, false);
            while (fo == null && packageName.lastIndexOf(46) != -1) {
                packageName = packageName.substring(0, packageName.lastIndexOf(46));
                fo = SourceGroups.getFolderForPackage(sourceGroup, packageName, false);
            }
            return fo == null ? sourceGroup.getRootFolder().canWrite() : fo.canWrite();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return false;
        }
    }

    public static SourceGroup getFolderSourceGroup(SourceGroup[] sourceGroups, FileObject folder) {
        Parameters.notNull((CharSequence)"sourceGroups", (Object)sourceGroups);
        Parameters.notNull((CharSequence)"folder", (Object)folder);
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroups[i].getRootFolder(), (FileObject)folder)) continue;
            return sourceGroups[i];
        }
        return null;
    }

    public static String getPackageForFolder(SourceGroup sourceGroup, FileObject folder) {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"folder", (Object)folder);
        String relative = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)folder);
        if (relative == null) {
            throw new IllegalStateException("The given folder [ " + folder.getPath() + "] is not in the " + "same tree with [" + sourceGroup.getRootFolder().getPath() + "]");
        }
        return relative.replace('/', '.');
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String packageName) throws IOException {
        return SourceGroups.getFolderForPackage(sourceGroup, packageName, true);
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String packageName, boolean create) throws IOException {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"packageName", (Object)packageName);
        String relativePkgName = packageName.replace('.', '/');
        FileObject folder = sourceGroup.getRootFolder().getFileObject(relativePkgName);
        if (folder != null) {
            return folder;
        }
        if (create) {
            return FileUtil.createFolder((FileObject)sourceGroup.getRootFolder(), (String)relativePkgName);
        }
        return null;
    }

    public static SourceGroup getClassSourceGroup(Project project, String fqClassName) {
        SourceGroup[] sourceGroups;
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notEmpty((CharSequence)"fqClassName", (CharSequence)fqClassName);
        String classFile = fqClassName.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject classFO = sourceGroup.getRootFolder().getFileObject(classFile);
            if (classFO == null) continue;
            return sourceGroup;
        }
        return null;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        HashMap<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.EMPTY_MAP;
        } else {
            result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length, 0.5f);
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup sourceGroup = sourceGroups[i];
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return new ArrayList<SourceGroup>();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List<FileObject> sourceRoots = SourceGroups.getFileObjects(rootURLs);
        for (int i = 0; i < sourceRoots.size(); ++i) {
            FileObject sourceRoot = sourceRoots.get(i);
            SourceGroup srcGroup = (SourceGroup)foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    private static List<FileObject> getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot == null) continue;
            result.add(sourceRoot);
        }
        return result;
    }

    private static Set<SourceGroup> getTestSourceGroups(SourceGroup[] sourceGroups) {
        Map foldersToSourceGroupsMap = SourceGroups.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet<SourceGroup> testGroups = new HashSet<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            testGroups.addAll(SourceGroups.getTestTargets(sourceGroups[i], foldersToSourceGroupsMap));
        }
        return testGroups;
    }
}

