/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.TokenId;

public final class Filter<T extends TokenId> {
    private final Map<CharSequence, T> filter = new HashMap<CharSequence, T>();
    private final Map<CharSequence, T> prefixFilter = new HashMap<CharSequence, T>();

    Filter() {
    }

    public final T check(CharSequence text) {
        TokenId out = (TokenId)this.filter.get(text);
        if (out == null && !this.prefixFilter.isEmpty()) {
            int bestPrefixLen = 0;
            for (Map.Entry<CharSequence, T> entry : this.prefixFilter.entrySet()) {
                CharSequence prefix = entry.getKey();
                int length = prefix.length();
                if (bestPrefixLen >= length || length > text.length()) continue;
                bestPrefixLen = length;
                for (int i = 0; i < length; ++i) {
                    if (prefix.charAt(i) == text.charAt(i)) continue;
                    return null;
                }
                out = (TokenId)entry.getValue();
            }
        }
        return (T)out;
    }

    final void addPrefixedMatch(CharSequence prefix, T id) {
        assert (prefix.length() > 0);
        this.prefixFilter.put(prefix, id);
    }

    final void addMatch(CharSequence text, T id) {
        this.filter.put(text, id);
    }

    public static <T extends TokenId> Filter<T> create(Map<CharSequence, T> matchTable) {
        Filter<TokenId> out = new Filter<TokenId>();
        for (Map.Entry<CharSequence, T> entry : matchTable.entrySet()) {
            out.addMatch(entry.getKey(), (TokenId)entry.getValue());
        }
        return out;
    }
}

