/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.task;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.service.PoolTcpConnector;
import org.apache.tomcat.service.connector.Ajp12ConnectionHandler;
import org.apache.tomcat.util.FileUtil;

public class ApacheConfig {
    public static final String APACHE_CONFIG = "/conf/tomcat-apache.conf";
    public static final String MOD_JK_CONFIG = "/conf/mod_jk.conf";
    public static final String WORKERS_CONFIG = "/conf/workers.properties";
    public static final String JK_LOG_LOCATION = "/logs/mod_jk.log";

    public void execute(ContextManager cm) throws TomcatException {
        try {
            String tomcatHome = cm.getHome();
            String apacheHome = this.findApache();
            FileWriter configW = new FileWriter(String.valueOf(tomcatHome) + APACHE_CONFIG);
            PrintWriter pw = new PrintWriter(configW);
            PrintWriter mod_jk = new PrintWriter(new FileWriter(String.valueOf(tomcatHome) + MOD_JK_CONFIG + "-auto"));
            mod_jk.println("###################################################################");
            mod_jk.println("# Auto generated configuration. Dated: " + new Date());
            mod_jk.println("###################################################################");
            mod_jk.println();
            mod_jk.println("#");
            mod_jk.println("# The following line instructs Apache to load the jk module");
            mod_jk.println("#");
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                pw.println("LoadModule jserv_module modules/ApacheModuleJServ.dll");
                mod_jk.println("LoadModule jk_module modules/mod_jk.dll");
                mod_jk.println();
                mod_jk.println("JkWorkersFile \"" + new File(tomcatHome, WORKERS_CONFIG).toString().replace('\\', '/') + "\"");
                mod_jk.println("JkLogFile \"" + new File(tomcatHome, JK_LOG_LOCATION).toString().replace('\\', '/') + "\"");
            } else {
                pw.println("LoadModule jserv_module libexec/mod_jserv.so");
                mod_jk.println("LoadModule jk_module libexec/mod_jk.so");
                mod_jk.println();
                mod_jk.println("JkWorkersFile " + new File(tomcatHome, WORKERS_CONFIG));
                mod_jk.println("JkLogFile " + new File(tomcatHome, JK_LOG_LOCATION));
            }
            pw.println("ApJServManual on");
            pw.println("ApJServDefaultProtocol ajpv12");
            pw.println("ApJServSecretKey DISABLED");
            pw.println("ApJServMountCopy on");
            pw.println("ApJServLogLevel notice");
            pw.println();
            int portInt = 8007;
            Enumeration enumeration = cm.getConnectors();
            while (enumeration.hasMoreElements()) {
                PoolTcpConnector tcpCon;
                Object con = enumeration.nextElement();
                if (!(con instanceof PoolTcpConnector) || !((tcpCon = (PoolTcpConnector)con).getTcpConnectionHandler() instanceof Ajp12ConnectionHandler)) continue;
                portInt = tcpCon.getPort();
            }
            pw.println("ApJServDefaultPort " + portInt);
            pw.println();
            pw.println("AddType text/jsp .jsp");
            pw.println("AddHandler jserv-servlet .jsp");
            pw.println();
            mod_jk.println();
            mod_jk.println("#");
            mod_jk.println("# Log level to be used by mod_jk");
            mod_jk.println("#");
            mod_jk.println("JkLogLevel error");
            mod_jk.println();
            mod_jk.println("###################################################################");
            mod_jk.println("#                     SSL configuration                           #");
            mod_jk.println("# ");
            mod_jk.println("# By default mod_jk is configured to collect SSL information from");
            mod_jk.println("# the apache environment and send it to the Tomcat workers. The");
            mod_jk.println("# problem is that there are many SSL solutions for Apache and as");
            mod_jk.println("# a result the environment variable names may change.");
            mod_jk.println("#");
            mod_jk.println("# The following (commented out) JK related SSL configureation");
            mod_jk.println("# can be used to customize mod_jk's SSL behaviour.");
            mod_jk.println("# ");
            mod_jk.println("# Should mod_jk send SSL information to Tomact (default is On)");
            mod_jk.println("# JkExtractSSL Off");
            mod_jk.println("# ");
            mod_jk.println("# What is the indicator for SSL (default is HTTPS)");
            mod_jk.println("# JkHTTPSIndicator HTTPS");
            mod_jk.println("# ");
            mod_jk.println("# What is the indicator for SSL session (default is SSL_SESSION_ID)");
            mod_jk.println("# JkSESSIONIndicator SSL_SESSION_ID");
            mod_jk.println("# ");
            mod_jk.println("# What is the indicator for client SSL cipher suit (default is SSL_CIPHER)");
            mod_jk.println("# JkCIPHERIndicator SSL_CIPHER");
            mod_jk.println("# ");
            mod_jk.println("# What is the indicator for the client SSL certificated (default is SSL_CLIENT_CERT)");
            mod_jk.println("# JkCERTSIndicator SSL_CLIENT_CERT");
            mod_jk.println("# ");
            mod_jk.println("#                                                                 #");
            mod_jk.println("###################################################################");
            mod_jk.println();
            mod_jk.println("#");
            mod_jk.println("# Root context mounts for Tomcat");
            mod_jk.println("#");
            mod_jk.println("JkMount /*.jsp ajp12");
            mod_jk.println("JkMount /servlet/* ajp12");
            mod_jk.println();
            enumeration = cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Context context = (Context)enumeration.nextElement();
                String path = context.getPath();
                String vhost = context.getHost();
                if (vhost != null) continue;
                if (path.length() > 1) {
                    String docBase = context.getDocBase();
                    if (!FileUtil.isAbsolute(docBase)) {
                        docBase = String.valueOf(tomcatHome) + "/" + docBase;
                    }
                    docBase = FileUtil.patch(docBase);
                    if (File.separatorChar == '\\') {
                        docBase = docBase.replace('\\', '/');
                    }
                    pw.println("Alias " + path + " \"" + docBase + "\"");
                    pw.println("<Directory \"" + docBase + "\">");
                    pw.println("    Options Indexes FollowSymLinks");
                    pw.println("</Directory>");
                    pw.println("ApJServMount " + path + "/servlet" + " " + path);
                    pw.println("<Location \"" + path + "/WEB-INF/\">");
                    pw.println("    AllowOverride None");
                    pw.println("    deny from all");
                    pw.println("</Location>");
                    if (File.separatorChar == '\\') {
                        pw.println("<Directory \"" + docBase + "/WEB-INF/\">");
                        pw.println("    AllowOverride None");
                        pw.println("    deny from all");
                        pw.println("</Directory>");
                    }
                    pw.println("<Location \"" + path + "/META-INF/\">");
                    pw.println("    AllowOverride None");
                    pw.println("    deny from all");
                    pw.println("</Location>");
                    if (File.separatorChar == '\\') {
                        pw.println("<Directory \"" + docBase + "/META-INF/\">");
                        pw.println("    AllowOverride None");
                        pw.println("    deny from all");
                        pw.println("</Directory>");
                    }
                    pw.println();
                    mod_jk.println("#########################################################");
                    mod_jk.println("# Auto configuration for the " + path + " context starts.");
                    mod_jk.println("#########################################################");
                    mod_jk.println();
                    mod_jk.println("#");
                    mod_jk.println("# The following line makes apache aware of the location of the " + path + " context");
                    mod_jk.println("#");
                    mod_jk.println("Alias " + path + " \"" + docBase + "\"");
                    mod_jk.println("<Directory \"" + docBase + "\">");
                    mod_jk.println("    Options Indexes FollowSymLinks");
                    mod_jk.println("</Directory>");
                    mod_jk.println();
                    mod_jk.println("#");
                    mod_jk.println("# The following line mounts all JSP files and the /servlet/ uri to tomcat");
                    mod_jk.println("#");
                    mod_jk.println("JkMount " + path + "/servlet/* ajp12");
                    mod_jk.println("JkMount " + path + "/*.jsp ajp12");
                    mod_jk.println();
                    mod_jk.println("#");
                    mod_jk.println("# The following line prohibits users from directly accessing WEB-INF");
                    mod_jk.println("#");
                    mod_jk.println("<Location \"" + path + "/WEB-INF/\">");
                    mod_jk.println("    AllowOverride None");
                    mod_jk.println("    deny from all");
                    mod_jk.println("</Location>");
                    if (File.separatorChar == '\\') {
                        mod_jk.println("#");
                        mod_jk.println("# Use Directory too. On Windows, Location doesn't work unless case matches");
                        mod_jk.println("#");
                        mod_jk.println("<Directory \"" + docBase + "/WEB-INF/\">");
                        mod_jk.println("    AllowOverride None");
                        mod_jk.println("    deny from all");
                        mod_jk.println("</Directory>");
                    }
                    mod_jk.println();
                    mod_jk.println("#");
                    mod_jk.println("# The following line prohibits users from directly accessing META-INF");
                    mod_jk.println("#");
                    mod_jk.println("<Location \"" + path + "/META-INF/\">");
                    mod_jk.println("    AllowOverride None");
                    mod_jk.println("    deny from all");
                    mod_jk.println("</Location>");
                    if (File.separatorChar == '\\') {
                        mod_jk.println("#");
                        mod_jk.println("# Use Directory too. On Windows, Location doesn't work unless case matches");
                        mod_jk.println("#");
                        mod_jk.println("<Directory \"" + docBase + "/META-INF/\">");
                        mod_jk.println("    AllowOverride None");
                        mod_jk.println("    deny from all");
                        mod_jk.println("</Directory>");
                    }
                    mod_jk.println();
                    mod_jk.println("#######################################################");
                    mod_jk.println("# Auto configuration for the " + path + " context ends.");
                    mod_jk.println("#######################################################");
                    mod_jk.println();
                    continue;
                }
                pw.println("ApJServMount /servlet /ROOT");
            }
            pw.close();
            mod_jk.close();
        }
        catch (Exception ex) {
            System.out.println("Error generating automatic apache configuration " + ex);
            ex.printStackTrace(System.out);
        }
    }

    String findApache() {
        return null;
    }
}

