/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.clang.basic.DiagnosticsEngine;
import org.clang.frontend.FrontendOptions;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.ClankProgressHandler;
import org.clang.tools.services.impl.CompilationDBFromDumpedEntries;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.support.raw_ostream;

public final class ClangUtilities {
    private static final Pattern variable = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private static final ClankProgressHandler NO_OP_PROGRESS = new ClankProgressHandler(){

        @Override
        public void setDisplayName(String newDisplayName) {
        }

        @Override
        public void start(int workunits, long estimate) {
        }

        @Override
        public void switchToIndeterminate() {
        }

        @Override
        public void switchToDeterminate(int workunits, long estimate) {
        }

        @Override
        public void progress(String message, int workunit) {
        }
    };

    private ClangUtilities() {
    }

    public static CharSequence getFirstCompiledPath(ClankCompilationDataBase.Entry entry) {
        Collection<CharSequence> TUs = entry.getCompiledFiles();
        Iterator<CharSequence> iterator2 = TUs.iterator();
        if (iterator2.hasNext()) {
            CharSequence TU = iterator2.next();
            return TU;
        }
        return "";
    }

    public static void DumpEntry(ClankCompilationDataBase.Entry compileEntry, raw_ostream out) {
        CompilationDBFromDumpedEntries.DumpEntry(compileEntry, out);
    }

    public static ClankProgressHandler EmptyProgress() {
        return NO_OP_PROGRESS;
    }

    public static ClankProgressHandler createProgress(raw_ostream out) {
        return new ClankOSProgressHandler(out);
    }

    public static StringRef createPathStringRef(CharSequence pathOrUrl) {
        return new StringRef(NativePointer.create_char$ptr_utf8((CharSequence)pathOrUrl));
    }

    public static Level toLoggerLevel(DiagnosticsEngine.Level DiagLevel) {
        switch (DiagLevel) {
            case Ignored: 
            case Note: {
                return Level.INFO;
            }
            case Warning: {
                return Level.WARNING;
            }
            case Error: 
            case Fatal: {
                return Level.SEVERE;
            }
        }
        throw new AssertionError((Object)DiagLevel.name());
    }

    public static LangStandard.Kind getLangStandard(String param) {
        LangStandard.Kind LangStd = (LangStandard.Kind)new StringSwitch(param).Case("c89", (Object)LangStandard.Kind.lang_c89).Case("c90", (Object)LangStandard.Kind.lang_c90).Case("iso9899:1990", (Object)LangStandard.Kind.lang_iso9899_1990).Case("iso9899:199409", (Object)LangStandard.Kind.lang_c94).Case("gnu89", (Object)LangStandard.Kind.lang_gnu89).Case("gnu90", (Object)LangStandard.Kind.lang_gnu90).Case("c99", (Object)LangStandard.Kind.lang_c99).Case("c9x", (Object)LangStandard.Kind.lang_c9x).Case("iso9899:1999", (Object)LangStandard.Kind.lang_iso9899_1999).Case("iso9899:199x", (Object)LangStandard.Kind.lang_iso9899_199x).Case("gnu99", (Object)LangStandard.Kind.lang_gnu99).Case("gnu9x", (Object)LangStandard.Kind.lang_gnu9x).Case("c11", (Object)LangStandard.Kind.lang_c11).Case("c1x", (Object)LangStandard.Kind.lang_c1x).Case("iso9899:2011", (Object)LangStandard.Kind.lang_iso9899_2011).Case("iso9899:2011", (Object)LangStandard.Kind.lang_iso9899_201x).Case("gnu11", (Object)LangStandard.Kind.lang_gnu11).Case("gnu1x", (Object)LangStandard.Kind.lang_gnu1x).Case("c++98", (Object)LangStandard.Kind.lang_cxx98).Case("c++03", (Object)LangStandard.Kind.lang_cxx03).Case("gnu++98", (Object)LangStandard.Kind.lang_gnucxx98).Case("c++0x", (Object)LangStandard.Kind.lang_cxx0x).Case("c++11", (Object)LangStandard.Kind.lang_cxx11).Case("gnu++0x", (Object)LangStandard.Kind.lang_gnucxx0x).Case("gnu++11", (Object)LangStandard.Kind.lang_gnucxx11).Case("c++1y", (Object)LangStandard.Kind.lang_cxx1y).Case("gnu++1y", (Object)LangStandard.Kind.lang_gnucxx1y).Case("cl", (Object)LangStandard.Kind.lang_opencl).Case("CL1.1", (Object)LangStandard.Kind.lang_opencl11).Case("CL1.2", (Object)LangStandard.Kind.lang_opencl12).Case("cuda", (Object)LangStandard.Kind.lang_cuda).Default((Object)LangStandard.Kind.lang_unspecified);
        return LangStd;
    }

    public static InputKind getInputKind(String param, String intputFile) {
        InputKind DashX = InputKind.IK_None;
        DashX = (InputKind)new StringSwitch(param).Case("c", (Object)InputKind.IK_C).Case("cl", (Object)InputKind.IK_OpenCL).Case("cuda", (Object)InputKind.IK_CUDA).Case("c++", (Object)InputKind.IK_CXX).Case("objective-c", (Object)InputKind.IK_ObjC).Case("objective-c++", (Object)InputKind.IK_ObjCXX).Case("cpp-output", (Object)InputKind.IK_PreprocessedC).Case("assembler-with-cpp", (Object)InputKind.IK_Asm).Case("c++-cpp-output", (Object)InputKind.IK_PreprocessedCXX).Case("objective-c-cpp-output", (Object)InputKind.IK_PreprocessedObjC).Case("objc-cpp-output", (Object)InputKind.IK_PreprocessedObjC).Case("objective-c++-cpp-output", (Object)InputKind.IK_PreprocessedObjCXX).Case("objc++-cpp-output", (Object)InputKind.IK_PreprocessedObjCXX).Case("c-header", (Object)InputKind.IK_C).Case("cl-header", (Object)InputKind.IK_OpenCL).Case("objective-c-header", (Object)InputKind.IK_ObjC).Case("c++-header", (Object)InputKind.IK_CXX).Case("objective-c++-header", (Object)InputKind.IK_ObjCXX).Cases("ast", "pcm", (Object)InputKind.IK_AST).Case("ir", (Object)InputKind.IK_LLVM_IR).Default((Object)InputKind.IK_None);
        if (DashX == InputKind.IK_None) {
            DashX = FrontendOptions.getInputKindForExtension((StringRef)((StringRef)new StringRef((String)intputFile).rsplit((byte)NativePointer.$((char)'.')).second));
        }
        return DashX;
    }

    public static String substituteEnvironmentVariables(String from) {
        return ClangUtilities.substituteEnvironmentVariables(from, System.getenv(), null);
    }

    public static String substituteEnvironmentVariables(String str, Map<String, String> variables, Map<String, String> usedVariables) {
        if (usedVariables == null) {
            usedVariables = new HashMap<String, String>();
        } else {
            usedVariables.clear();
        }
        Matcher matcher = variable.matcher(str);
        int start = 0;
        while (matcher.find(start)) {
            String property = variables.get(matcher.group(1));
            if (property != null) {
                usedVariables.put(matcher.group(), property);
            }
            start = matcher.end();
        }
        for (String key : usedVariables.keySet()) {
            str = str.replace(key, usedVariables.get(key));
        }
        return str;
    }

    private static final class ClankOSProgressHandler
    implements ClankProgressHandler {
        private final raw_ostream out;

        public ClankOSProgressHandler(raw_ostream out) {
            this.out = out;
        }

        @Override
        public void setDisplayName(String newDisplayName) {
            this.out.$out(newDisplayName).$out_char((byte)10).flush();
        }

        @Override
        public void start(int workunits, long estimate) {
            this.out.$out("Started to proceed ").$out_uint(workunits).$out(" work units\n").flush();
        }

        @Override
        public void switchToIndeterminate() {
        }

        @Override
        public void switchToDeterminate(int workunits, long estimate) {
            this.out.$out("Going to proceed ").$out_uint(workunits).$out(" work units\n").flush();
        }

        @Override
        public void progress(String message, int workunit) {
            this.out.$out(message).$out_char((byte)10).flush();
        }
    }

    public static class ClankProgressHandlerChain
    implements ClankProgressHandler {
        private final ClankProgressHandler next;

        public ClankProgressHandlerChain(ClankProgressHandler next) {
            this.next = next;
        }

        @Override
        public void setDisplayName(String newDisplayName) {
            this.next.setDisplayName(newDisplayName);
        }

        @Override
        public void start(int workunits, long estimate) {
            this.next.start(workunits, estimate);
        }

        @Override
        public void switchToIndeterminate() {
            this.next.switchToIndeterminate();
        }

        @Override
        public void switchToDeterminate(int workunits, long estimate) {
            this.next.switchToDeterminate(workunits, estimate);
        }

        @Override
        public void progress(String message, int workunit) {
            this.next.progress(message, workunit);
        }
    }
}

