/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import org.netbeans.modules.cnd.apt.impl.support.APTConstTextToken;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;
import org.netbeans.modules.cnd.apt.support.APTTokenTypes;

public final class APTLiteConstTextToken
extends APTTokenAbstact
implements APTTokenTypes {
    private static final int COL_BITS = 10;
    private static final int MAX_COL = 1023;
    private static final int LINE_BITS = 16;
    private static final int MAX_LINE = 65535;
    private static final int TYPE_BITS = 6;
    private static final int MAX_TYPE = 63;
    private final int offset;
    private final int columnLineType;

    public static String toText(int type) {
        assert (APTLiteConstTextToken.isLiteConstTextType(type));
        return APTConstTextToken.constText[type];
    }

    public static CharSequence toTextID(int type) {
        assert (APTLiteConstTextToken.isLiteConstTextType(type));
        return APTConstTextToken.constTextID[type];
    }

    public static boolean isLiteConstTextType(int type) {
        return type > 3 && type < 62;
    }

    public static boolean isApplicable(int type, int offset, int column, int line) {
        return APTLiteConstTextToken.isLiteConstTextType(type) && type <= 63 && line <= 65535 && column <= 1023;
    }

    public APTLiteConstTextToken(int type, int offset, int column, int line) {
        this.offset = offset;
        this.columnLineType = (((column & 0x3FF) << 16) + (line & 0xFFFF) << 6) + (type & 0x3F);
        assert (type == this.getType());
        assert (column == this.getColumn());
        assert (line == this.getLine());
    }

    @Override
    public String getText() {
        return APTConstTextToken.constText[this.columnLineType & 0x3F];
    }

    @Override
    public void setText(String t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getTextID() {
        return APTConstTextToken.constTextID[this.columnLineType & 0x3F];
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getType() {
        return this.columnLineType & 0x3F;
    }

    @Override
    public void setType(int t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getColumn() {
        return this.columnLineType >> 22 & 0x3FF;
    }

    @Override
    public void setColumn(int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLine() {
        return this.columnLineType >> 6 & 0xFFFF;
    }

    @Override
    public void setLine(int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEndOffset() {
        return this.getOffset() + this.getTextID().length();
    }

    @Override
    public int getEndLine() {
        return this.getLine();
    }

    @Override
    public int getEndColumn() {
        return this.getColumn() + this.getTextID().length();
    }
}

