/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;

public class DiagnosticBuilder
implements Destructors.ClassWithDestructor {
    private DiagnosticsEngine DiagObj;
    private int NumArgs;
    private boolean IsActive;
    private boolean IsForceEmit;

    private void $assign(DiagnosticBuilder $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private DiagnosticBuilder() {
        this.DiagObj = null;
        this.NumArgs = 0;
        this.IsActive = false;
        this.IsForceEmit = false;
    }

    DiagnosticBuilder(DiagnosticsEngine diagObj) {
        this.DiagObj = diagObj;
        this.NumArgs = 0;
        this.IsActive = true;
        this.IsForceEmit = false;
        assert (diagObj != null) : "DiagnosticBuilder requires a valid DiagnosticsEngine!";
        diagObj.DiagRanges.clear();
        diagObj.DiagFixItHints.clear();
    }

    protected void FlushCounts() {
        this.DiagObj.NumDiagArgs = (byte)this.NumArgs;
    }

    protected void Clear() {
        this.DiagObj = null;
        this.IsActive = false;
        this.IsForceEmit = false;
    }

    protected boolean isActive() {
        return this.IsActive;
    }

    protected boolean Emit() {
        if (!this.isActive()) {
            return false;
        }
        this.FlushCounts();
        boolean Result = this.DiagObj.EmitCurrentDiagnostic(this.IsForceEmit);
        this.Clear();
        return Result;
    }

    public DiagnosticBuilder(DiagnosticBuilder D) {
        this.DiagObj = null;
        this.NumArgs = 0;
        this.IsActive = false;
        this.IsForceEmit = false;
        this.DiagObj = D.DiagObj;
        this.IsActive = D.IsActive;
        this.IsForceEmit = D.IsForceEmit;
        D.Clear();
        this.NumArgs = D.NumArgs;
    }

    public static DiagnosticBuilder getEmpty() {
        return new DiagnosticBuilder();
    }

    public void $destroy() {
        this.Emit();
    }

    public DiagnosticBuilder setForceEmit() {
        this.IsForceEmit = true;
        return this;
    }

    public boolean $bool() {
        return true;
    }

    public void AddString(StringRef S) {
        assert (this.isActive()) : "Clients must not add to cleared diagnostic!";
        assert (Unsigned.$less_uint_int((int)this.NumArgs, (int)10)) : "Too many arguments to diagnostic!";
        this.DiagObj.DiagArgumentsKind[this.NumArgs] = DiagnosticsEngine.ArgumentKind.ak_std_string;
        this.DiagObj.DiagArgumentsStr[this.NumArgs++].$assignMove(S.$basic_string());
    }

    public void AddTaggedVal(Object V, DiagnosticsEngine.ArgumentKind Kind2) {
        assert (this.isActive()) : "Clients must not add to cleared diagnostic!";
        assert (Unsigned.$less_uint_int((int)this.NumArgs, (int)10)) : "Too many arguments to diagnostic!";
        this.DiagObj.DiagArgumentsKind[this.NumArgs] = Kind2;
        this.DiagObj.DiagArgumentsVal[this.NumArgs++] = V;
    }

    public void AddSourceRange(CharSourceRange R) {
        assert (this.isActive()) : "Clients must not add to cleared diagnostic!";
        this.DiagObj.DiagRanges.push_back((Object)R);
    }

    public void AddFixItHint(FixItHint Hint) {
        assert (this.isActive()) : "Clients must not add to cleared diagnostic!";
        if (!Hint.isNull()) {
            this.DiagObj.DiagFixItHints.push_back((Object)Hint);
        }
    }

    public void addFlagValue(StringRef V) {
        this.DiagObj.FlagValue.$assignMove(V.$basic_string());
    }

    public String toString() {
        return "DiagObj=" + (Object)((Object)this.DiagObj) + ", NumArgs=" + this.NumArgs + ", IsActive=" + this.IsActive + ", IsForceEmit=" + this.IsForceEmit;
    }
}

