/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.CharSourceRange;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceRange;
import org.clang.basic.declcontext.DeclContext;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.CrashRecoveryContext;

public class PartialDiagnostic
implements Destructors.ClassWithDestructor {
    public static final int MaxArguments = 10;
    private int DiagID;
    private Storage DiagStorage;
    private StorageAllocator Allocator;

    private Storage getStorage() {
        if (this.DiagStorage != null) {
            return this.DiagStorage;
        }
        if (this.Allocator != null) {
            this.DiagStorage = this.Allocator.Allocate();
        } else {
            assert (this.Allocator != Casts.reinterpret_cast(StorageAllocator.class, (long)-1L));
            this.DiagStorage = new Storage();
        }
        return this.DiagStorage;
    }

    private void freeStorage() {
        if (this.DiagStorage == null) {
            return;
        }
        this.freeStorageSlow();
    }

    private void freeStorageSlow() {
        if (this.Allocator != null) {
            this.Allocator.Deallocate(this.DiagStorage);
        } else if (this.Allocator != Casts.reinterpret_cast(StorageAllocator.class, (long)-1L) && this.DiagStorage != null) {
            this.DiagStorage.$destroy();
        }
        this.DiagStorage = null;
    }

    private void AddSourceRange(CharSourceRange R) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        this.DiagStorage.DiagRanges.push_back((Object)R);
    }

    private void AddFixItHint(FixItHint Hint) {
        if (Hint.isNull()) {
            return;
        }
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        this.DiagStorage.FixItHints.push_back((Object)Hint);
    }

    public PartialDiagnostic(NullDiagnostic $Prm0) {
        this.DiagID = 0;
        this.DiagStorage = null;
        this.Allocator = null;
    }

    public PartialDiagnostic(int DiagID, StorageAllocator Allocator2) {
        this.DiagID = DiagID;
        this.DiagStorage = null;
        this.Allocator = Allocator2;
    }

    public PartialDiagnostic(PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = null;
        this.Allocator = Other.Allocator;
        if (Other.DiagStorage != null) {
            this.DiagStorage = this.getStorage();
            this.DiagStorage.$assign(Other.DiagStorage);
        }
    }

    public PartialDiagnostic(JavaDifferentiators.JD.Move _dparam, PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = Other.DiagStorage;
        this.Allocator = Other.Allocator;
        Other.DiagStorage = null;
    }

    public PartialDiagnostic(PartialDiagnostic Other, Storage DiagStorage) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = DiagStorage;
        this.Allocator = (StorageAllocator)Casts.reinterpret_cast(StorageAllocator.class, (long)-1L);
        if (Other.DiagStorage != null) {
            this.DiagStorage.$assign(Other.DiagStorage);
        }
    }

    public PartialDiagnostic(Diagnostic Other, StorageAllocator Allocator2) {
        int I;
        this.DiagID = Other.getID();
        this.DiagStorage = null;
        this.Allocator = Allocator2;
        int N = Other.getNumArgs();
        for (I = 0; I != N; ++I) {
            if (Other.getArgKind(I) == DiagnosticsEngine.ArgumentKind.ak_std_string) {
                this.AddString(new StringRef(Other.getArgStdStr(I)));
                continue;
            }
            this.AddTaggedVal(Other.getRawArg(I), Other.getArgKind(I));
        }
        N = Other.getNumRanges();
        for (I = 0; I != N; ++I) {
            this.AddSourceRange(Other.getRange(I));
        }
        N = Other.getNumFixItHints();
        for (I = 0; I != N; ++I) {
            this.AddFixItHint(Other.getFixItHint(I));
        }
    }

    public PartialDiagnostic $assign(PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        if (Other.DiagStorage != null) {
            if (this.DiagStorage == null) {
                this.DiagStorage = this.getStorage();
            }
            this.DiagStorage.$assign(Other.DiagStorage);
        } else {
            this.freeStorage();
        }
        return this;
    }

    public PartialDiagnostic $assignMove(PartialDiagnostic Other) {
        this.freeStorage();
        this.DiagID = Other.DiagID;
        this.DiagStorage = Other.DiagStorage;
        this.Allocator = Other.Allocator;
        Other.DiagStorage = null;
        return this;
    }

    public void $destroy() {
        this.freeStorage();
    }

    public void swap(PartialDiagnostic PD) {
        int DiagIDPrev = this.DiagID;
        this.DiagID = PD.DiagID;
        PD.DiagID = DiagIDPrev;
        Storage DiagStoragePrev = this.DiagStorage;
        this.DiagStorage = PD.DiagStorage;
        PD.DiagStorage = DiagStoragePrev;
        StorageAllocator AllocatorPrev = this.Allocator;
        this.Allocator = PD.Allocator;
        PD.Allocator = AllocatorPrev;
    }

    public int getDiagID() {
        return this.DiagID;
    }

    public void AddTaggedVal(Object V, DiagnosticsEngine.ArgumentKind Kind2) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        assert (Unsigned.$uchar2int((byte)this.DiagStorage.NumDiagArgs) < 10) : "Too many arguments to diagnostic!";
        this.DiagStorage.DiagArgumentsKind[this.DiagStorage.NumDiagArgs] = Kind2;
        byte by = this.DiagStorage.NumDiagArgs;
        this.DiagStorage.NumDiagArgs = (byte)(by + 1);
        this.DiagStorage.DiagArgumentsVal[by] = V;
    }

    public void AddString(StringRef V) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        assert (Unsigned.$uchar2int((byte)this.DiagStorage.NumDiagArgs) < 10) : "Too many arguments to diagnostic!";
        this.DiagStorage.DiagArgumentsKind[this.DiagStorage.NumDiagArgs] = DiagnosticsEngine.ArgumentKind.ak_std_string;
        byte by = this.DiagStorage.NumDiagArgs;
        this.DiagStorage.NumDiagArgs = (byte)(by + 1);
        this.DiagStorage.DiagArgumentsStr[by].$assignMove(V.$basic_string());
    }

    public void Emit(DiagnosticBuilder DB) {
        if (this.DiagStorage == null) {
            return;
        }
        int e = Unsigned.$uchar2uint((byte)this.DiagStorage.NumDiagArgs);
        for (int i = 0; i != e; ++i) {
            if (this.DiagStorage.DiagArgumentsKind[i] == DiagnosticsEngine.ArgumentKind.ak_std_string) {
                DB.AddString(new StringRef(this.DiagStorage.DiagArgumentsStr[i]));
                continue;
            }
            DB.AddTaggedVal(this.DiagStorage.DiagArgumentsVal[i], this.DiagStorage.DiagArgumentsKind[i]);
        }
        for (CharSourceRange Range : this.DiagStorage.DiagRanges) {
            DB.AddSourceRange(Range);
        }
        for (FixItHint Fix : this.DiagStorage.FixItHints) {
            DB.AddFixItHint(Fix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitToString(DiagnosticsEngine Diags, SmallString Buf) {
        DiagnosticBuilder DB = null;
        try {
            DB = Diags.Report(this.getDiagID());
            this.Emit(DB);
            DB.FlushCounts();
            new Diagnostic(Diags).FormatDiagnostic(Buf);
            DB.Clear();
            Diags.Clear();
        }
        finally {
            if (DB != null) {
                DB.$destroy();
            }
        }
    }

    public void Reset() {
        this.Reset(0);
    }

    public void Reset(int DiagID) {
        this.DiagID = DiagID;
        this.freeStorage();
    }

    public boolean hasStorage() {
        return this.DiagStorage != null;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_uint(PartialDiagnostic PD, int I) {
        PD.AddTaggedVal(I, DiagnosticsEngine.ArgumentKind.ak_uint);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_int(PartialDiagnostic PD, int I) {
        PD.AddTaggedVal(I, DiagnosticsEngine.ArgumentKind.ak_sint);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_char$ptr$C(PartialDiagnostic PD, char.ptr S) {
        PD.AddTaggedVal(Casts.reinterpret_cast_Object((Object)S), DiagnosticsEngine.ArgumentKind.ak_c_string);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_StringRef(PartialDiagnostic PD, StringRef S) {
        PD.AddString(new StringRef(S));
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_IdentifierInfo(PartialDiagnostic PD, IdentifierInfo II) {
        PD.AddTaggedVal(Casts.reinterpret_cast_Object((Object)((Object)II)), DiagnosticsEngine.ArgumentKind.ak_identifierinfo);
        return PD;
    }

    public static PartialDiagnostic $out$Same2DeclContext(PartialDiagnostic PD, DeclContext DC) {
        PD.AddTaggedVal(Casts.reinterpret_cast_Object((Object)DC), DiagnosticsEngine.ArgumentKind.ak_declcontext);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_SourceRange(PartialDiagnostic PD, SourceRange R) {
        PD.AddSourceRange(CharSourceRange.getTokenRange(R));
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_CharSourceRange(PartialDiagnostic PD, CharSourceRange R) {
        PD.AddSourceRange(R);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic_FixItHint(PartialDiagnostic PD, FixItHint Hint) {
        PD.AddFixItHint(Hint);
        return PD;
    }

    public String toString() {
        return "DiagID=" + this.DiagID + ", DiagStorage=" + this.DiagStorage + ", Allocator=" + this.Allocator;
    }

    public static class NullDiagnostic {
        public NullDiagnostic(JavaDifferentiators.JD.Move _dparam, NullDiagnostic $Prm0) {
        }

        public void $destroy() {
        }

        public String toString() {
            return "";
        }
    }

    public static class StorageAllocator
    implements Destructors.ClassWithDestructor {
        private static int NumCached = 16;
        private Storage[] Cached = new Storage[16];
        private Storage[] FreeList = new Storage[16];
        private int NumFreeListEntries;

        public StorageAllocator() {
            this.Cached = (Storage[])NativePointer.new$T((Object[])new Storage[16], () -> new Storage());
            for (int I = 0; I != NumCached; ++I) {
                this.FreeList[I] = this.Cached[I];
            }
            this.NumFreeListEntries = NumCached;
        }

        public void $destroy() {
            assert (this.NumFreeListEntries == NumCached || CrashRecoveryContext.isRecoveringFromCrash()) : "A partial is on the lamb";
            Destructors.$destroyArray((Object)this.Cached);
        }

        public Storage Allocate() {
            if (this.NumFreeListEntries == 0) {
                return new Storage();
            }
            Storage Result = this.FreeList[--this.NumFreeListEntries];
            Result.NumDiagArgs = 0;
            Result.DiagRanges.clear();
            Result.FixItHints.clear();
            return Result;
        }

        public void Deallocate(Storage S) {
            for (Storage storage : this.Cached) {
                if (storage != S) continue;
                this.FreeList[this.NumFreeListEntries++] = S;
                return;
            }
            if (S != null) {
                S.$destroy();
            }
        }

        public String toString() {
            return "Cached=" + this.Cached + ", FreeList=" + this.FreeList + ", NumFreeListEntries=" + this.NumFreeListEntries;
        }
    }

    public static class Storage
    implements Destructors.ClassWithDestructor {
        public static final int MaxArguments = 10;
        public byte NumDiagArgs = 0;
        public DiagnosticsEngine.ArgumentKind[] DiagArgumentsKind = (DiagnosticsEngine.ArgumentKind[])NativePointer.new$T((Object[])new DiagnosticsEngine.ArgumentKind[10], () -> DiagnosticsEngine.ArgumentKind.ak_std_string);
        public Object[] DiagArgumentsVal = new Object[10];
        public std.string[] DiagArgumentsStr = (std.string[])NativePointer.new$T((Object[])new std.string[10], () -> new std.string());
        public SmallVector<CharSourceRange> DiagRanges = new SmallVector(8, (Object)new CharSourceRange());
        public SmallVector<FixItHint> FixItHints = new SmallVector(6, (Object)new FixItHint());

        public Storage $assign(Storage $Prm0) {
            this.NumDiagArgs = $Prm0.NumDiagArgs;
            std.__builtin_memcpy((Object[])this.DiagArgumentsKind, (Object[])$Prm0.DiagArgumentsKind, (int)$Prm0.DiagArgumentsKind.length);
            std.__builtin_memcpy((Object[])this.DiagArgumentsVal, (Object[])$Prm0.DiagArgumentsVal, (int)$Prm0.DiagArgumentsVal.length);
            for (int __i0 = 0; __i0 != $Prm0.DiagArgumentsStr.length; ++__i0) {
                this.DiagArgumentsStr[__i0].$assign($Prm0.DiagArgumentsStr[__i0]);
            }
            this.DiagRanges.$assign($Prm0.DiagRanges);
            this.FixItHints.$assign($Prm0.FixItHints);
            return this;
        }

        public void $destroy() {
        }

        public String toString() {
            return "NumDiagArgs=" + this.NumDiagArgs + ", DiagArgumentsKind=" + this.DiagArgumentsKind + ", DiagArgumentsVal=" + this.DiagArgumentsVal + ", DiagArgumentsStr=" + this.DiagArgumentsStr + ", DiagRanges=" + this.DiagRanges + ", FixItHints=" + this.FixItHints;
        }
    }
}

