/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierTable;
import org.clang.basic.LangOptions;
import org.clang.basic.impl.KeywordStatus;
import org.clang.basic.impl.SelectorTableImpl;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;

public final class IdentifierTableStatics {
    public static final int KEYC99 = 1;
    public static final int KEYCXX = 2;
    public static final int KEYCXX11 = 4;
    public static final int KEYGNU = 8;
    public static final int KEYMS = 16;
    public static final int BOOLSUPPORT = 32;
    public static final int KEYALTIVEC = 64;
    public static final int KEYNOCXX = 128;
    public static final int KEYBORLAND = 256;
    public static final int KEYOPENCL = 512;
    public static final int KEYC11 = 1024;
    public static final int KEYARC = 2048;
    public static final int KEYNOMS18 = 4096;
    public static final int KEYNOOPENCL = 8192;
    public static final int WCHARSUPPORT = 16384;
    public static final int HALFSUPPORT = 32768;
    public static final int KEYCONCEPTS = 65536;
    public static final int KEYOBJC2 = 131072;
    public static final int KEYZVECTOR = 262144;
    public static final int KEYCOROUTINES = 524288;
    public static final int KEYALL = 1036287;

    public static KeywordStatus getKeywordStatus(LangOptions LangOpts, int Flags) {
        if (Flags == 1036287) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.CPlusPlus && (Flags & 2) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.CPlusPlus11 && (Flags & 4) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.C99 && (Flags & 1) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.GNUKeywords && (Flags & 8) != 0) {
            return KeywordStatus.KS_Extension;
        }
        if (LangOpts.MicrosoftExt && (Flags & 0x10) != 0) {
            return KeywordStatus.KS_Extension;
        }
        if (LangOpts.Borland && (Flags & 0x100) != 0) {
            return KeywordStatus.KS_Extension;
        }
        if (LangOpts.Bool && (Flags & 0x20) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.Half && (Flags & 0x8000) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.WChar && (Flags & 0x4000) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.AltiVec && (Flags & 0x40) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.OpenCL && (Flags & 0x200) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (!LangOpts.CPlusPlus && (Flags & 0x80) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.C11 && (Flags & 0x400) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.ObjC2 && (Flags & 0x800) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.ConceptsTS && (Flags & 0x10000) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.ObjC2 && (Flags & 0x20000) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.Coroutines && (Flags & 0x80000) != 0) {
            return KeywordStatus.KS_Enabled;
        }
        if (LangOpts.CPlusPlus && (Flags & 4) != 0) {
            return KeywordStatus.KS_Future;
        }
        return KeywordStatus.KS_Disabled;
    }

    public static void AddKeyword(String Keyword, char TokenCode, int Flags, LangOptions LangOpts, IdentifierTable Table) {
        IdentifierTableStatics.AddKeyword(new StringRef(Keyword), TokenCode, Flags, LangOpts, Table);
    }

    public static void AddKeyword(StringRef Keyword, char TokenCode, int Flags, LangOptions LangOpts, IdentifierTable Table) {
        KeywordStatus AddResult = IdentifierTableStatics.getKeywordStatus(LangOpts, Flags);
        if (LangOpts.MSVCCompat && (Flags & 0x1000) != 0 && !LangOpts.isCompatibleWithMSVC(LangOptions.MSVCMajorVersion.MSVC2015)) {
            return;
        }
        if (LangOpts.OpenCL && (Flags & 0x2000) != 0) {
            return;
        }
        if (AddResult == KeywordStatus.KS_Disabled) {
            return;
        }
        IdentifierInfo Info2 = Table.get(Keyword, AddResult == KeywordStatus.KS_Future ? (char)'\u0005' : (char)TokenCode);
        Info2.setIsExtensionToken(AddResult == KeywordStatus.KS_Extension);
        Info2.setIsFutureCompatKeyword(AddResult == KeywordStatus.KS_Future);
    }

    public static void AddCXXOperatorKeyword(String Keyword, char TokenCode, IdentifierTable Table) {
        IdentifierTableStatics.AddCXXOperatorKeyword(new StringRef(Keyword), TokenCode, Table);
    }

    public static void AddCXXOperatorKeyword(StringRef Keyword, char TokenCode, IdentifierTable Table) {
        IdentifierInfo Info2 = Table.get(Keyword, TokenCode);
        Info2.setIsCPlusPlusOperatorKeyword();
    }

    public static void AddObjCKeyword(String Name, char ObjCID, IdentifierTable Table) {
        IdentifierTableStatics.AddObjCKeyword(new StringRef(Name), ObjCID, Table);
    }

    public static void AddObjCKeyword(StringRef Name, char ObjCID, IdentifierTable Table) {
        Table.get(Name).setObjCKeywordID(ObjCID);
    }

    public static KeywordStatus getTokenKwStatus(LangOptions LangOpts, char K) {
        switch (K) {
            case 'K': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'L': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'M': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'N': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'O': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'P': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'Q': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'R': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'S': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'T': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'U': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'V': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'W': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'X': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'Y': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'Z': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '[': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 11);
            }
            case '\\': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case ']': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '^': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '_': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1);
            }
            case '`': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'a': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'b': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'c': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'd': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'e': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'g': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'h': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'i': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'j': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'k': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'l': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'm': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'n': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'o': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1044479);
            }
            case 'p': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 128);
            }
            case 'q': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'r': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 's': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 't': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'u': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'v': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'w': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'x': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'y': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case 'z': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 10);
            }
            case '{': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 32);
            }
            case '|': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '}': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '~': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u007f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0080': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0081': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0082': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0083': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 32);
            }
            case '\u0084': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0085': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0086': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0087': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0088': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0089': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u008a': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u008b': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u008c': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u008d': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u008e': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u008f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0090': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0091': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 32);
            }
            case '\u0092': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0093': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0094': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0095': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0096': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u0097': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16384);
            }
            case '\u0098': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u0099': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u009a': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4100);
            }
            case '\u009b': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4100);
            }
            case '\u009c': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u009d': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u009e': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u009f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u00a0': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u00a1': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 4);
            }
            case '\u00a2': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 65536);
            }
            case '\u00a3': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 65536);
            }
            case '\u00a4': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 524288);
            }
            case '\u00a5': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 524288);
            }
            case '\u00a6': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 524288);
            }
            case '\u00a7': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00a8': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00a9': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00aa': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ab': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00ac': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00ad': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00ae': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00af': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 128);
            }
            case '\u00b0': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b1': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b2': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b3': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b4': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b5': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b6': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b7': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b8': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00b9': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00ba': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u00bb': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 8);
            }
            case '\u00bc': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u00bd': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u00be': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u00bf': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u00c0': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u00c1': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u00c2': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u00c3': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00c4': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00c5': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00c6': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00c7': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00c8': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00c9': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ca': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00cb': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00cc': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00cd': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ce': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00cf': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d0': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d1': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d2': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d3': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d4': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d5': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d6': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d7': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d8': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00d9': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00da': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00db': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00dc': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00dd': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00de': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00df': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e0': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e1': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e2': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e3': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e4': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e5': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e6': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e7': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e8': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00e9': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ea': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00eb': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ec': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ed': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ee': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ef': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f0': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f1': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f2': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f3': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f4': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f5': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f6': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f7': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f8': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00f9': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00fa': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00fb': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00fc': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00fd': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00fe': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2);
            }
            case '\u00ff': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0100': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0101': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 0);
            }
            case '\u0102': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0103': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0104': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0105': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0106': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0107': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0108': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0109': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u010a': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u010b': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u010c': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u010d': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u010e': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u010f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0110': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0111': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0112': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0113': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0114': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 262720);
            }
            case '\u0115': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0116': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0117': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0118': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0119': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u011a': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u011b': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u011c': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u011d': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u011e': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u011f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0120': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0121': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0122': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 512);
            }
            case '\u0123': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0124': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 262208);
            }
            case '\u0125': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 64);
            }
            case '\u0126': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 262208);
            }
            case '\u0127': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 32768);
            }
            case '\u0128': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2048);
            }
            case '\u0129': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2048);
            }
            case '\u012a': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2048);
            }
            case '\u012b': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 2048);
            }
            case '\u012c': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 131072);
            }
            case '\u012d': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 131072);
            }
            case '\u012e': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 131072);
            }
            case '\u012f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0130': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0131': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0132': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0133': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0134': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0135': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0136': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0137': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 272);
            }
            case '\u0138': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 272);
            }
            case '\u0139': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 272);
            }
            case '\u013a': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 272);
            }
            case '\u013b': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u013c': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u013d': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u013e': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u013f': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0140': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0141': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 16);
            }
            case '\u0142': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0143': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
            case '\u0144': {
                return IdentifierTableStatics.getKeywordStatus(LangOpts, 1036287);
            }
        }
        return KeywordStatus.KS_Disabled;
    }

    public static boolean startsWithWord(StringRef name, StringRef word) {
        if (Unsigned.$less_uint((int)name.size(), (int)word.size())) {
            return false;
        }
        return (name.size() == word.size() || !BasicClangGlobals.isLowercase(name.$at(word.size()))) && name.startswith(word);
    }

    public static boolean startsWithWord(StringRef name, String word) {
        if (name.size() < word.length()) {
            return false;
        }
        return (name.size() == word.length() || !BasicClangGlobals.isLowercase(name.$at(word.length()))) && name.startswith(word);
    }

    public static SelectorTableImpl getSelectorTableImpl(Object P) {
        return (SelectorTableImpl)P;
    }
}

