/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.AppletXml;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.JavacardXml;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import com.sun.javacard.jcasm.cap.Xml;
import com.sun.javacard.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;

public class CapWriter {
    private static final Attributes.Name TIMESTAMP = new Attributes.Name("Java-Card-CAP-Creation-Time");
    private static final Attributes.Name CAP_FILE_VERSION = new Attributes.Name("Java-Card-CAP-File-Version");
    private static final Attributes.Name CONVERTER_VERSION = new Attributes.Name("Java-Card-Converter-Version");
    private static final Attributes.Name CONVERTER_PROVIDER = new Attributes.Name("Java-Card-Converter-Provider");
    private static final Attributes.Name PACKAGE_VERSION = new Attributes.Name("Java-Card-Package-Version");
    private static final Attributes.Name PACKAGE_NAME = new Attributes.Name("Java-Card-Package-Name");
    private static final Attributes.Name PACKAGE_AID = new Attributes.Name("Java-Card-Package-AID");
    private static final Attributes.Name INTEGER_SUPPORT = new Attributes.Name("Java-Card-Integer-Support-Required");
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final Attributes.Name JCRD_VERSION = new Attributes.Name("Runtime-Descriptor-Version");
    private static final Attributes.Name APPLICATION_TYPE = new Attributes.Name("Application-Type");
    private static final Attributes.Name SEALED = new Attributes.Name("Sealed");
    private static final Attributes.Name CLASSIC_PKG_AID = new Attributes.Name("Classic-Package-AID");
    protected File file;
    protected String packageName;
    protected long timeStamp;
    private Hashtable<String, JarEntryData> capEntries = new Hashtable();

    public CapWriter(File file, String string) {
        this.file = file;
        this.packageName = string;
        this.timeStamp = System.currentTimeMillis();
    }

    void readInputCap(String string) {
        try {
            JarEntry jarEntry = null;
            JarFile jarFile = new JarFile(string);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.getSize() == 0L) continue;
                JarEntryData jarEntryData = new JarEntryData();
                jarEntryData.je = jarEntry;
                byte[] byArray = new byte[(int)jarEntry.getSize()];
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                inputStream.read(byArray);
                jarEntryData.data = byArray;
                this.capEntries.put(jarEntry.getName(), jarEntryData);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String findPackageName() {
        String string = null;
        Enumeration<String> enumeration = this.capEntries.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toLowerCase();
            if (!string2.endsWith("/javacard/header.cap")) continue;
            string = string2.substring(0, string2.indexOf("/header.cap"));
            break;
        }
        return string;
    }

    public void publish(File[] fileArray, File[] fileArray2, AppletXml appletXml, JavacardXml javacardXml, ConversionProfile conversionProfile, HeaderComponent headerComponent) {
        this.readInputCap(conversionProfile.inputCapName);
        String string = this.findPackageName();
        JarOutputStream jarOutputStream = null;
        try {
            Object object;
            Object object2;
            Object object3;
            try {
                object3 = new FileInputStream(conversionProfile.inputCapName);
                object2 = new JarInputStream((InputStream)object3);
                object = ((JarInputStream)object2).getManifest();
                boolean bl = appletXml != null;
                jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.file), this.getJarManifest(headerComponent.getParentPackage(), (Manifest)object, bl));
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{this.file.getAbsolutePath()};
                Msg.error("capWriter.1", objectArray);
                return;
            }
            jarOutputStream.setMethod(0);
            object3 = this.capEntries.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (!((String)object2).toLowerCase().startsWith(string)) continue;
                object = this.capEntries.get(object2);
                this.addJarEntry(jarOutputStream, ((JarEntryData)object).je, ((JarEntryData)object).data);
            }
            this.publishCommon(jarOutputStream, fileArray, fileArray2, appletXml, javacardXml);
            jarOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void publish(HeaderComponent headerComponent, DirectoryComponent directoryComponent, AppletComponent appletComponent, ImportComponent importComponent, ConstantPoolComponent constantPoolComponent, ClassComponent classComponent, MethodComponent methodComponent, StaticFieldComponent staticFieldComponent, ReferenceLocationComponent referenceLocationComponent, ExportComponent exportComponent, DescriptorComponent descriptorComponent, DebugComponent debugComponent, File[] fileArray, File[] fileArray2, AppletXml appletXml, JavacardXml javacardXml) throws IOException {
        JarOutputStream jarOutputStream = null;
        try {
            boolean bl = appletXml != null;
            jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.file), this.getJarManifest(headerComponent.getParentPackage(), null, bl));
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{this.file.getAbsolutePath()};
            Msg.error("capWriter.1", objectArray);
            return;
        }
        jarOutputStream.setMethod(0);
        this.addJarEntry(jarOutputStream, "Header.cap", headerComponent);
        this.addJarEntry(jarOutputStream, "Directory.cap", directoryComponent);
        if (appletComponent != null) {
            this.addJarEntry(jarOutputStream, "Applet.cap", appletComponent);
        }
        this.addJarEntry(jarOutputStream, "Import.cap", importComponent);
        this.addJarEntry(jarOutputStream, "ConstantPool.cap", constantPoolComponent);
        this.addJarEntry(jarOutputStream, "Class.cap", classComponent);
        this.addJarEntry(jarOutputStream, "Method.cap", methodComponent);
        this.addJarEntry(jarOutputStream, "StaticField.cap", staticFieldComponent);
        this.addJarEntry(jarOutputStream, "RefLocation.cap", referenceLocationComponent);
        if (exportComponent != null) {
            this.addJarEntry(jarOutputStream, "Export.cap", exportComponent);
        }
        if (descriptorComponent != null) {
            this.addJarEntry(jarOutputStream, "Descriptor.cap", descriptorComponent);
        }
        if (debugComponent != null) {
            byte[] byArray = this.mergeDebugOffsets(classComponent, methodComponent, staticFieldComponent);
            this.addJarEntry(jarOutputStream, "Debug.cap", byArray);
        }
        this.publishCommon(jarOutputStream, fileArray, fileArray2, appletXml, javacardXml);
        jarOutputStream.close();
    }

    public void publishUsingCapComponents(ConversionProfile conversionProfile, HeaderComponent headerComponent, File[] fileArray, AppletXml appletXml, JavacardXml javacardXml) throws IOException {
        JarOutputStream jarOutputStream = null;
        try {
            boolean bl = appletXml != null;
            jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.file), this.getJarManifest(headerComponent.getParentPackage(), null, bl));
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{this.file.getAbsolutePath()};
            Msg.error("capWriter.1", objectArray);
            return;
        }
        jarOutputStream.setMethod(0);
        String string = conversionProfile.class_root + "/" + this.packageName + "/javacard";
        Vector<File> vector = FileUtils.listAllFilesInFolder(new File(string), ".cap");
        for (File file : vector) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file.getAbsoluteFile(), "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            this.addJarEntry(jarOutputStream, file.getName(), byArray);
        }
        this.publishCommon(jarOutputStream, conversionProfile.classes, fileArray, appletXml, javacardXml);
        jarOutputStream.close();
    }

    private void publishCommon(JarOutputStream jarOutputStream, File[] fileArray, File[] fileArray2, AppletXml appletXml, JavacardXml javacardXml) throws IOException {
        if (javacardXml != null) {
            this.addJarEntry(jarOutputStream, "META-INF/javacard.xml", javacardXml);
        }
        if (fileArray != null) {
            if (appletXml != null) {
                this.addJarEntry(jarOutputStream, "APPLET-INF/applet.xml", appletXml);
                this.addJarEntry(jarOutputStream, "APPLET-INF/classes/" + this.packageName, fileArray);
                if (fileArray2 != null) {
                    this.addJarEntry(jarOutputStream, "APPLET-INF/classes/" + this.packageName + "/proxy", fileArray2);
                }
            } else {
                this.addJarEntry(jarOutputStream, this.packageName, fileArray);
                if (fileArray2 != null) {
                    this.addJarEntry(jarOutputStream, this.packageName + "/proxy", fileArray2);
                }
            }
        }
    }

    private Manifest getJarManifest(JCPackage jCPackage, Manifest manifest, boolean bl) throws IOException {
        Object object;
        Object object2;
        Manifest manifest2 = null;
        manifest2 = manifest == null ? new Manifest() : new Manifest(manifest);
        Attributes attributes = manifest2.getMainAttributes();
        String string = jCPackage.getName();
        Attributes attributes2 = manifest2.getAttributes(string);
        if (attributes2 == null) {
            attributes2 = new Attributes();
        }
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(CREATED_BY, System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        attributes.put(JCRD_VERSION, "3.0");
        if (bl) {
            attributes.put(APPLICATION_TYPE, "classic-applet");
            object2 = Strings.toAidURI(jCPackage.getIdentifier().getAid().toByteArray());
            attributes.put(CLASSIC_PKG_AID, object2);
        }
        attributes.put(SEALED, "true");
        object2 = new Date(this.timeStamp);
        attributes2.put(TIMESTAMP, ((Date)object2).toString());
        attributes2.put(CONVERTER_VERSION, ToolsVersion.getVersion(1));
        attributes2.put(CONVERTER_PROVIDER, "Sun Microsystems Inc.");
        if (jCPackage.is22Package()) {
            attributes2.put(CAP_FILE_VERSION, "2.2");
        } else {
            attributes2.put(CAP_FILE_VERSION, "2.1");
        }
        attributes2.put(PACKAGE_VERSION, jCPackage.getIdentifier().getMajorVersion() + "." + jCPackage.getIdentifier().getMinorVersion());
        attributes2.put(PACKAGE_NAME, jCPackage.getName().replace('/', '.'));
        attributes2.put(PACKAGE_AID, jCPackage.getIdentifier().getAid().toString());
        int n = 1;
        Enumeration<Object> enumeration = jCPackage.appletElements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            attributes2.put(new Attributes.Name("Java-Card-Applet-" + n + "-Name"), ((AppletDeclarator)object).getName());
            attributes2.put(new Attributes.Name("Java-Card-Applet-" + n + "-AID"), ((AppletDeclarator)object).getAid().toString());
            ++n;
        }
        n = 1;
        enumeration = jCPackage.importElements();
        while (enumeration.hasMoreElements()) {
            object = (PackageIdentifier)enumeration.nextElement();
            attributes2.put(new Attributes.Name("Java-Card-Imported-Package-" + n + "-AID"), ((PackageIdentifier)object).getAid().toString());
            attributes2.put(new Attributes.Name("Java-Card-Imported-Package-" + n + "-Version"), ((PackageIdentifier)object).getMajorVersion() + "." + ((PackageIdentifier)object).getMinorVersion());
            ++n;
        }
        if (jCPackage.usesIntegers()) {
            attributes2.put(INTEGER_SUPPORT, "TRUE");
        } else {
            attributes2.put(INTEGER_SUPPORT, "FALSE");
        }
        manifest2.getEntries().put(string, attributes2);
        return manifest2;
    }

    private void addJarEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Bad Data:" + jarEntry.getName());
        }
        JarEntry jarEntry2 = new JarEntry(jarEntry.getName());
        jarEntry2.setSize(byArray.length);
        jarEntry2.setTime(jarEntry.getTime());
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        jarEntry2.setCrc(cRC32.getValue());
        jarOutputStream.putNextEntry(jarEntry2);
        jarOutputStream.write(byArray, 0, byArray.length);
    }

    private void addJarEntry(JarOutputStream jarOutputStream, String string, Xml xml) throws IOException {
        byte[] byArray = xml.toByteArray();
        JarEntry jarEntry = new JarEntry(string);
        jarEntry.setSize(byArray.length);
        jarEntry.setTime(this.timeStamp);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        jarEntry.setCrc(cRC32.getValue());
        jarOutputStream.putNextEntry(jarEntry);
        jarOutputStream.write(byArray, 0, byArray.length);
    }

    private void addJarEntry(JarOutputStream jarOutputStream, String string, File[] fileArray) throws IOException {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.read(byArray);
            dataInputStream.close();
            String string2 = string + "/" + file.getName();
            JarEntry jarEntry = new JarEntry(string2);
            jarEntry.setSize(byArray.length);
            jarEntry.setTime(this.timeStamp);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray, 0, byArray.length);
            jarEntry.setCrc(cRC32.getValue());
            jarOutputStream.putNextEntry(jarEntry);
            jarOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void addJarEntry(JarOutputStream jarOutputStream, String string, Component component) throws IOException {
        byte[] byArray = component.toByteArray();
        if (byArray == null) {
            throw new NullPointerException("Bad Component:" + string);
        }
        JarEntry jarEntry = new JarEntry(this.packageName + "/javacard/" + string);
        jarEntry.setSize(byArray.length);
        jarEntry.setTime(this.timeStamp);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        jarEntry.setCrc(cRC32.getValue());
        jarOutputStream.putNextEntry(jarEntry);
        jarOutputStream.write(byArray, 0, byArray.length);
    }

    private void addJarEntry(JarOutputStream jarOutputStream, String string, byte[] byArray) throws IOException {
        JarEntry jarEntry = new JarEntry(this.packageName + "/javacard/" + string);
        jarEntry.setSize(byArray.length);
        jarEntry.setTime(this.timeStamp);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        jarEntry.setCrc(cRC32.getValue());
        jarOutputStream.putNextEntry(jarEntry);
        jarOutputStream.write(byArray, 0, byArray.length);
    }

    private byte[] mergeDebugOffsets(ClassComponent classComponent, MethodComponent methodComponent, StaticFieldComponent staticFieldComponent) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        classComponent.getDebugOffsets(hashtable);
        methodComponent.getDebugOffsets(hashtable);
        staticFieldComponent.getDebugOffsets(hashtable);
        try {
            if (Globals.outputDebugData != null) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(Globals.outputDebugData));
                this.mergeDebugComponent(dataInputStream, dataOutputStream, hashtable);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void mergeDebugComponent(DataInputStream dataInputStream, DataOutputStream dataOutputStream, Map<String, Integer> map) throws IOException {
        int n;
        dataOutputStream.writeByte(dataInputStream.readUnsignedByte());
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = dataInputStream.readUTF();
            dataOutputStream.writeUTF(stringArray[n]);
        }
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        int n3 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n3);
        for (n = 0; n < n3; ++n) {
            this.mergeClassDebugInfo(dataInputStream, dataOutputStream, stringArray, map);
        }
    }

    private void mergeClassDebugInfo(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String[] stringArray, Map<String, Integer> map) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        dataInputStream.readUnsignedShort();
        String string = stringArray[n2];
        Integer n3 = map.get(string);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        int n4 = dataInputStream.readUnsignedByte();
        dataOutputStream.writeByte(n4);
        int n5 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n5);
        int n6 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n6);
        for (n = 0; n < n4; ++n) {
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        }
        for (n = 0; n < n5; ++n) {
            this.mergeFieldDebugInfo(dataInputStream, dataOutputStream, stringArray, map, string);
        }
        for (n = 0; n < n6; ++n) {
            this.mergeMethodDebugInfo(dataInputStream, dataOutputStream, stringArray, map, string);
        }
    }

    private void mergeMethodDebugInfo(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String[] stringArray, Map<String, Integer> map, String string) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        int n3 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n3);
        int n4 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n4);
        boolean bl = (n4 & 0x400) != 0;
        dataInputStream.readUnsignedShort();
        if (bl) {
            dataOutputStream.writeShort(0);
        } else {
            String string2 = stringArray[n2];
            String string3 = stringArray[n3];
            String string4 = string + "/" + string2 + string3;
            Integer n5 = map.get(string4);
            dataOutputStream.writeShort(n5);
        }
        dataOutputStream.writeByte(dataInputStream.readUnsignedByte());
        dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        int n6 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n6);
        int n7 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n7);
        for (n = 0; n < n6; ++n) {
            dataOutputStream.writeByte(dataInputStream.readUnsignedByte());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        }
        for (n = 0; n < n7; ++n) {
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
        }
    }

    private void mergeFieldDebugInfo(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String[] stringArray, Map<String, Integer> map, String string) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n);
        int n2 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n2);
        int n3 = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n3);
        boolean bl = (n3 & 8) != 0;
        boolean bl2 = (n3 & 0x10) != 0;
        boolean bl3 = stringArray[n2].length() == 1;
        if (bl & !(bl2 & bl3)) {
            dataOutputStream.writeShort(dataInputStream.readUnsignedShort());
            dataInputStream.readUnsignedShort();
            String string2 = string + "/" + stringArray[n];
            Integer n4 = map.get(string2);
            dataOutputStream.writeShort(n4);
        } else {
            dataOutputStream.writeInt(dataInputStream.readInt());
        }
    }

    class JarEntryData {
        JarEntry je;
        byte[] data;

        JarEntryData() {
        }
    }
}

