/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.ui.top;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.cnd.asm.model.lang.AsmElement;
import org.netbeans.modules.cnd.asm.model.lang.AsmOffsetable;
import org.netbeans.modules.cnd.asm.model.lang.syntax.FunctionBoundsResolver;
import org.netbeans.modules.cnd.asm.model.util.DefaultOffsetable;
import org.netbeans.modules.cnd.asm.model.util.IntervalSet;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class NavigatorUI
extends JPanel
implements ExplorerManager.Provider {
    private static final Logger LOGGER = Logger.getLogger(NavigatorUI.class.getName());
    private final ListView navigatorPane;
    private final ExplorerManager explorerManager;

    public NavigatorUI() {
        this.initComponents();
        this.explorerManager = new ExplorerManager();
        this.navigatorPane = new ListView();
        this.navigatorPane.setDropTarget(false);
        this.navigatorPane.setDragSource(false);
        this.add((Component)this.navigatorPane, "Center");
        this.setEmpty();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void updateCursor(int pos) {
        Node[] nodes;
        Node root = this.explorerManager.getRootContext();
        for (Node node : nodes = root.getChildren().getNodes()) {
            AsmFunctionNode funcNode;
            if (!(node instanceof AsmFunctionNode) || !(funcNode = (AsmFunctionNode)node).isActive(pos)) continue;
            try {
                this.explorerManager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException ex) {
                LOGGER.info("PropertyVetoException exception");
            }
            return;
        }
    }

    public void update(DataObject dob, AsmState state) {
        this.setFunctions(dob, state);
    }

    private void setEmpty() {
        Children.Array ch = new Children.Array();
        AbstractNode node = new AbstractNode((Children)ch);
        this.explorerManager.setRootContext((Node)node);
    }

    private void setFunctions(DataObject dob, AsmState state) {
        FunctionBoundsResolver resolver = (FunctionBoundsResolver)state.getServices().lookup(FunctionBoundsResolver.class);
        if (resolver == null) {
            this.setEmpty();
            return;
        }
        IntervalSet<FunctionBoundsResolver.Entry> funcs = resolver.getFunctions();
        String fName = null;
        int startOffset = -1;
        int endOffset = -1;
        ArrayList<AsmFunctionNode> nodeList = new ArrayList<AsmFunctionNode>();
        for (FunctionBoundsResolver.Entry en : funcs) {
            List<AsmElement> comp = state.getElements().getCompounds();
            if (en.getName().equals(fName)) {
                endOffset = comp.get(en.getEndOffset()).getEndOffset();
                continue;
            }
            if (fName != null) {
                nodeList.add(new AsmFunctionNode(dob, fName, DefaultOffsetable.create(startOffset, endOffset)));
                fName = null;
            }
            fName = en.getName();
            startOffset = comp.get(en.getStartOffset()).getStartOffset();
            endOffset = comp.get(en.getEndOffset()).getEndOffset();
        }
        if (fName != null) {
            nodeList.add(new AsmFunctionNode(dob, fName, DefaultOffsetable.create(startOffset, endOffset)));
        }
        Node[] nodes = nodeList.toArray(new Node[nodeList.size()]);
        Children.Array ch = new Children.Array();
        ch.add(nodes);
        AbstractNode node = new AbstractNode((Children)ch);
        this.explorerManager.setRootContext((Node)node);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private static class AsmFunctionNode
    extends AbstractNode {
        private static final String FUNC_ICON = "org/netbeans/modules/cnd/asm/core/resources/function.png";
        private final AsmOffsetable off;
        private final DataObject dob;

        public AsmFunctionNode(DataObject dob, String name, AsmOffsetable off) {
            super(Children.LEAF, null);
            this.dob = dob;
            this.setName(name);
            this.off = off;
        }

        public boolean isActive(int pos) {
            return pos >= this.off.getStartOffset() && pos < this.off.getEndOffset();
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)FUNC_ICON);
        }

        public Action getPreferredAction() {
            return new GoToFunctionAction();
        }

        class GoToFunctionAction
        extends AbstractAction {
            public GoToFunctionAction() {
                this.putValue("Name", NbBundle.getMessage(GoToFunctionAction.class, (String)"LBL_GoToFunctionAction"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                AsmObjectUtilities.goToSource(AsmFunctionNode.this.dob, AsmFunctionNode.this.off.getStartOffset());
            }
        }
    }
}

