/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.kenai;

import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import org.netbeans.modules.subversion.kenai.KenaiNotificationListener;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.util.Lookup;

public class SvnKenaiAccessor {
    private static SvnKenaiAccessor instance;
    private VCSKenaiAccessor kenaiAccessor = (VCSKenaiAccessor)Lookup.getDefault().lookup(VCSKenaiAccessor.class);

    private SvnKenaiAccessor() {
    }

    public static SvnKenaiAccessor getInstance() {
        if (instance == null) {
            instance = new SvnKenaiAccessor();
        }
        return instance;
    }

    public boolean isKenai(String url) {
        return this.kenaiAccessor != null && this.kenaiAccessor.isKenai(url);
    }

    public PasswordAuthentication getPasswordAuthentication(String url, boolean forceRelogin) {
        return this.kenaiAccessor != null ? this.kenaiAccessor.getPasswordAuthentication(url, forceRelogin) : null;
    }

    public boolean showLogin() {
        return this.kenaiAccessor != null ? this.kenaiAccessor.showLogin() : false;
    }

    public boolean isOnline(String user) {
        return this.kenaiAccessor != null && this.kenaiAccessor.isUserOnline(user);
    }

    public VCSKenaiAccessor.KenaiUser forName(String user, String url) {
        return this.kenaiAccessor != null ? this.kenaiAccessor.forName(user, url) : null;
    }

    public boolean isLogged(String url) {
        return this.kenaiAccessor != null && this.kenaiAccessor.isLogged(url);
    }

    public String getRevisionUrl(String repositoryUrl, String revision) {
        return this.kenaiAccessor == null ? null : this.kenaiAccessor.getRevisionUrl(repositoryUrl, revision);
    }

    private void removeVCSNoficationListener(PropertyChangeListener l) {
        if (this.kenaiAccessor != null) {
            this.kenaiAccessor.removeVCSNoficationListener(l);
        }
    }

    private void addVCSNoficationListener(PropertyChangeListener l) {
        if (this.kenaiAccessor != null) {
            this.kenaiAccessor.addVCSNoficationListener(l);
        }
    }

    public void registerVCSNoficationListener() {
        if ("true".equals(System.getProperty("kenai.vcs.notifications.ignore"))) {
            return;
        }
        this.addVCSNoficationListener((PropertyChangeListener)((Object)new KenaiNotificationListener()));
    }

    public boolean canRead(String repositoryUrl) {
        return this.isAuthorized(repositoryUrl, VCSKenaiAccessor.RepositoryActivity.READ);
    }

    public boolean canWrite(String repositoryUrl) {
        return this.isAuthorized(repositoryUrl, VCSKenaiAccessor.RepositoryActivity.WRITE);
    }

    private boolean isAuthorized(String repositoryUrl, VCSKenaiAccessor.RepositoryActivity permission) {
        return this.kenaiAccessor == null || !this.kenaiAccessor.isLogged(repositoryUrl) || this.kenaiAccessor.isAuthorized(repositoryUrl, permission);
    }
}

