/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.tools.storage.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLHintPreferences
extends AbstractPreferences {
    private final HintPreferencesProviderImpl driver;
    private final Element parentNode;
    private final Element node;
    private boolean recordedInParent;
    private static final Map<URI, Reference<HintPreferencesProviderImpl>> uri2Cache = new HashMap<URI, Reference<HintPreferencesProviderImpl>>();
    private static final Logger LOG = Logger.getLogger(XMLHintPreferences.class.getName());

    private XMLHintPreferences(HintPreferencesProviderImpl driver, XMLHintPreferences parent, String nodeName, Element node, Element parentNode, boolean recordedInParent) {
        super(parent, nodeName);
        this.driver = driver;
        this.node = node;
        this.parentNode = parentNode;
        this.recordedInParent = recordedInParent;
    }

    private Element findAttribute(String key) {
        NodeList nl = this.node.getElementsByTagName("attribute");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element attribute = (Element)nl.item(i);
            if (!key.equals(XMLHintPreferences.resolve(attribute.getAttribute("name")))) continue;
            return attribute;
        }
        return null;
    }

    @Override
    protected void putSpi(String key, String value) {
        Element found = this.findAttribute(key);
        if (found == null) {
            found = this.node.getOwnerDocument().createElement("attribute");
            found.setAttribute("name", XMLHintPreferences.escape(key));
            this.node.appendChild(found);
        }
        found.setAttribute("value", value);
        this.ensureRecordedInParent();
        this.driver.writeNotify();
    }

    @Override
    protected String getSpi(String key) {
        Element found = this.findAttribute(key);
        return found != null ? found.getAttribute("value") : null;
    }

    @Override
    protected void removeSpi(String key) {
        Element found = this.findAttribute(key);
        this.node.removeChild(found);
        this.driver.writeNotify();
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.node.getParentNode().removeChild(this.node);
        this.driver.writeNotify();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        ArrayList<String> keys = new ArrayList<String>();
        NodeList nl = this.node.getElementsByTagName("attribute");
        for (int i = 0; i < nl.getLength(); ++i) {
            keys.add(XMLHintPreferences.resolve(((Element)nl.item(i)).getAttribute("name")));
        }
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        ArrayList<String> names = new ArrayList<String>();
        NodeList nl = this.node.getElementsByTagName("node");
        for (int i = 0; i < nl.getLength(); ++i) {
            names.add(XMLHintPreferences.resolve(((Element)nl.item(i)).getAttribute("name")));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        String escapedName = XMLHintPreferences.escape(name);
        NodeList nl = this.node.getElementsByTagName("node");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || !escapedName.equals(((Element)n).getAttribute("name"))) continue;
            return new XMLHintPreferences(this.driver, this, name, (Element)n, this.node, true);
        }
        Element nue = this.node.getOwnerDocument().createElement("node");
        nue.setAttribute("name", escapedName);
        return new XMLHintPreferences(this.driver, this, name, nue, this.node, false);
    }

    protected synchronized void ensureRecordedInParent() {
        if (this.recordedInParent) {
            return;
        }
        this.recordedInParent = true;
        Preferences parent = this.parent();
        if (parent instanceof XMLHintPreferences) {
            ((XMLHintPreferences)parent).ensureRecordedInParent();
        }
        this.parentNode.appendChild(this.node);
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }

    @Override
    public void flush() throws BackingStoreException {
        this.driver.save();
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        throw new IllegalStateException();
    }

    private static String escape(String what) {
        return what;
    }

    private static String resolve(String what) {
        return what;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HintPreferencesProviderImpl from(@NonNull URI settings) {
        HintPreferencesProviderImpl cachedResult;
        Reference<HintPreferencesProviderImpl> ref = uri2Cache.get(settings);
        HintPreferencesProviderImpl hintPreferencesProviderImpl = cachedResult = ref != null ? ref.get() : null;
        if (cachedResult != null) {
            return cachedResult;
        }
        Document doc = null;
        File file = Utilities.toFile((URI)settings);
        if (file.canRead()) {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                doc = XMLUtil.parse((InputSource)new InputSource(in), (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            }
            catch (IOException | SAXException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        if (doc == null) {
            doc = XMLUtil.createDocument((String)"configuration", null, (String)"-//NetBeans//DTD Tool Configuration 1.0//EN", (String)"http://www.netbeans.org/dtds/ToolConfiguration-1_0.dtd");
        }
        Map<URI, Reference<HintPreferencesProviderImpl>> map = uri2Cache;
        synchronized (map) {
            ref = uri2Cache.get(settings);
            HintPreferencesProviderImpl hintPreferencesProviderImpl2 = cachedResult = ref != null ? ref.get() : null;
            if (cachedResult != null) {
                return cachedResult;
            }
            cachedResult = new HintPreferencesProviderImpl(settings, doc);
            uri2Cache.put(settings, new CleaneableSoftReference(cachedResult, settings));
        }
        return cachedResult;
    }

    private static final class CleaneableSoftReference
    extends SoftReference<HintPreferencesProviderImpl>
    implements Runnable {
        private static URI settings;

        public CleaneableSoftReference(HintPreferencesProviderImpl referent, URI settings) {
            super(referent, Utilities.activeReferenceQueue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = uri2Cache;
            synchronized (map) {
                if (uri2Cache.get(settings) == this) {
                    uri2Cache.remove(settings);
                }
            }
        }
    }

    public static class HintPreferencesProviderImpl {
        private final URI settings;
        private final Document doc;
        private long modificationCount = 0L;
        private long lastSave = 0L;
        private static final RequestProcessor SAVER = new RequestProcessor(XMLHintPreferences.class.getName(), 1, false, false);
        private static final int SAVE_DELAY = 30000;

        public HintPreferencesProviderImpl(URI settings, Document doc) {
            this.settings = settings;
            this.doc = doc;
        }

        public Preferences getPreferences(String toolKind, String mimeType) {
            Element docEl = this.doc.getDocumentElement();
            NodeList nl = docEl.getElementsByTagName("tool");
            String escapedToolKind = XMLHintPreferences.escape(toolKind);
            String escapedMimeType = XMLHintPreferences.escape(mimeType);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                if (!escapedToolKind.equals(el.getAttribute("kind")) || !escapedMimeType.equals(el.getAttribute("type"))) continue;
                return new XMLHintPreferences(this, null, "", el, docEl, true);
            }
            Element el = this.doc.createElement("tool");
            el.setAttribute("kind", escapedToolKind);
            el.setAttribute("type", escapedMimeType);
            docEl.appendChild(el);
            return new XMLHintPreferences(this, null, "", el, docEl, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() {
            HintPreferencesProviderImpl hintPreferencesProviderImpl = this;
            synchronized (hintPreferencesProviderImpl) {
                if (this.lastSave >= this.modificationCount) {
                    return;
                }
                this.lastSave = this.modificationCount;
            }
            File file = Utilities.toFile((URI)this.settings);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                XMLUtil.write((Document)this.doc, (OutputStream)out, (String)"UTF-8");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private synchronized void writeNotify() {
            ++this.modificationCount;
            SAVER.post(new Runnable(){

                @Override
                public void run() {
                    HintPreferencesProviderImpl.this.save();
                }
            }, 30000);
        }
    }
}

