/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteProjectSupport;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.ServerListImplementation;
import org.netbeans.modules.cnd.spi.remote.setup.RemoteSyncFactoryDefaultProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class RemoteServerList
implements ServerListImplementation,
ConnectionListener {
    public static final boolean TRACE_SETUP = Boolean.getBoolean("cnd.remote.trace.setup");
    public static final String TRACE_SETUP_PREFIX = "#HostSetup";
    private static final String CND_REMOTE = "cnd.remote";
    private static final String REMOTE_SERVERS = "cnd.remote.servers";
    private static final String DEFAULT_RECORD = "cnd.remote.defaultEnv";
    private volatile RemoteServerRecord defaultRecord;
    private final PropertyChangeSupport pcs;
    private final ChangeSupport cs;
    private final CopyOnWriteArrayList<RemoteServerRecord> unlisted;
    private final CopyOnWriteArrayList<RemoteServerRecord> items;
    private final Object lock;
    private static final RequestProcessor RP = new RequestProcessor("Remote setup", 1);
    private static final Comparator<RemoteServerRecord> RECORDS_COMPARATOR = new Comparator<RemoteServerRecord>(){

        @Override
        public int compare(RemoteServerRecord o1, RemoteServerRecord o2) {
            boolean o2local;
            if (o1 == o2) {
                return 0;
            }
            boolean o1local = o1.getExecutionEnvironment().isLocal();
            if (o1local != (o2local = o2.getExecutionEnvironment().isLocal())) {
                if (o1local) {
                    return -1;
                }
                if (o2local) {
                    return 1;
                }
            }
            return o1.getServerName().compareTo(o2.getServerName());
        }
    };

    public RemoteServerList() {
        block4: {
            String defaultEnvId;
            block3: {
                this.unlisted = new CopyOnWriteArrayList();
                this.items = new CopyOnWriteArrayList();
                this.lock = new Object();
                this.pcs = new PropertyChangeSupport(this);
                this.cs = new ChangeSupport((Object)this);
                RemoteServerRecord localRecord = new RemoteServerRecord(ExecutionEnvironmentFactory.getLocal(), null, RemoteSyncFactory.getDefault(), false);
                localRecord.setState(RemoteServerRecord.State.ONLINE);
                this.items.add(localRecord);
                String slist = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
                if (slist != null) {
                    List<RemoteServerRecord> toAdd = RemoteServerRecord.fromString(slist);
                    for (RemoteServerRecord record : toAdd) {
                        record.setState(RemoteServerRecord.State.OFFLINE);
                        this.items.add(record);
                    }
                }
                this.defaultRecord = localRecord;
                defaultEnvId = RemoteServerList.getPreferences().get(DEFAULT_RECORD, null);
                if (defaultEnvId != null) break block3;
                int defaultIndex = RemoteServerList.getPreferences().getInt(".default", 0);
                if ((defaultIndex = Math.min(defaultIndex, this.items.size() - 1)) < 0) break block4;
                this.defaultRecord = this.items.get(defaultIndex);
                break block4;
            }
            ExecutionEnvironment defEnv = ExecutionEnvironmentFactory.fromUniqueID((String)defaultEnvId);
            for (RemoteServerRecord r : this.items) {
                if (!r.getExecutionEnvironment().equals((Object)defEnv)) continue;
                this.defaultRecord = r;
                break;
            }
        }
        this.refresh();
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)((Object)this), (Object)ConnectionManager.getInstance()));
    }

    public void connected(final ExecutionEnvironment env) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                RemoteServerList.this.checkSetup(env);
            }
        });
    }

    private void checkSetup(ExecutionEnvironment env) {
        block3: {
            ArrayList<RemoteServerRecord> recordsToNotify;
            block2: {
                RemoteServerRecord record;
                block4: {
                    recordsToNotify = new ArrayList<RemoteServerRecord>();
                    for (RemoteServerRecord rec : this.items) {
                        if (!rec.getExecutionEnvironment().equals((Object)env) || !rec.needsValidationOnConnect()) continue;
                        recordsToNotify.add(rec);
                    }
                    if (!recordsToNotify.isEmpty()) break block2;
                    record = this.get(env);
                    if (!record.needsValidationOnConnect()) break block3;
                    if (!record.isDeleted()) break block4;
                    this.addServer(record.getExecutionEnvironment(), record.getDisplayName(), record.getSyncFactory(), false, true);
                    break block3;
                }
                if (record.isOnline()) break block3;
                record.validate(true);
                break block3;
            }
            for (RemoteServerRecord rec : recordsToNotify) {
                rec.checkHostInfo();
            }
        }
    }

    public void disconnected(ExecutionEnvironment env) {
    }

    public RemoteServerRecord get(ExecutionEnvironment env) {
        return this.get(env, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteServerRecord get(ExecutionEnvironment env, boolean create) {
        for (RemoteServerRecord remoteServerRecord : this.items) {
            if (!env.equals((Object)remoteServerRecord.getExecutionEnvironment())) continue;
            return remoteServerRecord;
        }
        for (RemoteServerRecord remoteServerRecord : this.unlisted) {
            if (!env.equals((Object)remoteServerRecord.getExecutionEnvironment())) continue;
            return remoteServerRecord;
        }
        if (create) {
            Object object = this.lock;
            synchronized (object) {
                for (RemoteServerRecord record2 : this.items) {
                    if (!env.equals((Object)record2.getExecutionEnvironment())) continue;
                    return record2;
                }
                for (RemoteServerRecord record : this.unlisted) {
                    if (!env.equals((Object)record.getExecutionEnvironment())) continue;
                    return record;
                }
                RemoteServerRecord remoteServerRecord = new RemoteServerRecord(env, null, RemoteServerList.getDefaultFactory(env), false);
                this.unlisted.add(remoteServerRecord);
                return remoteServerRecord;
            }
        }
        return null;
    }

    @SuppressWarnings(value={"UG"})
    public ServerRecord get(Project project) {
        ExecutionEnvironment execEnv = RemoteProjectSupport.getExecutionEnvironment((Lookup.Provider)project);
        if (execEnv != null) {
            return this.get(execEnv);
        }
        return null;
    }

    public ServerRecord getDefaultRecord() {
        return this.defaultRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRecord(ServerRecord record) {
        assert (record != null);
        CndUtils.assertNonUiThread();
        Object object = this.lock;
        synchronized (object) {
            for (RemoteServerRecord r : this.items) {
                if (!r.equals(record)) continue;
                RemoteServerRecord old = this.defaultRecord;
                this.defaultRecord = r;
                RemoteServerList.getPreferences().put(DEFAULT_RECORD, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.defaultRecord.getExecutionEnvironment()));
                this.firePropertyChange("DEFAULT_RECORD", old, r);
                return;
            }
        }
        CndUtils.assertTrue((boolean)false, (String)"Can not set nonexistent record as default");
    }

    public List<ExecutionEnvironment> getEnvironments() {
        ArrayList<ExecutionEnvironment> result = new ArrayList<ExecutionEnvironment>(this.items.size());
        for (RemoteServerRecord item : this.items) {
            result.add(item.getExecutionEnvironment());
        }
        return result;
    }

    public ServerRecord addServer(ExecutionEnvironment execEnv, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, boolean connect) {
        CndUtils.assertNonUiThread();
        return this.addServerImpl(execEnv, displayName, syncFactory, asDefault, connect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerRecord addServerImpl(ExecutionEnvironment execEnv, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, boolean connect, boolean fireChanges) {
        Object object = this.lock;
        synchronized (object) {
            RemoteServerRecord record = null;
            if (syncFactory == null) {
                syncFactory = RemoteServerList.getDefaultFactory(execEnv);
            }
            for (RemoteServerRecord r : this.items) {
                if (!r.getExecutionEnvironment().equals((Object)execEnv)) continue;
                if (asDefault) {
                    this.defaultRecord = r;
                    RemoteServerList.getPreferences().put(DEFAULT_RECORD, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.defaultRecord.getExecutionEnvironment()));
                }
                return r;
            }
            for (RemoteServerRecord r : this.unlisted) {
                if (!r.getExecutionEnvironment().equals((Object)execEnv)) continue;
                record = r;
                break;
            }
            if (record == null) {
                record = new RemoteServerRecord(execEnv, displayName, syncFactory, connect);
            } else {
                record.setDeleted(false);
                record.setDisplayName(displayName);
                record.setSyncFactory(syncFactory);
                this.unlisted.remove(record);
            }
            ArrayList<RemoteServerRecord> oldItems = new ArrayList<RemoteServerRecord>(this.items);
            RemoteServerList.insert(this.items, record, RECORDS_COMPARATOR);
            if (asDefault) {
                this.defaultRecord = record;
            }
            if (fireChanges) {
                this.refresh();
                RemoteServerList.storePreferences();
                RemoteServerList.getPreferences().put(DEFAULT_RECORD, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.defaultRecord.getExecutionEnvironment()));
                this.firePropertyChange("RECORD_LIST", oldItems, new ArrayList<RemoteServerRecord>(this.items));
            }
            return record;
        }
    }

    private static <T> void insert(List<T> list, T value, Comparator<T> comparator) {
        for (int i = 0; i < list.size(); ++i) {
            T curr = list.get(i);
            int comparison = comparator.compare(curr, value);
            if (comparison < 0) continue;
            int sz = list.size();
            for (int j = sz - 1; j >= i; --j) {
                if (j == sz - 1) {
                    list.add(list.get(j));
                    continue;
                }
                list.set(j + 1, list.get(j));
            }
            list.set(i, value);
            return;
        }
        list.add(value);
    }

    public static RemoteServerList getInstance() {
        RemoteServerList instance = null;
        for (ServerListImplementation inst : Lookup.getDefault().lookupAll(ServerListImplementation.class)) {
            if (!(inst instanceof RemoteServerList)) continue;
            instance = (RemoteServerList)inst;
            break;
        }
        return instance;
    }

    public static RemoteSyncFactory getDefaultFactory(ExecutionEnvironment env) {
        RemoteSyncFactoryDefaultProvider rsfdp = (RemoteSyncFactoryDefaultProvider)Lookup.getDefault().lookup(RemoteSyncFactoryDefaultProvider.class);
        if (rsfdp != null) {
            return rsfdp.getDefaultFactory(env);
        }
        return RemoteSyncFactory.getDefault();
    }

    public static void storePreferences() {
        RemoteServerList instance = RemoteServerList.getInstance();
        if (instance == null) {
            RemoteUtil.LOGGER.warning("Can not find RemoteServerList instance");
            return;
        }
        ArrayList<RemoteServerRecord> records = new ArrayList<RemoteServerRecord>();
        for (RemoteServerRecord record : instance.items) {
            if (!record.isRemote()) continue;
            records.add(record);
        }
        RemoteServerList.getPreferences().put(REMOTE_SERVERS, RemoteServerRecord.toString(records));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(List<ServerRecord> records, ServerRecord defaultRecord) {
        CndUtils.assertNonUiThread();
        Object object = this.lock;
        synchronized (object) {
            ArrayList<RemoteServerRecord> oldItems = new ArrayList<RemoteServerRecord>(this.items);
            RemoteUtil.LOGGER.log(Level.FINEST, "ServerList: set {0}", records);
            Collection<ExecutionEnvironment> removed = this.clear();
            ArrayList<ExecutionEnvironment> allEnv = new ArrayList<ExecutionEnvironment>();
            for (ServerRecord rec : records) {
                this.addServerImpl(rec.getExecutionEnvironment(), rec.getDisplayName(), rec.getSyncFactory(), false, false, false);
                removed.remove(rec.getExecutionEnvironment());
                allEnv.add(rec.getExecutionEnvironment());
            }
            this.setDefaultRecord(defaultRecord);
            this.refresh();
            RemoteServerList.storePreferences();
            PasswordManager.getInstance().setServerList(allEnv);
            this.firePropertyChange("RECORD_LIST", oldItems, new ArrayList<RemoteServerRecord>(this.items));
        }
    }

    public void save() {
        this.unlisted.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ExecutionEnvironment> clear() {
        ArrayList<ExecutionEnvironment> removed = new ArrayList<ExecutionEnvironment>();
        CndUtils.assertNonUiThread();
        Object object = this.lock;
        synchronized (object) {
            for (RemoteServerRecord record : this.items) {
                record.setDeleted(true);
                removed.add(record.getExecutionEnvironment());
            }
            RemoteServerList.getPreferences().remove(REMOTE_SERVERS);
            this.unlisted.addAll(this.items);
            this.items.clear();
        }
        return removed;
    }

    private void refresh() {
        this.cs.fireChange();
    }

    public RemoteServerRecord getLocalhostRecord() {
        return this.items.get(0);
    }

    public boolean isValidExecutable(ExecutionEnvironment env, String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            RemoteUtil.LOGGER.warning("RemoteServerList.isValidExecutable from EDT");
        }
        if (!CndPathUtilities.isPathAbsolute((CharSequence)path)) {
            if (RemoteUtil.isWindows(env) ? path.contains("\\") || path.contains("/") : path.contains("/")) {
                return false;
            }
            ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)env, (String)"/usr/bin/which", (String[])new String[]{path});
            if (res.isOK()) {
                path = res.getOutputString();
            } else {
                return false;
            }
        }
        try {
            FileInfoProvider.StatInfo info = (FileInfoProvider.StatInfo)FileInfoProvider.stat((ExecutionEnvironment)env, (String)path).get();
            return info.canExecute(env);
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (ExecutionException ex) {
            RemoteUtil.LOGGER.log(Level.FINE, ex.getMessage(), ex);
            return false;
        }
    }

    public Collection<? extends ServerRecord> getRecords() {
        return new ArrayList<RemoteServerRecord>(this.items);
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(property, oldValue, newValue);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(RemoteServerList.class);
    }

    public ServerRecord createServerRecord(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory) {
        return new RemoteServerRecord(env, displayName, syncFactory, false);
    }
}

