/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.FlushVisitor;
import org.netbeans.modules.xml.xdm.visitor.Utils;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class Element
extends NodeImpl
implements Node,
org.w3c.dom.Element {
    private String tagName = null;

    Element() {
    }

    Element(String tagName) {
        List<Token> tokens = this.getTokensForWrite();
        tokens.add(Token.create("<".concat(tagName), TokenType.TOKEN_ELEMENT_START_TAG));
        tokens.add(Token.create("/>", TokenType.TOKEN_ELEMENT_END_TAG));
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public void accept(XMLNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getTagName() {
        if (this.tagName == null) {
            for (Token token : this.getTokens()) {
                if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
                this.tagName = token.getValue().substring(1);
                break;
            }
        }
        return this.tagName;
    }

    public void setTagName(String tagName) {
        assert (tagName != null && !"".equals(tagName));
        this.checkNotInTree();
        this.tagName = tagName;
        int tokenIndex = -1;
        for (Token token : this.getTokens()) {
            ++tokenIndex;
            if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
            String oldImage = token.getValue();
            String image = oldImage.startsWith("</") ? "</".concat(tagName) : "<".concat(tagName);
            Token newToken = Token.create(image, TokenType.TOKEN_ELEMENT_START_TAG);
            this.getTokensForWrite().set(tokenIndex, newToken);
        }
    }

    @Override
    public String getPrefix() {
        int idx;
        String qName = this.getTagName();
        if (qName != null && (idx = qName.indexOf(58)) > 0) {
            return qName.substring(0, idx);
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix) {
        String localName = this.getLocalName();
        if (prefix == null || prefix.equals("")) {
            this.setTagName(localName);
        } else {
            this.setTagName(prefix.concat(":").concat(localName));
        }
    }

    @Override
    public String getLocalName() {
        int idx;
        String qName = this.getTagName();
        if (qName != null && (idx = qName.indexOf(58) + 1) > 0) {
            return qName.substring(idx);
        }
        return qName;
    }

    public void setLocalName(String localName) {
        String prefix = this.getPrefix();
        if (prefix == null) {
            this.setTagName(localName);
        } else if (localName == null || localName.equals("")) {
            this.setTagName(prefix);
        } else {
            this.setTagName(prefix.concat(":").concat(localName));
        }
    }

    @Override
    void setTokens(List<Token> newTokens) {
        this.tagName = null;
        super.setTokens(newTokens);
    }

    @Override
    public String getAttribute(String name) {
        Attribute attribute = this.getAttributeNode(name);
        return attribute != null ? attribute.getValue() : "";
    }

    @Override
    public Attribute getAttributeNode(String name) {
        for (Attribute attr : this.getAttributesForRead()) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        Attribute attribute = this.getAttributeNodeNS(namespaceURI, localName);
        return attribute != null ? attribute.getValue() : null;
    }

    @Override
    public Attribute getAttributeNodeNS(String namespaceURI, String localName) {
        String prefix = this.lookupPrefix(namespaceURI);
        String qualifiedName = localName;
        if (prefix != null && !prefix.equals("")) {
            qualifiedName = prefix + ":" + localName;
        }
        return this.getAttributeNode(qualifiedName);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    @Override
    public void setAttribute(String name, String value) {
        this.checkNotInTree();
        Attribute oldAttr = this.getAttributeNode(name);
        if (oldAttr != null) {
            if (!oldAttr.isInTree()) {
                oldAttr.setValue(value);
            } else {
                Attribute newAttr = (Attribute)oldAttr.clone(true, false, false);
                newAttr.setValue(value);
                int index = this.getAttributesForRead().indexOf(oldAttr);
                this.getAttributesForWrite().set(index, newAttr);
            }
        } else {
            Attribute attribute = new Attribute(name, value);
            this.getAttributesForWrite().add(attribute);
        }
    }

    @Override
    public Attribute setAttributeNode(Attr newAttr) {
        this.checkNotInTree();
        if (newAttr instanceof Attribute) {
            Attribute attribute = (Attribute)newAttr;
            Attribute oldAttr = this.getAttributeNode(newAttr.getName());
            if (oldAttr == null) {
                this.getAttributesForWrite().add(attribute);
                return attribute;
            }
            int index = this.getAttributesForRead().indexOf(oldAttr);
            return this.getAttributesForWrite().set(index, attribute);
        }
        throw new DOMException(17, null);
    }

    @Override
    public void removeAttribute(String name) {
        Attribute attribute = this.getAttributeNode(name);
        this.removeAttributeNode(attribute);
    }

    @Override
    public Attribute removeAttributeNode(Attr oldAttr) {
        this.checkNotInTree();
        this.getAttributesForWrite().remove(oldAttr);
        return (Attribute)oldAttr;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.checkNotInTree();
        Attribute oldAttr = this.getAttributeNodeNS(namespaceURI, qualifiedName);
        if (oldAttr != null) {
            if (!oldAttr.isInTree()) {
                oldAttr.setValue(value);
            } else {
                Attribute newAttr = (Attribute)oldAttr.clone(true, false, false);
                newAttr.setValue(value);
                int index = this.getAttributesForRead().indexOf(oldAttr);
                this.getAttributesForWrite().set(index, newAttr);
            }
        } else {
            String prefix = this.lookupPrefix(namespaceURI);
            String name = qualifiedName;
            if (prefix != null && !prefix.equals("")) {
                name = prefix + ":" + qualifiedName;
            }
            Attribute attribute = new Attribute(name, value);
            this.getAttributesForWrite().add(attribute);
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttributeNode(this.getAttributeNodeNS(namespaceURI, localName));
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        NodeList nl = this.getChildNodes();
        ArrayList<Element> l = new ArrayList<Element>(nl.getLength());
        boolean matchesAll = "*".equals(name);
        for (int i = 0; i < nl.getLength(); ++i) {
            boolean matchesValue;
            org.w3c.dom.Node n = nl.item(i);
            boolean bl = matchesValue = n instanceof Element && (matchesAll || n.getNodeName().equals(name));
            if (!matchesValue) continue;
            l.add((Element)n);
        }
        return new NodeListImpl(l);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
    }

    @Override
    public void setIdAttribute(String name, boolean isId) {
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void replaceAttribute(Attribute newAttr, Attribute oldAttr) {
        this.checkNotInTree();
        List<Attribute> attributes = this.getAttributesForRead();
        int index = attributes.indexOf(oldAttr);
        assert (newAttr != null && index > -1);
        newAttr.checkNotInTree();
        this.getAttributesForWrite().set(attributes.indexOf(oldAttr), newAttr);
    }

    public void addAttribute(Attribute newAttr, int index) {
        this.checkNotInTree();
        assert (newAttr != null);
        newAttr.checkNotInTree();
        this.getAttributesForWrite().add(index, newAttr);
    }

    public void reorderAttribute(Attribute attr, int index) {
        this.checkNotInTree();
        if (!attr.isInTree()) {
            throw new IllegalArgumentException("Node is not in tree");
        }
        if (!this.getAttributesForWrite().remove(attr)) {
            throw new IllegalArgumentException("Node is not in children");
        }
        this.getAttributesForWrite().add(index, attr);
    }

    public void reorderAttribute(int[] permutation) {
        this.checkNotInTree();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(this.getAttributesForRead());
        if (permutation.length != attrs.size()) {
            throw new IllegalArgumentException("Permutation length: " + permutation.length + " " + "is different than children size: " + attrs.size());
        }
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute child = (Attribute)attrs.get(i);
            this.getAttributesForWrite().set(permutation[i], child);
        }
    }

    public void appendAttribute(Attribute newAttr) {
        this.checkNotInTree();
        assert (newAttr != null);
        newAttr.checkNotInTree();
        this.getAttributesForWrite().add(newAttr);
    }

    @Override
    public Node appendChild(org.w3c.dom.Node node) {
        boolean consolidateNamespace = this.getModel() == null || this.getModel().getStatus() != XDMModel.Status.PARSING;
        return this.appendChild(node, consolidateNamespace);
    }

    public Node appendChild(org.w3c.dom.Node node, boolean consolidateNamespaces) {
        boolean selfClosingElement = this.getChildNodes().getLength() == 0 && this.isStartTagSelfClosing();
        Node n = super.appendChild(node);
        if (selfClosingElement) {
            Token endToken = this.getEndToken();
            assert (endToken != null);
            List<Token> tokens = this.getTokensForWrite();
            int endPosition = tokens.indexOf(endToken);
            assert (endPosition != -1);
            tokens.set(endPosition, Token.create(">", TokenType.TOKEN_ELEMENT_END_TAG));
            tokens.add(Token.create("</" + this.getTagName(), TokenType.TOKEN_ELEMENT_START_TAG));
            tokens.add(Token.create(">", TokenType.TOKEN_ELEMENT_END_TAG));
        }
        if (n instanceof Element && consolidateNamespaces) {
            this.consolidateNamespaces((Element)n);
        }
        return n;
    }

    @Override
    public Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        Node n = super.insertBefore(newChild, refChild);
        if (n instanceof Element && (this.getModel() == null || this.getModel().getStatus() != XDMModel.Status.PARSING)) {
            this.consolidateNamespaces((Element)n);
        }
        return n;
    }

    private Token getEndToken() {
        Token endToken = null;
        for (Token t : this.getTokens()) {
            if (!t.getType().equals((Object)TokenType.TOKEN_ELEMENT_END_TAG)) continue;
            endToken = t;
            break;
        }
        return endToken;
    }

    private boolean isStartTagSelfClosing() {
        boolean selfClosing = false;
        for (Token t : this.getTokens()) {
            if (!t.getType().equals((Object)TokenType.TOKEN_ELEMENT_END_TAG)) continue;
            selfClosing = t.getValue().equals(Token.create("/>", TokenType.TOKEN_ELEMENT_END_TAG).getValue());
        }
        return selfClosing;
    }

    public String getXmlFragmentText() {
        return new FlushVisitor().flush(this.getChildNodes());
    }

    public void setXmlFragmentText(String text) throws IOException {
        while (this.hasChildNodes()) {
            this.removeChild(this.getFirstChild());
        }
        NodeList children = Utils.parseFragment(text);
        for (int i = 0; i < children.getLength(); ++i) {
            this.appendChild(children.item(i));
        }
    }

    private void consolidateNamespaces(Element newChild) {
        String namespace;
        String prefix;
        Attribute attr;
        int i;
        if (this.getModel() != null) {
            return;
        }
        String parentNamespace = this.getNamespaceURI();
        if (parentNamespace != null && parentNamespace.equals(newChild.getNamespaceURI())) {
            newChild.setPrefix(this.getPrefix());
        }
        List<Attribute> attributes = newChild.getAttributesForRead();
        ArrayList<String> sparedPrefixes = new ArrayList<String>();
        for (i = 0; i < attributes.size(); ++i) {
            String value;
            String[] parts;
            attr = attributes.get(i);
            if (attr.isXmlnsAttribute()) continue;
            prefix = attr.getPrefix();
            if (prefix != null) {
                namespace = newChild.lookupNamespaceURI(prefix);
                if (namespace == null) continue;
                String newPrefix = this.lookupPrefix(namespace);
                if (newPrefix == null || newPrefix.equals("")) {
                    sparedPrefixes.add(prefix);
                } else if (!newPrefix.equals(prefix)) {
                    if (newChild.lookupNamespaceURI(newPrefix) != null) {
                        sparedPrefixes.add(prefix);
                    } else {
                        attr.setPrefix(newPrefix);
                    }
                }
            }
            if ((parts = (value = attr.getValue().trim()).split(":")).length <= 1) continue;
            sparedPrefixes.add(parts[0]);
        }
        for (i = 0; i < attributes.size(); ++i) {
            attr = attributes.get(i);
            if (!attr.isXmlnsAttribute() || sparedPrefixes.contains(prefix = attr.getLocalName())) continue;
            if ("xmlns".equals(prefix)) {
                prefix = "";
            }
            namespace = attr.getValue();
            assert (namespace != null);
            String existingNS = this.lookupNamespaceURI(prefix);
            String existingPrefix = this.lookupPrefix(namespace);
            if (existingNS == null && existingPrefix == null) {
                newChild.removeAttributeNode(attr);
                this.appendAttribute(attr);
                continue;
            }
            if (namespace.equals(existingNS) && prefix.equals(existingPrefix)) {
                newChild.removeAttributeNode(attr);
                continue;
            }
            if (existingPrefix == null) continue;
            newChild.removeAttributeNode(attr);
        }
    }

    @Override
    public Element cloneNode(boolean deep, boolean cloneNamespacePrefix) {
        Document root = this.isInTree() ? (Document)this.getOwnerDocument() : null;
        Map<Integer, String> allNamespaces = null;
        if (root != null && cloneNamespacePrefix) {
            allNamespaces = root.getNamespaceMap();
        }
        HashMap<String, String> clonePrefixes = new HashMap<String, String>();
        Element clone = (Element)super.cloneNode(deep, allNamespaces, clonePrefixes);
        for (Map.Entry e : clonePrefixes.entrySet()) {
            String prefix = (String)e.getKey();
            String attr = prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
            Attribute attrNode = new Attribute(attr, (String)e.getValue());
            clone.setAttributeNode(attrNode);
        }
        return clone;
    }

    protected void cloneNamespacePrefix(Map<Integer, String> allNS, Map<String, String> prefixes) {
        if (allNS == null) {
            return;
        }
        String namespace = allNS.get(this.getId());
        if (namespace == null) {
            return;
        }
        String prefix = this.getPrefix();
        if (prefix == null && this.getAttributeNode("xmlns") != null) {
            prefix = "";
        }
        if (prefix != null) {
            prefixes.put(prefix, namespace);
        }
    }
}

