/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.async;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class DefaultAsyncExecutor
implements AsyncExecutor {
    private static final String ASYNC_FILTER = "com.sun.enterprise.web.connector.grizzly.asyncFilters";
    private AsyncTask asyncProcessorTask;
    private ProcessorTask processorTask;
    private static String[] sharedAsyncFilters = null;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private boolean invokeFilter = true;
    private AsyncHandler asyncHandler;

    public DefaultAsyncExecutor() {
        this.init();
    }

    private void init() {
        if (sharedAsyncFilters != null) {
            for (String filterName : sharedAsyncFilters) {
                this.asyncFilters.add(DefaultAsyncExecutor.loadInstance(filterName));
            }
        }
    }

    public boolean preExecute() throws Exception {
        this.processorTask = this.asyncProcessorTask.getProcessorTask();
        if (this.processorTask == null) {
            throw new IllegalStateException("Null ProcessorTask");
        }
        this.processorTask.preProcess();
        this.processorTask.parseRequest();
        return true;
    }

    public boolean interrupt() throws Exception {
        if (this.asyncFilters == null || this.asyncFilters.size() == 0) {
            this.execute();
            return false;
        }
        this.asyncHandler.addToInterruptedQueue(this.asyncProcessorTask);
        return this.invokeFilters();
    }

    public boolean execute() throws Exception {
        this.processorTask.invokeAdapter();
        return true;
    }

    private boolean invokeFilters() {
        AsyncFilter asf;
        boolean continueExec = true;
        Iterator<AsyncFilter> i$ = this.asyncFilters.iterator();
        while (i$.hasNext() && (continueExec = (asf = i$.next()).doFilter(this))) {
        }
        return continueExec;
    }

    public boolean postExecute() throws Exception {
        this.processorTask.postResponse();
        this.processorTask.postProcess();
        this.processorTask.terminateProcess();
        this.processorTask = null;
        return false;
    }

    public void setAsyncTask(AsyncTask asyncProcessorTask) {
        this.asyncProcessorTask = asyncProcessorTask;
    }

    public AsyncTask getAsyncTask() {
        return this.asyncProcessorTask;
    }

    protected static void loadFilters() {
        if (System.getProperty(ASYNC_FILTER) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(ASYNC_FILTER), ",");
            sharedAsyncFilters = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                DefaultAsyncExecutor.sharedAsyncFilters[i++] = st.nextToken();
            }
        }
    }

    private static AsyncFilter loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property);
            return (AsyncFilter)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            SelectorThread.logger().log(Level.WARNING, ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            SelectorThread.logger().log(Level.WARNING, ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            SelectorThread.logger().log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    static {
        DefaultAsyncExecutor.loadFilters();
    }
}

