/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.annotations.common.CheckReturnValue;

public final class ProgressObjectSupport {
    private ProgressObjectSupport() {
    }

    @CheckReturnValue
    public static boolean waitFor(ProgressObject obj) {
        final CountDownLatch latch = new CountDownLatch(1);
        obj.addProgressListener(new ProgressListener(){

            public void handleProgressEvent(ProgressEvent pe) {
                if (pe.getDeploymentStatus().isCompleted() || pe.getDeploymentStatus().isFailed()) {
                    latch.countDown();
                }
            }
        });
        if (obj.getDeploymentStatus().isCompleted() || obj.getDeploymentStatus().isFailed()) {
            return true;
        }
        try {
            return latch.await(60000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

