/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIComponentFactory;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.DatatypeBuilder;
import org.netbeans.modules.xml.axi.impl.ElementImpl;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.Cardinality;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public class Util {
    private Util() {
    }

    public static void moveChildren(AXIComponent oldParent, AXIComponent newParent) {
        ArrayList<AXIComponent> children = new ArrayList<AXIComponent>();
        for (AXIComponent c : oldParent.getChildren()) {
            children.add(c);
        }
        for (AXIComponent c : children) {
            oldParent.removeChild(c);
            newParent.appendChild(c);
        }
    }

    public static void addProxyChildren(AXIComponent parent, AXIComponent shared, List<AXIComponent> children) {
        for (AXIComponent child : shared.getChildren()) {
            AXIComponentFactory factory = parent.getModel().getComponentFactory();
            AXIComponent proxy = factory.createProxy(child);
            if (children != null) {
                children.add(proxy);
                continue;
            }
            parent.appendChild(proxy);
        }
        if (shared instanceof ContentModel) {
            shared.addListener(parent);
        }
    }

    public static AXIComponent lookup(AXIModel axiModel, SchemaComponent gsc) {
        AXIModelImpl model = (AXIModelImpl)axiModel;
        if (model.fromSameSchemaModel(gsc)) {
            return model.lookup(gsc);
        }
        return model.lookupFromOtherModel(gsc);
    }

    public static boolean canSetType(AXIType oldValue, AXIType newValue) {
        if (oldValue == newValue) {
            return false;
        }
        if (oldValue instanceof Datatype && newValue instanceof Datatype && ((Datatype)oldValue).getKind() == ((Datatype)newValue).getKind()) {
            return false;
        }
        if (oldValue instanceof ElementImpl.AnonymousType && newValue instanceof ElementImpl.AnonymousType && ((ElementImpl.AnonymousType)oldValue).getPeer() == ((ElementImpl.AnonymousType)newValue).getPeer()) {
            return false;
        }
        return !(oldValue instanceof ContentModel) || !(newValue instanceof ContentModel) || ((ContentModel)oldValue).getPeer() != ((ContentModel)newValue).getPeer();
    }

    public static SchemaComponent getSchemaType(AXIModelImpl model, SchemaComponent schemaComponent) {
        if (schemaComponent instanceof GlobalElement) {
            GlobalElement ge = (GlobalElement)schemaComponent;
            NamedComponentReference ref = ge.getType();
            if (ref != null) {
                SchemaComponent sc = model.getReferenceableSchemaComponent(ref);
                if (sc != null) {
                    return sc;
                }
                return (SchemaComponent)ref.get();
            }
            return ge.getInlineType();
        }
        if (schemaComponent instanceof LocalElement) {
            LocalElement le = (LocalElement)schemaComponent;
            NamedComponentReference ref = le.getType();
            if (ref != null) {
                SchemaComponent sc = model.getReferenceableSchemaComponent(ref);
                if (sc != null) {
                    return sc;
                }
                return (SchemaComponent)ref.get();
            }
            return le.getInlineType();
        }
        return null;
    }

    public static AXIType getAXIType(Element element, SchemaComponent type) {
        if (type == null) {
            return null;
        }
        if (type instanceof SimpleType) {
            DatatypeBuilder builder = new DatatypeBuilder(element.getModel());
            return builder.getDatatype(element.getPeer());
        }
        if (type instanceof LocalComplexType) {
            return new ElementImpl.AnonymousType(type);
        }
        if (type instanceof GlobalComplexType) {
            AXIModelImpl modelImpl = (AXIModelImpl)element.getModel();
            return (ContentModel)Util.lookup(modelImpl, type);
        }
        return null;
    }

    public static String getProperty(AXIComponent child) {
        if (child instanceof Compositor) {
            return "compositor";
        }
        if (child instanceof AbstractElement) {
            return "element";
        }
        if (child instanceof AbstractAttribute) {
            return "attribute";
        }
        if (child instanceof ContentModel) {
            return "contentModel";
        }
        return null;
    }

    public static Datatype getDatatype(AXIModel model, SchemaComponent component) {
        DatatypeBuilder builder = new DatatypeBuilder(model);
        return builder.getDatatype(component);
    }

    public static void updateAnyElement(AnyElement element) {
        org.netbeans.modules.xml.schema.model.AnyElement any = (org.netbeans.modules.xml.schema.model.AnyElement)element.getPeer();
        element.setMinOccurs(String.valueOf(any.getMinOccursEffective()));
        element.setMaxOccurs(any.getMaxOccursEffective());
        element.setTargetNamespace(any.getNameSpaceEffective());
        element.setProcessContents(any.getProcessContentsEffective());
    }

    public static void updateAnyAttribute(AnyAttribute attribute) {
        org.netbeans.modules.xml.schema.model.AnyAttribute anyAttr = (org.netbeans.modules.xml.schema.model.AnyAttribute)attribute.getPeer();
        attribute.setProcessContents(anyAttr.getProcessContentsEffective());
        attribute.setTargetNamespace(anyAttr.getNameSpaceEffective());
    }

    public static void updateAXIDocument(AXIDocument document) {
        Schema schema = (Schema)document.getPeer();
        document.setTargetNamespace(schema.getTargetNamespace());
        document.setVersion(schema.getVersion());
        document.setLanguage(schema.getLanguage());
        document.setAttributeFormDefault(schema.getAttributeFormDefaultEffective());
        document.setElementFormDefault(schema.getElementFormDefaultEffective());
    }

    public static void updateGlobalAttribute(Attribute attribute) {
        GlobalAttribute component = (GlobalAttribute)attribute.getPeer();
        attribute.setName(component.getName());
        attribute.setDefault(component.getDefault());
        attribute.setFixed(component.getFixed());
    }

    public static void updateLocalAttribute(Attribute attribute) {
        LocalAttribute component = (LocalAttribute)attribute.getPeer();
        attribute.setName(component.getName());
        attribute.setDefault(component.getDefault());
        attribute.setFixed(component.getFixed());
        attribute.setForm(component.getFormEffective());
        attribute.setUse(component.getUseEffective());
    }

    public static void updateAttributeReference(Attribute attribute) {
        AttributeReference component = (AttributeReference)attribute.getPeer();
        attribute.setDefault(component.getDefault());
        attribute.setFixed(component.getFixed());
        attribute.setUse(component.getUseEffective());
    }

    public static void updateGlobalElement(Element element) {
        GlobalElement component = (GlobalElement)element.getPeer();
        element.setName(component.getName());
        element.setFixed(component.getFixed());
        element.setDefault(component.getDefault());
        element.setAbstract(component.getAbstractEffective());
        element.setNillable(component.getNillableEffective());
    }

    public static void updateLocalElement(Element element) {
        LocalElement component = (LocalElement)element.getPeer();
        element.setName(component.getName());
        element.setMaxOccurs(component.getMaxOccursEffective());
        element.setMinOccurs(String.valueOf(component.getMinOccursEffective()));
        element.setFixed(component.getFixed());
        element.setDefault(component.getDefault());
        element.setNillable(component.getNillableEffective());
        element.setForm(component.getFormEffective());
    }

    public static void updateElementReference(Element elementRef) {
        ElementReference component = (ElementReference)elementRef.getPeer();
        elementRef.setMaxOccurs(component.getMaxOccursEffective());
        elementRef.setMinOccurs(String.valueOf(component.getMinOccursEffective()));
    }

    public static void updateCompositor(Compositor compositor) {
        switch (compositor.getType()) {
            case SEQUENCE: {
                Sequence component = (Sequence)compositor.getPeer();
                Cardinality c = component.getCardinality();
                if (c != null) {
                    compositor.setMaxOccurs(c.getMaxOccursEffective());
                    compositor.setMinOccurs(String.valueOf(c.getMinOccursEffective()));
                    break;
                }
                compositor.setMaxOccurs("1");
                compositor.setMinOccurs("1");
                break;
            }
            case CHOICE: {
                Choice component = (Choice)compositor.getPeer();
                Cardinality c = component.getCardinality();
                if (c != null) {
                    compositor.setMaxOccurs(c.getMaxOccursEffective());
                    compositor.setMinOccurs(String.valueOf(c.getMinOccursEffective()));
                    break;
                }
                compositor.setMaxOccurs("1");
                compositor.setMinOccurs("1");
                break;
            }
            case ALL: {
                All component = (All)compositor.getPeer();
                compositor.setMinOccurs(String.valueOf(component.getMinOccursEffective()));
                break;
            }
        }
    }

    public static void updateContentModel(ContentModel contentModel) {
        SchemaComponent peer = contentModel.getPeer();
        if (peer instanceof GlobalComplexType) {
            contentModel.setName(((GlobalComplexType)peer).getName());
            return;
        }
        if (peer instanceof GlobalAttributeGroup) {
            contentModel.setName(((GlobalAttributeGroup)peer).getName());
            return;
        }
        if (peer instanceof GlobalGroup) {
            contentModel.setName(((GlobalGroup)peer).getName());
            return;
        }
    }
}

