/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.util.Random;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;

public class JavaExpression {
    public static final String LANGUAGE_JAVA_1_5 = "1.5.0";
    private static final String REPLACE_return = "return01234";
    private static final String REPLACE_class = "class01234";
    static final String RETURN_MACRO = "{return}";
    static final String CLASS_MACRO = "{class}";
    private String strExpression;
    private String language;
    private String replace_return;
    private String replace_class;

    public static JavaExpression parse(String expr, String language) {
        String replace_return = REPLACE_return;
        while (expr.indexOf(replace_return) >= 0) {
            replace_return = "return" + new Random().nextLong();
        }
        String replace_class = REPLACE_class;
        while (expr.indexOf(replace_class) >= 0) {
            replace_class = "class" + new Random().nextLong();
        }
        String replacedExpr = JavaExpression.replaceSpecialVar(expr, RETURN_MACRO, replace_return);
        replacedExpr = JavaExpression.replaceSpecialVar(replacedExpr, CLASS_MACRO, replace_class);
        return new JavaExpression(replacedExpr, language, replace_return, replace_class);
    }

    private static String replaceSpecialVar(String expr, String var, String replace_var) {
        int i = expr.indexOf(var);
        while (i >= 0) {
            char ch;
            boolean replace = i > 0 ? !Character.isJavaIdentifierStart(ch = expr.charAt(i - 1)) && !Character.isJavaIdentifierPart(ch) && ch != '.' : true;
            if (replace && i < expr.length() - var.length() && Character.isJavaIdentifierPart(ch = expr.charAt(i + var.length()))) {
                replace = false;
            }
            if (replace) {
                expr = expr.substring(0, i) + replace_var + expr.substring(i + var.length());
                i += replace_var.length();
            } else {
                i += var.length();
            }
            i = expr.indexOf(var, i);
        }
        return expr;
    }

    private JavaExpression(String expression, String language, String replace_return, String replace_class) {
        this.strExpression = expression;
        this.language = language;
        this.replace_return = replace_return;
        this.replace_class = replace_class;
    }

    public TreeEvaluator evaluator(EvaluationContext context) {
        return new TreeEvaluator(this, context);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getExpression() {
        return this.strExpression;
    }

    String returnReplaced() {
        return this.replace_return;
    }

    String classReplaced() {
        return this.replace_class;
    }
}

