/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi.event;

import com.sun.jdi.InternalException;
import com.sun.jdi.Mirror;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class EventQueueWrapper {
    private EventQueueWrapper() {
    }

    public static EventSet remove(EventQueue a) throws InterruptedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.event.EventQueue", "remove", "JDI CALL: com.sun.jdi.event.EventQueue({0}).remove()", new Object[]{a});
        }
        Object retValue = null;
        try {
            EventSet ret = a.remove();
            retValue = ret;
            EventSet eventSet = ret;
            return eventSet;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InterruptedException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.event.EventQueue", "remove", retValue);
            }
        }
    }

    public static EventSet remove(EventQueue a, long b) throws InterruptedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.event.EventQueue", "remove", "JDI CALL: com.sun.jdi.event.EventQueue({0}).remove({1})", new Object[]{a, b});
        }
        Object retValue = null;
        try {
            EventSet ret = a.remove(b);
            retValue = ret;
            EventSet eventSet = ret;
            return eventSet;
        }
        catch (InternalException ex) {
            retValue = ex;
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            retValue = ex;
            if (a instanceof Mirror) {
                VirtualMachine vm = a.virtualMachine();
                try {
                    vm.dispose();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InterruptedException ex) {
            retValue = ex;
            throw ex;
        }
        catch (Error err) {
            retValue = err;
            throw err;
        }
        catch (RuntimeException rex) {
            retValue = rex;
            throw rex;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.event.EventQueue", "remove", retValue);
            }
        }
    }
}

