/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.impl.spi;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.cnd.search.SearchParams;
import org.netbeans.modules.cnd.search.SearchResult;
import org.netbeans.modules.cnd.search.impl.spi.CNDSearchComposition;
import org.netbeans.modules.cnd.search.impl.spi.CNDSearchProvider;
import org.netbeans.modules.cnd.search.ui.CNDSearchPanel;
import org.netbeans.spi.search.provider.SearchComposition;
import org.netbeans.spi.search.provider.SearchProvider;
import org.openide.NotificationLineSupport;
import org.openide.util.HelpCtx;

public final class CNDSearchPresenter
extends SearchProvider.Presenter {
    private CNDSearchPanel panel = null;

    public CNDSearchPresenter(CNDSearchProvider provider) {
        super((SearchProvider)provider, false);
    }

    public JComponent getForm() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.panel == null) {
            this.panel = new CNDSearchPanel();
            this.panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CNDSearchPresenter.this.fireChange();
                }
            });
        }
        return this.panel;
    }

    public SearchComposition<SearchResult> composeSearch() {
        this.panel.storeSettings();
        SearchPattern searchPattern = this.panel.getSearchPattern();
        String textToFind = searchPattern.getSearchExpression();
        String fileName = this.panel.getFileName();
        String title = textToFind == null || textToFind.isEmpty() ? fileName : textToFind;
        List searchRoots = this.panel.getSearchInfo().getSearchRoots();
        if (searchRoots.isEmpty()) {
            return null;
        }
        SearchParams params = new SearchParams(searchRoots, fileName, searchPattern);
        return new CNDSearchComposition(title, this, params);
    }

    public boolean isUsable(NotificationLineSupport nls) {
        CNDSearchPanel.ValidationStatus status = this.panel.getValidationStatus();
        if (status == CNDSearchPanel.ValidationStatus.OK) {
            nls.clearMessages();
            return true;
        }
        nls.setErrorMessage(status.error);
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("FindinProject");
    }
}

