/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.atmosphere.config.service.EndpointMapperService;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.DefaultEndpointMapper;
import org.atmosphere.util.IOUtils;
import org.primefaces.push.DefaultPushRule;
import org.primefaces.push.PrimeAtmosphereHandler;
import org.primefaces.push.PushRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EndpointMapperService
public class PushEndpointMapper<U>
extends DefaultEndpointMapper<U> {
    private final Logger logger = LoggerFactory.getLogger((String)PushEndpointMapper.class.getName());
    private String servletPath = "";
    private AtmosphereConfig config;
    public static final String RULES = "org.primefaces.push.rules";

    public void configure(AtmosphereConfig config) {
        this.servletPath = IOUtils.guestServletPath((AtmosphereConfig)config);
        config.framework().getAtmosphereConfig().properties().put("servletPath", this.servletPath);
        this.config = config;
    }

    public String computePath(AtmosphereRequest req) {
        String pathInfo = null;
        try {
            pathInfo = req.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? req.getServletPath() + pathInfo : req.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (this.servletPath != null && path.startsWith(this.servletPath)) {
            path = path.substring(this.servletPath.length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public U map(AtmosphereRequest req, Map<String, U> handlers) {
        Object handler;
        String path = this.computePath(req);
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if ((handler = this.match(path, handlers)) == null) {
            handler = this.match(path + (path.endsWith("/") ? "all" : "/all"), handlers);
            if (handler == null && (handler = this.match(path + "*", handlers)) == null) {
                String p;
                String string = p = path.lastIndexOf("/") <= 0 ? "/" : path.substring(0, path.lastIndexOf("/"));
                while (p.length() > 0 && p.indexOf("/") != -1 && (handler = this.match(p, handlers)) == null) {
                    p = p.substring(0, p.lastIndexOf("/"));
                }
            }
        }
        if (handler == null) {
            AtmosphereConfig atmosphereConfig = this.config;
            synchronized (atmosphereConfig) {
                this.logger.trace("Preserving backward PrimeFaces behavior");
                PrimeAtmosphereHandler pah = new PrimeAtmosphereHandler(this.configureRules(this.config.getServletConfig()));
                path = this.computePath(req);
                this.config.framework().addAtmosphereHandler(path, (AtmosphereHandler)pah);
                handler = this.config.framework().getAtmosphereHandlers().get(path);
            }
        }
        req.setAttribute(FrameworkConfig.MAPPED_PATH, (Object)path);
        return (U)handler;
    }

    List<PushRule> configureRules(ServletConfig sc) {
        ArrayList<PushRule> rules = new ArrayList<PushRule>();
        String s = sc.getInitParameter(RULES);
        if (s != null) {
            String[] r;
            for (String rule : r = s.split(",")) {
                try {
                    rules.add((PushRule)IOUtils.loadClass(((Object)((Object)this)).getClass(), (String)rule).newInstance());
                    this.logger.info("PushRule {} loaded", (Object)rule);
                }
                catch (Throwable t) {
                    this.logger.info("Unable to load PushRule {}", (Object)rule, (Object)t);
                }
            }
        }
        if (rules.isEmpty()) {
            rules.add(new DefaultPushRule());
        }
        return rules;
    }
}

