/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class StringArrayCustomEditor
extends JPanel {
    private final ResourceBundle bundle = NbBundle.getBundle(StringArrayCustomEditor.class);
    private final Vector<String> itemsVector;
    private static final int DEFAULT_WIDTH = 400;
    static final long serialVersionUID = -4347656479280614636L;
    private String[] array;
    private final boolean isEmptyAllowed;
    private String defaultValue;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JButton changeButton;
    private JPanel editPanel;
    private JTextField itemField;
    private JLabel itemLabel;
    private JList itemList;
    private JLabel itemListLabel;
    private JScrollPane itemListScroll;
    private JPanel paddingPanel;
    private JButton removeButton;
    private JButton setDefaultButton;

    public StringArrayCustomEditor(String[] array, String defaultValue, String customItemLabel, char customItemLabelMnemonic, String customItemListLabel, char customItemListLabelMnemonic, boolean isEmptyAllowed) {
        this.defaultValue = defaultValue;
        this.isEmptyAllowed = isEmptyAllowed;
        this.itemsVector = new Vector();
        this.array = array;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                this.itemsVector.addElement(array[i]);
            }
        }
        this.initComponents();
        this.itemList.setCellRenderer(new EmptyStringListCellRenderer());
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectionMode(0);
        this.setBorder(new EmptyBorder(new Insets(16, 8, 8, 0)));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        Mnemonics.setLocalizedText((JLabel)this.itemLabel, (String)(customItemLabel != null ? customItemLabel : this.bundle.getString("CTL_Item")));
        Mnemonics.setLocalizedText((JLabel)this.itemListLabel, (String)(customItemListLabel != null ? customItemListLabel : this.bundle.getString("CTL_ItemList")));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)this.bundle.getString("CTL_Add_StringArrayCustomEditor"));
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)this.bundle.getString("CTL_Change_StringArrayCustomEditor"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)this.bundle.getString("CTL_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.setDefaultButton, (String)this.bundle.getString("CTL_SetDefault"));
        if (customItemLabel != null) {
            this.itemLabel.setDisplayedMnemonic(customItemLabelMnemonic);
        }
        if (customItemListLabel != null) {
            this.itemListLabel.setDisplayedMnemonic(customItemListLabelMnemonic);
        }
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_StringArrayCustomEditor"));
        this.itemField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Item"));
        this.itemList.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_ItemList"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Add_StringArrayCustomEditor"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Change_StringArrayCustomEditor"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_Remove"));
        this.setDefaultButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_CTL_SetDefault"));
        this.updateButtons();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension sup = super.getPreferredSize();
        return new Dimension(Math.max(sup.width, 400), sup.height);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.itemField.requestFocusInWindow();
    }

    private void initComponents() {
        this.editPanel = new JPanel();
        this.itemListScroll = new JScrollPane();
        this.itemList = new JList();
        this.itemLabel = new JLabel();
        this.itemField = new JTextField();
        this.itemListLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.removeButton = new JButton();
        this.setDefaultButton = new JButton();
        this.paddingPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.editPanel.setLayout(new GridBagLayout());
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                StringArrayCustomEditor.this.itemListValueChanged(evt);
            }
        });
        this.itemListScroll.setViewportView(this.itemList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editPanel.add((Component)this.itemListScroll, gridBagConstraints);
        this.itemLabel.setLabelFor(this.itemField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 12);
        this.editPanel.add((Component)this.itemLabel, gridBagConstraints);
        this.itemField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringArrayCustomEditor.this.itemFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.editPanel.add((Component)this.itemField, gridBagConstraints);
        this.itemListLabel.setLabelFor(this.itemList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.editPanel.add((Component)this.itemListLabel, gridBagConstraints);
        this.add((Component)this.editPanel, "Center");
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringArrayCustomEditor.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringArrayCustomEditor.this.changeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.buttonsPanel.add((Component)this.changeButton, gridBagConstraints);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringArrayCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.setDefaultButton.setEnabled(false);
        this.setDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringArrayCustomEditor.this.setDefaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.buttonsPanel.add((Component)this.setDefaultButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        this.buttonsPanel.add((Component)this.paddingPanel, gridBagConstraints);
        this.add((Component)this.buttonsPanel, "East");
    }

    private void itemFieldActionPerformed(ActionEvent evt) {
        if (this.itemList.getSelectedIndex() >= 0) {
            this.changeButtonActionPerformed(evt);
        } else {
            this.addButtonActionPerformed(evt);
        }
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        int sel = this.itemList.getSelectedIndex();
        this.itemsVector.removeElementAt(sel);
        this.itemsVector.insertElementAt(this.itemField.getText(), sel);
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectedIndex(sel);
        this.itemList.repaint();
        this.updateValue();
    }

    private void setDefaultButtonActionPerformed(ActionEvent evt) {
        this.defaultValue = (String)this.itemList.getSelectedValue();
        this.setDefaultButton.setEnabled(false);
        this.itemList.repaint();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int currentIndex = this.itemList.getSelectedIndex();
        this.itemsVector.removeElementAt(currentIndex);
        this.itemList.setListData(this.itemsVector);
        if (!this.itemsVector.isEmpty()) {
            if (currentIndex >= this.itemsVector.size()) {
                currentIndex = this.itemsVector.size() - 1;
            }
            this.itemList.setSelectedIndex(currentIndex);
            if (!this.itemsVector.contains(this.defaultValue)) {
                this.defaultValue = this.itemsVector.firstElement();
            }
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void itemListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
        int sel = this.itemList.getSelectedIndex();
        if (sel != -1) {
            this.itemField.setText(this.itemsVector.elementAt(sel));
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String value = this.itemField.getText();
        if (value.length() == 0 || this.itemsVector.contains(value)) {
            return;
        }
        this.itemsVector.addElement(value);
        this.itemList.setListData(this.itemsVector);
        this.itemList.setSelectedIndex(-1);
        this.itemField.setSelectionStart(0);
        this.itemField.setSelectionEnd(this.itemField.getText().length());
        this.itemList.repaint();
        this.updateValue();
    }

    private void updateButtons() {
        int sel = this.itemList.getSelectedIndex();
        if (sel == -1) {
            this.removeButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(this.isEmptyAllowed || this.itemsVector.size() > 1);
            this.setDefaultButton.setEnabled(!this.itemList.getSelectedValue().equals(this.defaultValue));
            this.changeButton.setEnabled(true);
        }
    }

    private void updateValue() {
        this.array = new String[this.itemsVector.size()];
        this.itemsVector.copyInto(this.array);
    }

    public String[] getItemList() {
        this.updateValue();
        return this.array;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    private final class EmptyStringListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        protected Font normalFont;
        protected Font boldFont;
        static final long serialVersionUID = 487512296465844339L;

        public EmptyStringListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
            this.normalFont = this.getFont();
            this.boldFont = this.getFont().deriveFont(1);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof String)) {
                return this;
            }
            String text = (String)value;
            this.setFont(StringArrayCustomEditor.this.defaultValue.equals(text) ? this.boldFont : this.normalFont);
            this.setText(text);
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? this.hasFocusBorder : this.noFocusBorder);
            return this;
        }
    }
}

