/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.spi.PackagingProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.LookupMerger;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenProjectPropsImpl {
    private static final String NAMESPACE = "http://www.netbeans.org/ns/maven-properties-data/1";
    private static final String ROOT = "properties";
    private static final Logger LOG = Logger.getLogger(MavenProjectPropsImpl.class.getName());
    private final AuxiliaryConfiguration aux;
    private boolean sharedChanged;
    private final NbMavenProjectImpl nbprji;
    private Mutex mutex;

    MavenProjectPropsImpl(AuxiliaryConfiguration aux, NbMavenProjectImpl pr) {
        this.aux = aux;
        this.nbprji = pr;
    }

    private AuxiliaryConfiguration getAuxConf() {
        return this.aux;
    }

    public String get(String key, boolean shared) {
        return this.get(key, shared, true);
    }

    public String get(String key, boolean shared, boolean usePom) {
        return (String)this.getMutex().readAccess(() -> {
            TreeMap<String, String> props = this.readProperties(this.getAuxConf(), shared);
            String ret = props.get(key);
            if (ret != null) {
                return ret;
            }
            if (shared && usePom) {
                String val;
                if ("netbeans.hint.packaging".equals(key) && !this.nbprji.isMavenProjectLoaded()) {
                    String val2;
                    Model model;
                    try {
                        model = this.nbprji.getProjectWatcher().getRawModel();
                    }
                    catch (ModelBuildingException ex) {
                        model = null;
                        LOG.log(Level.FINE, null, ex);
                    }
                    String string2 = val2 = model != null ? model.getPackaging() : null;
                    if (val2 != null) {
                        return val2;
                    }
                }
                if ((val = this.nbprji.getOriginalMavenProject().getProperties().getProperty(key)) != null) {
                    return val;
                }
            }
            return null;
        });
    }

    public void put(String key, String value, boolean shared) {
        this.getMutex().writeAccess(() -> {
            if (shared) {
                // empty if block
            }
            this.writeAuxiliaryData(this.getAuxConf(), key, value, shared);
            return null;
        });
    }

    public Iterable<String> listKeys(boolean shared) {
        return (Iterable)this.getMutex().readAccess(() -> {
            TreeMap<String, String> props = this.readProperties(this.getAuxConf(), shared);
            if (shared) {
                Properties mvnprops = this.nbprji.getOriginalMavenProject().getProperties();
                for (Object prop : mvnprops.keySet()) {
                    props.put((String)prop, "any");
                }
            }
            return props.keySet();
        });
    }

    private void writeAuxiliaryData(AuxiliaryConfiguration conf, String property, String value, boolean shared) {
        Element enEl;
        Element el = MavenProjectPropsImpl.getOrCreateRootElement(conf, shared);
        NodeList list = el.getElementsByTagNameNS(NAMESPACE, property);
        if (list.getLength() > 0) {
            enEl = (Element)list.item(0);
        } else {
            try {
                enEl = el.getOwnerDocument().createElementNS(NAMESPACE, property);
            }
            catch (DOMException x) {
                LOG.log(Level.WARNING, "#200901: {0} from {1}", new Object[]{x.getMessage(), property});
                return;
            }
            el.appendChild(enEl);
        }
        if (value != null) {
            enEl.setTextContent(value);
        } else {
            el.removeChild(enEl);
        }
        if (el.getElementsByTagNameNS(NAMESPACE, "*").getLength() > 0) {
            conf.putConfigurationFragment(el, shared);
        } else {
            conf.removeConfigurationFragment(ROOT, NAMESPACE, shared);
        }
    }

    public static void writeAuxiliaryData(AuxiliaryConfiguration conf, TreeMap<String, String> props, boolean shared) {
        Element el = MavenProjectPropsImpl.getOrCreateRootElement(conf, shared);
        for (String key : props.keySet()) {
            Element enEl;
            NodeList list = el.getElementsByTagNameNS(NAMESPACE, key);
            if (list.getLength() > 0) {
                enEl = (Element)list.item(0);
            } else {
                try {
                    enEl = el.getOwnerDocument().createElementNS(NAMESPACE, key);
                }
                catch (DOMException x) {
                    LOG.log(Level.WARNING, "#200901: {0} from {1}", new Object[]{x.getMessage(), key});
                    continue;
                }
                el.appendChild(enEl);
            }
            String value = props.get(key);
            if (value != null) {
                enEl.setTextContent(value);
                continue;
            }
            el.removeChild(enEl);
        }
        if (el.getElementsByTagNameNS(NAMESPACE, "*").getLength() > 0) {
            conf.putConfigurationFragment(el, shared);
        } else {
            conf.removeConfigurationFragment(ROOT, NAMESPACE, shared);
        }
    }

    private static Element getOrCreateRootElement(AuxiliaryConfiguration conf, boolean shared) {
        Element el = conf.getConfigurationFragment(ROOT, NAMESPACE, shared);
        if (el == null) {
            el = XMLUtil.createDocument((String)ROOT, (String)NAMESPACE, null, null).getDocumentElement();
            if (shared) {
                Comment comment = el.getOwnerDocument().createComment("\nProperties that influence various parts of the IDE, especially code formatting and the like. \nYou can copy and paste the single properties, into the pom.xml file and the IDE will pick them up.\nThat way multiple projects can share the same settings (useful for formatting rules for example).\nAny value defined here will override the pom.xml file value but is only applicable to the current project.\n");
                el.appendChild(comment);
            }
        }
        return el;
    }

    private TreeMap<String, String> readProperties(AuxiliaryConfiguration aux, boolean shared) {
        return (TreeMap)this.getMutex().readAccess(() -> {
            NodeList list;
            TreeMap<String, String> props = new TreeMap<String, String>();
            Element el = aux.getConfigurationFragment(ROOT, NAMESPACE, shared);
            if (el != null && (list = el.getChildNodes()).getLength() > 0) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node nd = list.item(i);
                    if (!(nd instanceof Element)) continue;
                    Element enEl = (Element)nd;
                    props.put(enEl.getNodeName(), enEl.getTextContent());
                }
            }
            return props;
        });
    }

    public TreeMap<String, String> getRawProperties(boolean shared) {
        return this.readProperties(this.getAuxConf(), shared);
    }

    private synchronized Mutex getMutex() {
        if (this.mutex == null) {
            this.mutex = new Mutex();
        }
        return this.mutex;
    }

    public static class PackagingProviderImpl
    implements PackagingProvider {
        @Override
        public String packaging(Project project) {
            return ((MavenProjectPropsImpl)project.getLookup().lookup(MavenProjectPropsImpl.class)).get("netbeans.hint.packaging", true);
        }
    }

    private static class MergedAuxProperties
    implements AuxiliaryProperties {
        Lookup.Result<AuxiliaryProperties> props;
        private final MavenProjectPropsImpl primary;

        private MergedAuxProperties(Lookup lookup, MavenProjectPropsImpl primary) {
            this.props = lookup.lookupResult(AuxiliaryProperties.class);
            this.primary = primary;
        }

        public String get(String key, boolean shared) {
            String toRet;
            block1: {
                AuxiliaryProperties prop;
                toRet = this.primary.get(key, shared);
                if (toRet != null) break block1;
                Iterator iterator = this.props.allInstances().iterator();
                while (iterator.hasNext() && (toRet = (prop = (AuxiliaryProperties)iterator.next()).get(key, shared)) == null) {
                }
            }
            return toRet;
        }

        public void put(String key, String value, boolean shared) {
            this.primary.put(key, value, shared);
        }

        public Iterable<String> listKeys(boolean shared) {
            TreeSet<String> toRet = new TreeSet<String>();
            Iterator<String> s = this.primary.listKeys(shared).iterator();
            while (s.hasNext()) {
                toRet.add(s.next());
            }
            for (AuxiliaryProperties aux : this.props.allInstances()) {
                s = aux.listKeys(shared).iterator();
                while (s.hasNext()) {
                    toRet.add(s.next());
                }
            }
            return toRet;
        }
    }

    static class Merger
    implements LookupMerger<AuxiliaryProperties> {
        private final MavenProjectPropsImpl primary;

        Merger(MavenProjectPropsImpl primary) {
            this.primary = primary;
        }

        public Class<AuxiliaryProperties> getMergeableClass() {
            return AuxiliaryProperties.class;
        }

        public AuxiliaryProperties merge(Lookup lookup) {
            return new MergedAuxProperties(lookup, this.primary);
        }
    }
}

